/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.configuration.spring;

import java.util.ArrayList;
import java.util.Collection;
import javax.xml.namespace.QName;
import org.apache.cxf.configuration.spring.AbstractSpringBeanMap;
import org.springframework.beans.Mergeable;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.BeanIsAbstractException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanReference;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringBeanQNameMap<V>
extends AbstractSpringBeanMap<QName, V> {
    @Override
    protected void processBeans(ApplicationContext beanFactory) {
        if (beanFactory == null) {
            return;
        }
        String[] beanNames = beanFactory.getBeanNamesForType(this.type);
        ConfigurableApplicationContext ctxt = (ConfigurableApplicationContext)beanFactory;
        for (int i = 0; i < beanNames.length; ++i) {
            BeanDefinition def = ctxt.getBeanFactory().getBeanDefinition(beanNames[i]);
            if (!beanFactory.isSingleton(beanNames[i]) || def.isAbstract()) continue;
            try {
                ArrayList<Object> ids = null;
                PropertyValue pv = def.getPropertyValues().getPropertyValue(this.idsProperty);
                if (pv != null) {
                    Object value = pv.getValue();
                    if (!(value instanceof Collection)) {
                        throw new RuntimeException("The property " + this.idsProperty + " must be a collection!");
                    }
                    if (value instanceof Mergeable) {
                        if (!((Mergeable)value).isMergeEnabled()) {
                            ids = (ArrayList<Object>)value;
                        }
                    } else {
                        ids = (Collection)value;
                    }
                }
                if (null != ids) {
                    ArrayList<Object> checked = new ArrayList<Object>(ids.size());
                    for (Object e : ids) {
                        if (e instanceof QName) {
                            checked.add(e);
                            continue;
                        }
                        if (!(e instanceof BeanReference)) break;
                        BeanReference br = (BeanReference)e;
                        Object refId = this.context.getBean(br.getBeanName());
                        checked.add(refId);
                    }
                    ids = checked.size() < ids.size() ? null : checked;
                }
                if (ids == null && (ids = this.getIds(ctxt.getBean(beanNames[i]))) == null) continue;
                for (Object e : ids) {
                    QName qName = (QName)e;
                    this.getBeanListForId(qName).add(beanNames[i]);
                }
                continue;
            }
            catch (BeanIsAbstractException e) {
                // empty catch block
            }
        }
        this.processBeans(ctxt.getParent());
    }
}

