/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.spring.configurator.impl;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.cocoon.configuration.Settings;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractElementParser
implements BeanDefinitionParser {
    protected final Log logger = LogFactory.getLog(this.getClass());

    protected String getAttributeValue(Element element, String attributeName, String defaultValue) {
        String value = element.getAttribute(attributeName);
        if (value == null || value.trim().length() == 0) {
            value = defaultValue;
        }
        return value;
    }

    protected Element[] getChildElements(Element element, String localName) {
        ArrayList<Node> elements = new ArrayList<Node>();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !localName.equals(node.getLocalName())) continue;
            elements.add(node);
        }
        return elements.toArray(new Element[elements.size()]);
    }

    protected void register(BeanDefinition beanDef, String beanName, BeanDefinitionRegistry registry) {
        this.register(beanDef, beanName, null, registry);
    }

    protected void register(BeanDefinition beanDef, String beanName, String alias, BeanDefinitionRegistry registry) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Registering bean with name " + beanName + (alias != null ? " (alias=" + alias + ") " : " ") + beanDef));
        }
        BeanDefinitionHolder holder = alias != null ? new BeanDefinitionHolder(beanDef, beanName, new String[]{alias}) : new BeanDefinitionHolder(beanDef, beanName);
        BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)holder, (BeanDefinitionRegistry)registry);
    }

    protected void register(BeanDefinition beanDef, Element element, BeanDefinitionRegistry registry) {
        String beanName;
        String id = element.getAttribute("id");
        String nameAttr = element.getAttribute("name");
        ArrayList<String> aliases = new ArrayList<String>();
        if (StringUtils.hasLength((String)nameAttr)) {
            String[] nameArr = StringUtils.tokenizeToStringArray((String)nameAttr, (String)",; ");
            aliases.addAll(Arrays.asList(nameArr));
        }
        if (!StringUtils.hasText((String)(beanName = id)) && !aliases.isEmpty()) {
            beanName = (String)aliases.remove(0);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("No XML 'id' specified - using '" + beanName + "' as bean name and " + aliases + " as aliases"));
            }
        }
        BeanDefinitionHolder holder = new BeanDefinitionHolder(beanDef, beanName, StringUtils.toStringArray(aliases));
        BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)holder, (BeanDefinitionRegistry)registry);
    }

    protected RootBeanDefinition createBeanDefinition(Class componentClass, String initMethod, boolean requiresSettings) {
        RootBeanDefinition beanDef = new RootBeanDefinition();
        beanDef.setBeanClass(componentClass);
        this.fillBeanDefinition(beanDef, initMethod, requiresSettings);
        return beanDef;
    }

    protected RootBeanDefinition createBeanDefinition(String componentClass, String initMethod, boolean requiresSettings) {
        RootBeanDefinition beanDef = new RootBeanDefinition();
        beanDef.setBeanClassName(componentClass);
        this.fillBeanDefinition(beanDef, initMethod, requiresSettings);
        return beanDef;
    }

    private void fillBeanDefinition(RootBeanDefinition beanDef, String initMethod, boolean requiresSettings) {
        beanDef.setScope("singleton");
        beanDef.setLazyInit(false);
        if (initMethod != null) {
            beanDef.setInitMethodName(initMethod);
        }
        if (requiresSettings) {
            beanDef.getPropertyValues().addPropertyValue("settings", (Object)new RuntimeBeanReference(Settings.ROLE));
        }
    }

    protected void addComponent(Class componentClass, String beanName, String initMethod, boolean requiresSettings, BeanDefinitionRegistry registry) {
        RootBeanDefinition beanDef = this.createBeanDefinition(componentClass, initMethod, requiresSettings);
        this.register((BeanDefinition)beanDef, beanName, registry);
    }

    protected void addComponent(String componentClass, String beanName, String initMethod, boolean requiresSettings, BeanDefinitionRegistry registry) {
        RootBeanDefinition beanDef = this.createBeanDefinition(componentClass, initMethod, requiresSettings);
        this.register((BeanDefinition)beanDef, beanName, registry);
    }
}

