/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.client.bindings.spi.webservices.wss;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.api.pipe.NextAction;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.TubeCloner;
import com.sun.xml.ws.api.pipe.helper.AbstractFilterTubeImpl;
import javax.xml.namespace.QName;
import org.apache.chemistry.opencmis.commons.exceptions.CmisConnectionException;

public class WssMUTube
extends AbstractFilterTubeImpl {
    private static final QName WSSE = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security");
    private final SOAPVersion soapVersion;

    protected WssMUTube(WSBinding binding, Tube next) {
        super(next);
        this.soapVersion = binding.getSOAPVersion();
    }

    protected WssMUTube(WssMUTube that, TubeCloner cloner) {
        super((AbstractFilterTubeImpl)that, cloner);
        this.soapVersion = that.soapVersion;
    }

    public WssMUTube copy(TubeCloner cloner) {
        return new WssMUTube(this, cloner);
    }

    @NotNull
    public NextAction processResponse(Packet response) {
        if (response.getMessage() == null) {
            return super.processResponse(response);
        }
        HeaderList headers = response.getMessage().getHeaders();
        for (int i = 0; i < headers.size(); ++i) {
            Header header;
            if (headers.isUnderstood(i) || (header = headers.get(i)).isIgnorable(this.soapVersion, this.soapVersion.implicitRoleSet)) continue;
            QName qName = new QName(header.getNamespaceURI(), header.getLocalPart());
            if (WSSE.equals(qName)) {
                this.checkSecurityHeader(header);
                continue;
            }
            throw new CmisConnectionException("MustUnderstand header is not understood: " + qName);
        }
        return super.processResponse(response);
    }

    private void checkSecurityHeader(Header header) {
    }
}

