/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.db.Cell;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.SyntaxException;
import org.apache.cassandra.serializers.CollectionSerializer;
import org.apache.cassandra.serializers.MapSerializer;
import org.apache.cassandra.utils.Pair;

public class MapType<K, V>
extends CollectionType<Map<K, V>> {
    private static final Map<Pair<AbstractType<?>, AbstractType<?>>, MapType> instances = new HashMap();
    public final AbstractType<K> keys;
    public final AbstractType<V> values;
    private final MapSerializer<K, V> serializer;

    public static MapType<?, ?> getInstance(TypeParser parser) throws ConfigurationException, SyntaxException {
        List<AbstractType<?>> l = parser.getTypeParameters();
        if (l.size() != 2) {
            throw new ConfigurationException("MapType takes exactly 2 type parameters");
        }
        return MapType.getInstance(l.get(0), l.get(1));
    }

    public static synchronized <K, V> MapType<K, V> getInstance(AbstractType<K> keys, AbstractType<V> values) {
        Pair<AbstractType<K>, AbstractType<V>> p = Pair.create(keys, values);
        MapType<K, V> t = instances.get(p);
        if (t == null) {
            t = new MapType<K, V>(keys, values);
            instances.put(p, t);
        }
        return t;
    }

    private MapType(AbstractType<K> keys, AbstractType<V> values) {
        super(CollectionType.Kind.MAP);
        this.keys = keys;
        this.values = values;
        this.serializer = MapSerializer.getInstance(keys.getSerializer(), values.getSerializer());
    }

    @Override
    public AbstractType<K> nameComparator() {
        return this.keys;
    }

    @Override
    public AbstractType<V> valueComparator() {
        return this.values;
    }

    @Override
    public int compare(ByteBuffer o1, ByteBuffer o2) {
        if (!o1.hasRemaining() || !o2.hasRemaining()) {
            return o1.hasRemaining() ? 1 : (o2.hasRemaining() ? -1 : 0);
        }
        ByteBuffer bb1 = o1.duplicate();
        ByteBuffer bb2 = o2.duplicate();
        int size1 = CollectionSerializer.readCollectionSize(bb1, 3);
        int size2 = CollectionSerializer.readCollectionSize(bb2, 3);
        for (int i = 0; i < Math.min(size1, size2); ++i) {
            ByteBuffer v2;
            ByteBuffer k2;
            ByteBuffer k1 = CollectionSerializer.readValue(bb1, 3);
            int cmp = this.keys.compare(k1, k2 = CollectionSerializer.readValue(bb2, 3));
            if (cmp != 0) {
                return cmp;
            }
            ByteBuffer v1 = CollectionSerializer.readValue(bb1, 3);
            cmp = this.values.compare(v1, v2 = CollectionSerializer.readValue(bb2, 3));
            if (cmp == 0) continue;
            return cmp;
        }
        return size1 == size2 ? 0 : (size1 < size2 ? -1 : 1);
    }

    @Override
    public MapSerializer<K, V> getSerializer() {
        return this.serializer;
    }

    @Override
    public boolean isByteOrderComparable() {
        return this.keys.isByteOrderComparable();
    }

    @Override
    protected void appendToStringBuilder(StringBuilder sb) {
        sb.append(this.getClass().getName()).append(TypeParser.stringifyTypeParameters(Arrays.asList(this.keys, this.values)));
    }

    @Override
    public List<ByteBuffer> serializedValues(List<Cell> cells) {
        ArrayList<ByteBuffer> bbs = new ArrayList<ByteBuffer>(cells.size() * 2);
        for (Cell c : cells) {
            bbs.add(c.name().collectionElement());
            bbs.add(c.value());
        }
        return bbs;
    }
}

