/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.InetAddress;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.WriteResponse;
import org.apache.cassandra.io.util.FastByteArrayInputStream;
import org.apache.cassandra.net.CompactEndpointSerializationHelper;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.net.MessageOut;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.tracing.Tracing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MutationVerbHandler
implements IVerbHandler<Mutation> {
    private static final Logger logger = LoggerFactory.getLogger(MutationVerbHandler.class);

    @Override
    public void doVerb(MessageIn<Mutation> message, int id) {
        try {
            InetAddress replyTo;
            byte[] from = message.parameters.get("FWD_FRM");
            if (from == null) {
                replyTo = message.from;
                byte[] forwardBytes = message.parameters.get("FWD_TO");
                if (forwardBytes != null) {
                    this.forwardToLocalNodes((Mutation)message.payload, message.verb, forwardBytes, message.from);
                }
            } else {
                replyTo = InetAddress.getByAddress(from);
            }
            ((Mutation)message.payload).apply();
            WriteResponse response = new WriteResponse();
            Tracing.trace("Enqueuing response to {}", replyTo);
            MessagingService.instance().sendReply(response.createMessage(), id, replyTo);
        }
        catch (IOException e) {
            logger.error("Error in mutation", (Throwable)e);
        }
    }

    private void forwardToLocalNodes(Mutation mutation, MessagingService.Verb verb, byte[] forwardBytes, InetAddress from) throws IOException {
        DataInputStream in = new DataInputStream(new FastByteArrayInputStream(forwardBytes));
        int size = in.readInt();
        MessageOut<Mutation> message = new MessageOut<Mutation>(verb, mutation, Mutation.serializer).withParameter("FWD_FRM", from.getAddress());
        for (int i = 0; i < size; ++i) {
            InetAddress address = CompactEndpointSerializationHelper.deserialize(in);
            int id = in.readInt();
            Tracing.trace("Enqueuing forwarded write to {}", address);
            MessagingService.instance().sendOneWay(message, id, address);
        }
    }
}

