/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.streaming;

import com.ning.compress.lzf.LZFInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Collections;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.compaction.CompactionController;
import org.apache.cassandra.db.compaction.PrecompactedRow;
import org.apache.cassandra.io.sstable.SSTableIdentityIterator;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.sstable.SSTableWriter;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.streaming.OperationType;
import org.apache.cassandra.streaming.PendingFile;
import org.apache.cassandra.streaming.StreamHeader;
import org.apache.cassandra.streaming.StreamIn;
import org.apache.cassandra.streaming.StreamInSession;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.BytesReadTracker;
import org.apache.cassandra.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncomingStreamReader {
    private static final Logger logger = LoggerFactory.getLogger(IncomingStreamReader.class);
    protected final PendingFile localFile;
    protected final PendingFile remoteFile;
    protected final StreamInSession session;
    private final Socket socket;

    public IncomingStreamReader(StreamHeader header, Socket socket) throws IOException {
        this.socket = socket;
        InetSocketAddress remoteAddress = (InetSocketAddress)socket.getRemoteSocketAddress();
        this.session = StreamInSession.get(remoteAddress.getAddress(), header.sessionId);
        this.session.addFiles(header.pendingFiles);
        this.session.setCurrentFile(header.file);
        this.session.setTable(header.table);
        this.remoteFile = header.file;
        this.localFile = this.remoteFile != null ? StreamIn.getContextMapping(this.remoteFile) : null;
    }

    public void read() throws IOException {
        if (this.remoteFile != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Receiving stream");
                logger.debug("Creating file for {} with {} estimated keys", (Object)this.localFile.getFilename(), (Object)this.remoteFile.estimatedKeys);
            }
            assert (this.remoteFile.estimatedKeys > 0L);
            SSTableReader reader = null;
            logger.debug("Estimated keys {}", (Object)this.remoteFile.estimatedKeys);
            DataInputStream dis = new DataInputStream((InputStream)new LZFInputStream(this.socket.getInputStream()));
            try {
                reader = this.streamIn(dis, this.localFile, this.remoteFile);
            }
            catch (IOException ex) {
                this.retry();
                throw ex;
            }
            finally {
                dis.close();
            }
            this.session.finished(this.remoteFile, reader);
        }
        this.session.closeIfFinished();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SSTableReader streamIn(DataInput input, PendingFile localFile, PendingFile remoteFile) throws IOException {
        ColumnFamilyStore cfs = Table.open(localFile.desc.ksname).getColumnFamilyStore(localFile.desc.cfname);
        SSTableWriter writer = new SSTableWriter(localFile.getFilename(), remoteFile.estimatedKeys);
        CompactionController controller = null;
        try {
            BytesReadTracker in = new BytesReadTracker(input);
            for (Pair<Long, Long> section : localFile.sections) {
                long length = (Long)section.right - (Long)section.left;
                long bytesRead = 0L;
                while (bytesRead < length) {
                    in.reset(0L);
                    DecoratedKey key = SSTableReader.decodeKey(StorageService.getPartitioner(), localFile.desc, ByteBufferUtil.readWithShortLength(in));
                    long dataSize = SSTableReader.readRowSize(in, localFile.desc);
                    ColumnFamily cached = cfs.getRawCachedRow(key);
                    if (cached != null && remoteFile.type == OperationType.AES && dataSize <= (long)DatabaseDescriptor.getInMemoryCompactionLimit()) {
                        if (controller == null) {
                            controller = new CompactionController(cfs, Collections.<SSTableReader>emptyList(), Integer.MAX_VALUE, true);
                        }
                        SSTableIdentityIterator iter = new SSTableIdentityIterator(cfs.metadata, in, key, 0L, dataSize, true);
                        PrecompactedRow row = new PrecompactedRow(controller, Collections.singletonList(iter));
                        writer.append(row);
                        writer.updateMaxTimestamp(row.maxTimestamp());
                        ColumnFamily cf = row.getFullColumnFamily();
                        cfs.updateRowCache(key, cf);
                    } else {
                        writer.appendFromStream(key, cfs.metadata, dataSize, in);
                        cfs.invalidateCachedRow(key);
                    }
                    bytesRead += in.getBytesRead();
                    remoteFile.progress += in.getBytesRead();
                }
            }
            SSTableReader sSTableReader = writer.closeAndOpenReader();
            return sSTableReader;
        }
        finally {
            writer.cleanupIfNecessary();
        }
    }

    private void retry() throws IOException {
        this.session.retry(this.remoteFile);
        FileUtils.deleteWithConfirm(new File(this.localFile.getFilename()));
    }
}

