/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.apache.cassandra.db.commitlog.ReplayPosition;
import org.apache.cassandra.io.ICompactSerializer2;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.utils.EstimatedHistogram;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSTableMetadata {
    private static Logger logger = LoggerFactory.getLogger(SSTableMetadata.class);
    protected final EstimatedHistogram estimatedRowSize;
    protected final EstimatedHistogram estimatedColumnCount;
    protected final ReplayPosition replayPosition;
    protected final long maxTimestamp;
    public static final SSTableMetadataSerializer serializer = new SSTableMetadataSerializer();

    private SSTableMetadata() {
        this(SSTableMetadata.defaultRowHistogram(), SSTableMetadata.defaultColumnHistogram(), ReplayPosition.NONE);
    }

    private SSTableMetadata(EstimatedHistogram rowSizes, EstimatedHistogram columnCounts, ReplayPosition replayPosition) {
        this(rowSizes, columnCounts, replayPosition, Long.MAX_VALUE);
    }

    private SSTableMetadata(EstimatedHistogram rowSizes, EstimatedHistogram columnCounts, ReplayPosition replayPosition, long maxTimestamp) {
        this.estimatedRowSize = rowSizes;
        this.estimatedColumnCount = columnCounts;
        this.replayPosition = replayPosition;
        this.maxTimestamp = maxTimestamp;
    }

    public static SSTableMetadata createDefaultInstance() {
        return new SSTableMetadata();
    }

    public static Collector createCollector() {
        return new Collector();
    }

    public EstimatedHistogram getEstimatedRowSize() {
        return this.estimatedRowSize;
    }

    public EstimatedHistogram getEstimatedColumnCount() {
        return this.estimatedColumnCount;
    }

    public ReplayPosition getReplayPosition() {
        return this.replayPosition;
    }

    public long getMaxTimestamp() {
        return this.maxTimestamp;
    }

    static EstimatedHistogram defaultColumnHistogram() {
        return new EstimatedHistogram(114);
    }

    static EstimatedHistogram defaultRowHistogram() {
        return new EstimatedHistogram(150);
    }

    public static class SSTableMetadataSerializer
    implements ICompactSerializer2<SSTableMetadata> {
        private static final Logger logger = LoggerFactory.getLogger(SSTableMetadataSerializer.class);

        @Override
        public void serialize(SSTableMetadata sstableStats, DataOutput dos) throws IOException {
            EstimatedHistogram.serializer.serialize(sstableStats.getEstimatedRowSize(), dos);
            EstimatedHistogram.serializer.serialize(sstableStats.getEstimatedColumnCount(), dos);
            ReplayPosition.serializer.serialize(sstableStats.getReplayPosition(), dos);
            dos.writeLong(sstableStats.getMaxTimestamp());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SSTableMetadata deserialize(Descriptor descriptor) throws IOException {
            DataInputStream dis;
            block4: {
                SSTableMetadata sSTableMetadata;
                File statsFile = new File(descriptor.filenameFor(SSTable.COMPONENT_STATS));
                if (!statsFile.exists()) {
                    logger.debug("No sstable stats for {}", (Object)descriptor);
                    return new SSTableMetadata();
                }
                dis = null;
                try {
                    logger.debug("Load metadata for {}", (Object)descriptor);
                    dis = new DataInputStream(new BufferedInputStream(new FileInputStream(statsFile)));
                    if (descriptor.usesHistogramAndReplayPositionStatsFile) break block4;
                    sSTableMetadata = this.deserialize(dis);
                }
                catch (Throwable throwable) {
                    FileUtils.closeQuietly(dis);
                    throw throwable;
                }
                FileUtils.closeQuietly(dis);
                return sSTableMetadata;
            }
            EstimatedHistogram rowSizes = EstimatedHistogram.serializer.deserialize(dis);
            EstimatedHistogram columnCounts = EstimatedHistogram.serializer.deserialize(dis);
            ReplayPosition replayPosition = descriptor.hasReplayPosition() ? ReplayPosition.serializer.deserialize(dis) : ReplayPosition.NONE;
            SSTableMetadata sSTableMetadata = new SSTableMetadata(rowSizes, columnCounts, replayPosition);
            FileUtils.closeQuietly(dis);
            return sSTableMetadata;
        }

        @Override
        public SSTableMetadata deserialize(DataInput dis) throws IOException {
            EstimatedHistogram rowSizes = EstimatedHistogram.serializer.deserialize(dis);
            EstimatedHistogram columnCounts = EstimatedHistogram.serializer.deserialize(dis);
            ReplayPosition replayPosition = ReplayPosition.serializer.deserialize(dis);
            long maxTimestamp = dis.readLong();
            return new SSTableMetadata(rowSizes, columnCounts, replayPosition, maxTimestamp);
        }
    }

    public static class Collector {
        protected EstimatedHistogram estimatedRowSize = SSTableMetadata.defaultColumnHistogram();
        protected EstimatedHistogram estimatedColumnCount = SSTableMetadata.defaultRowHistogram();
        protected ReplayPosition replayPosition = ReplayPosition.NONE;
        protected long maxTimestamp = Long.MIN_VALUE;

        private Collector() {
        }

        public void addRowSize(long rowSize) {
            this.estimatedRowSize.add(rowSize);
        }

        public void addColumnCount(long columnCount) {
            this.estimatedColumnCount.add(columnCount);
        }

        public void updateMaxTimestamp(long potentialMax) {
            this.maxTimestamp = Math.max(this.maxTimestamp, potentialMax);
        }

        public SSTableMetadata finalizeMetadata() {
            return new SSTableMetadata(this.estimatedRowSize, this.estimatedColumnCount, this.replayPosition, this.maxTimestamp);
        }

        public Collector estimatedRowSize(EstimatedHistogram estimatedRowSize) {
            this.estimatedRowSize = estimatedRowSize;
            return this;
        }

        public Collector estimatedColumnCount(EstimatedHistogram estimatedColumnCount) {
            this.estimatedColumnCount = estimatedColumnCount;
            return this;
        }

        public Collector replayPosition(ReplayPosition replayPosition) {
            this.replayPosition = replayPosition;
            return this;
        }
    }
}

