/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.dht;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.io.ICompactSerializer2;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.ByteBufferUtil;

public abstract class Token<T>
implements Comparable<Token<T>>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final TokenSerializer serializer = new TokenSerializer();
    public final T token;

    public static TokenSerializer serializer() {
        return serializer;
    }

    protected Token(T token) {
        this.token = token;
    }

    @Override
    public abstract int compareTo(Token<T> var1);

    public String toString() {
        return this.token.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Token)) {
            return false;
        }
        return this.token.equals(((Token)obj).token);
    }

    public int hashCode() {
        return this.token.hashCode();
    }

    public static class TokenSerializer
    implements ICompactSerializer2<Token> {
        @Override
        public void serialize(Token token, DataOutput dos) throws IOException {
            IPartitioner p = StorageService.getPartitioner();
            ByteBuffer b = p.getTokenFactory().toByteArray(token);
            ByteBufferUtil.writeWithLength(b, dos);
        }

        @Override
        public Token deserialize(DataInput dis) throws IOException {
            IPartitioner p = StorageService.getPartitioner();
            int size = dis.readInt();
            byte[] bytes = new byte[size];
            dis.readFully(bytes);
            return p.getTokenFactory().fromByteArray(ByteBuffer.wrap(bytes));
        }
    }

    public static abstract class TokenFactory<T> {
        public abstract ByteBuffer toByteArray(Token<T> var1);

        public abstract Token<T> fromByteArray(ByteBuffer var1);

        public abstract String toString(Token<T> var1);

        public abstract Token<T> fromString(String var1);

        public abstract void validate(String var1) throws ConfigurationException;
    }
}

