/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.health;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.health.HealthCheckResultBuilder;
import org.apache.camel.impl.health.AbstractHealthCheck;
import org.apache.camel.spi.annotations.JdkService;

@JdkService(value="context-health-check")
public final class ContextHealthCheck
extends AbstractHealthCheck {
    private CamelContext camelContext;

    public ContextHealthCheck() {
        super("camel", "context");
    }

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public boolean isLiveness() {
        return false;
    }

    @Override
    protected void doCall(HealthCheckResultBuilder builder, Map<String, Object> options) {
        builder.unknown();
        if (this.camelContext != null) {
            builder.detail("context.name", (Object)this.camelContext.getName());
            builder.detail("context.version", (Object)this.camelContext.getVersion());
            builder.detail("context.status", (Object)this.camelContext.getStatus().name());
            if (this.camelContext.getStatus().isStarted()) {
                builder.up();
            } else if (this.camelContext.getStatus().isStopped()) {
                builder.down();
            }
        }
    }
}

