/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.health;

import java.util.Map;
import org.apache.camel.Consumer;
import org.apache.camel.Route;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckAware;
import org.apache.camel.health.HealthCheckResultBuilder;
import org.apache.camel.impl.health.RouteHealthCheck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerHealthCheck
extends RouteHealthCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsumerHealthCheck.class);
    private final Consumer consumer;

    public ConsumerHealthCheck(Route route, String id) {
        super(route, id);
        this.consumer = route.getConsumer();
    }

    @Override
    protected void doCallCheck(HealthCheckResultBuilder builder, Map<String, Object> options) {
        HealthCheck hc;
        boolean up;
        boolean bl = up = builder.state().compareTo((Enum)HealthCheck.State.UP) == 0;
        if (up && this.consumer instanceof HealthCheckAware && (hc = ((HealthCheckAware)this.consumer).getHealthCheck()) != null) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Calling HealthCheck on consumer route: {}", (Object)this.route.getRouteId());
            }
            HealthCheck.Result result = hc.call();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("HealthCheck consumer route: {} -> {}", (Object)this.route.getRouteId(), (Object)result.getState());
            }
            builder.state(result.getState());
            if (result.getMessage().isPresent()) {
                builder.message((String)result.getMessage().get());
            }
            if (result.getError().isPresent()) {
                builder.error((Throwable)result.getError().get());
            }
            builder.details(result.getDetails());
        }
    }
}

