/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region;

import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.broker.region.policy.SimpleDispatchSelector;
import org.apache.activemq.command.ActiveMQDestination;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueueDispatchSelector
extends SimpleDispatchSelector {
    private static final Logger LOG = LoggerFactory.getLogger(QueueDispatchSelector.class);
    private Subscription exclusiveConsumer;

    public QueueDispatchSelector(ActiveMQDestination destination) {
        super(destination);
    }

    public Subscription getExclusiveConsumer() {
        return this.exclusiveConsumer;
    }

    public void setExclusiveConsumer(Subscription exclusiveConsumer) {
        this.exclusiveConsumer = exclusiveConsumer;
    }

    public boolean isExclusiveConsumer(Subscription s) {
        return s == this.exclusiveConsumer;
    }

    public boolean canSelect(Subscription subscription, MessageReference m) throws Exception {
        boolean result = super.canDispatch(subscription, m);
        if (result && !subscription.isBrowser()) {
            result = this.exclusiveConsumer == null || this.exclusiveConsumer == subscription;
        }
        return result;
    }
}

