/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.camel.component;

import java.net.URISyntaxException;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.Service;
import org.apache.activemq.camel.component.ActiveMQConfiguration;
import org.apache.activemq.camel.component.CamelEndpointLoader;
import org.apache.camel.CamelContext;
import org.apache.camel.component.jms.JmsComponent;
import org.apache.camel.component.jms.JmsConfiguration;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.springframework.jms.connection.SingleConnectionFactory;

public class ActiveMQComponent
extends JmsComponent {
    private final CopyOnWriteArrayList<SingleConnectionFactory> singleConnectionFactoryList = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<Service> pooledConnectionFactoryServiceList = new CopyOnWriteArrayList();
    private boolean exposeAllQueues;
    private CamelEndpointLoader endpointLoader;

    public static ActiveMQComponent activeMQComponent() {
        return new ActiveMQComponent();
    }

    public static ActiveMQComponent activeMQComponent(String brokerURL) {
        ActiveMQComponent answer = new ActiveMQComponent();
        if (answer.getConfiguration() instanceof ActiveMQConfiguration) {
            ((ActiveMQConfiguration)answer.getConfiguration()).setBrokerURL(brokerURL);
        }
        answer.setConnectionFactory(new ActiveMQConnectionFactory(brokerURL));
        return answer;
    }

    public ActiveMQComponent() {
    }

    public ActiveMQComponent(CamelContext context) {
        super(context);
    }

    public ActiveMQComponent(ActiveMQConfiguration configuration) {
        super((JmsConfiguration)configuration);
    }

    public void setBrokerURL(String brokerURL) {
        if (this.getConfiguration() instanceof ActiveMQConfiguration) {
            ((ActiveMQConfiguration)this.getConfiguration()).setBrokerURL(brokerURL);
        }
    }

    public void setUserName(String userName) {
        if (this.getConfiguration() instanceof ActiveMQConfiguration) {
            ((ActiveMQConfiguration)this.getConfiguration()).setUserName(userName);
        }
    }

    public void setPassword(String password) {
        if (this.getConfiguration() instanceof ActiveMQConfiguration) {
            ((ActiveMQConfiguration)this.getConfiguration()).setPassword(password);
        }
    }

    public boolean isExposeAllQueues() {
        return this.exposeAllQueues;
    }

    public void setExposeAllQueues(boolean exposeAllQueues) {
        this.exposeAllQueues = exposeAllQueues;
    }

    public void setUsePooledConnection(boolean usePooledConnection) {
        if (this.getConfiguration() instanceof ActiveMQConfiguration) {
            ((ActiveMQConfiguration)this.getConfiguration()).setUsePooledConnection(usePooledConnection);
        }
    }

    public void setUseSingleConnection(boolean useSingleConnection) {
        if (this.getConfiguration() instanceof ActiveMQConfiguration) {
            ((ActiveMQConfiguration)this.getConfiguration()).setUseSingleConnection(useSingleConnection);
        }
    }

    protected void addPooledConnectionFactoryService(Service pooledConnectionFactoryService) {
        this.pooledConnectionFactoryServiceList.add(pooledConnectionFactoryService);
    }

    protected void addSingleConnectionFactory(SingleConnectionFactory singleConnectionFactory) {
        this.singleConnectionFactoryList.add(singleConnectionFactory);
    }

    protected String convertPathToActualDestination(String path, Map<String, Object> parameters) {
        String query;
        Map options = IntrospectionSupport.extractProperties(parameters, (String)"destination.");
        try {
            query = URISupport.createQueryString((Map)options);
        }
        catch (URISyntaxException e) {
            throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
        }
        if (ObjectHelper.isNotEmpty((Object)query)) {
            return path + "?" + query;
        }
        return path;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.isExposeAllQueues()) {
            this.endpointLoader = new CamelEndpointLoader(this.getCamelContext());
            this.endpointLoader.afterPropertiesSet();
        }
    }

    protected void doStop() throws Exception {
        if (this.endpointLoader != null) {
            this.endpointLoader.destroy();
            this.endpointLoader = null;
        }
        for (Service service : this.pooledConnectionFactoryServiceList) {
            service.stop();
        }
        this.pooledConnectionFactoryServiceList.clear();
        for (SingleConnectionFactory singleConnectionFactory : this.singleConnectionFactoryList) {
            singleConnectionFactory.destroy();
        }
        this.singleConnectionFactoryList.clear();
        super.doStop();
    }

    public void setConfiguration(JmsConfiguration configuration) {
        if (configuration instanceof ActiveMQConfiguration) {
            ((ActiveMQConfiguration)configuration).setActiveMQComponent(this);
        }
        super.setConfiguration(configuration);
    }

    protected JmsConfiguration createConfiguration() {
        ActiveMQConfiguration answer = new ActiveMQConfiguration();
        answer.setActiveMQComponent(this);
        return answer;
    }
}

