/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.kahadb.disk.index;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.store.kahadb.disk.index.HashBin;
import org.apache.activemq.store.kahadb.disk.index.Index;
import org.apache.activemq.store.kahadb.disk.page.Page;
import org.apache.activemq.store.kahadb.disk.page.PageFile;
import org.apache.activemq.store.kahadb.disk.page.Transaction;
import org.apache.activemq.store.kahadb.disk.util.Marshaller;
import org.apache.activemq.store.kahadb.disk.util.VariableMarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HashIndex<Key, Value>
implements Index<Key, Value> {
    public static final int CLOSED_STATE = 1;
    public static final int OPEN_STATE = 2;
    private static final Logger LOG = LoggerFactory.getLogger(HashIndex.class);
    public static final int DEFAULT_BIN_CAPACITY = Integer.parseInt(System.getProperty("defaultBinSize", "1024"));
    public static final int DEFAULT_MAXIMUM_BIN_CAPACITY = Integer.parseInt(System.getProperty("maximumCapacity", "16384"));
    public static final int DEFAULT_MINIMUM_BIN_CAPACITY = Integer.parseInt(System.getProperty("minimumCapacity", "16"));
    public static final int DEFAULT_LOAD_FACTOR = Integer.parseInt(System.getProperty("defaultLoadFactor", "75"));
    private AtomicBoolean loaded = new AtomicBoolean();
    private int increaseThreshold;
    private int decreaseThreshold;
    private int maximumBinCapacity = DEFAULT_MAXIMUM_BIN_CAPACITY;
    private int minimumBinCapacity = DEFAULT_MINIMUM_BIN_CAPACITY;
    private int loadFactor = DEFAULT_LOAD_FACTOR;
    private PageFile pageFile;
    private long pageId;
    private Metadata metadata = new Metadata();
    private Metadata.Marshaller metadataMarshaller = new Metadata.Marshaller();
    private HashBin.Marshaller<Key, Value> hashBinMarshaller = new HashBin.Marshaller(this);
    private volatile Marshaller<Key> keyMarshaller;
    private Marshaller<Value> valueMarshaller;

    public HashIndex(PageFile pageFile, long pageId) throws IOException {
        this.pageFile = pageFile;
        this.pageId = pageId;
    }

    @Override
    public synchronized void load(Transaction tx) throws IOException {
        if (this.loaded.compareAndSet(false, true)) {
            Page<Metadata> metadataPage = tx.load(this.pageId, this.metadataMarshaller);
            if (metadataPage.getType() == 0) {
                Page binPage = tx.allocate(this.metadata.binCapacity);
                this.metadata.binPageId = binPage.getPageId();
                this.metadata.page = metadataPage;
                metadataPage.set(this.metadata);
                this.clear(tx);
            } else {
                this.metadata = metadataPage.get();
                this.metadata.page = metadataPage;
                if (this.metadata.state == 2) {
                    this.metadata.size = 0;
                    for (int i2 = 0; i2 < this.metadata.binCapacity; ++i2) {
                        int t = this.sizeOfBin(tx, i2);
                        if (t > 0) {
                            ++this.metadata.binsActive;
                        }
                        this.metadata.size += t;
                    }
                }
            }
            this.calcThresholds();
            this.metadata.state = 2;
            tx.store(metadataPage, this.metadataMarshaller, true);
            LOG.debug("HashIndex loaded. Using " + this.metadata.binCapacity + " bins starting at page " + this.metadata.binPageId);
        }
    }

    @Override
    public synchronized void unload(Transaction tx) throws IOException {
        if (this.loaded.compareAndSet(true, false)) {
            this.metadata.state = 1;
            tx.store(this.metadata.page, this.metadataMarshaller, true);
        }
    }

    private int sizeOfBin(Transaction tx, int index) throws IOException {
        return this.getBin(tx, index).size();
    }

    @Override
    public synchronized Value get(Transaction tx, Key key) throws IOException {
        this.assertLoaded();
        return this.getBin(tx, key).get(key);
    }

    @Override
    public synchronized boolean containsKey(Transaction tx, Key key) throws IOException {
        this.assertLoaded();
        return this.getBin(tx, key).containsKey(key);
    }

    @Override
    public synchronized Value put(Transaction tx, Key key, Value value) throws IOException {
        this.assertLoaded();
        HashBin<Key, Value> bin = this.getBin(tx, key);
        int originalSize = bin.size();
        Value result = bin.put(key, value);
        this.store(tx, bin);
        int newSize = bin.size();
        if (newSize != originalSize) {
            ++this.metadata.size;
            if (newSize == 1) {
                ++this.metadata.binsActive;
            }
        }
        if (this.metadata.binsActive >= this.increaseThreshold && this.metadata.binCapacity != (newSize = Math.min(this.maximumBinCapacity, this.metadata.binCapacity * 2))) {
            this.resize(tx, newSize);
        }
        return result;
    }

    @Override
    public synchronized Value remove(Transaction tx, Key key) throws IOException {
        this.assertLoaded();
        HashBin<Key, Value> bin = this.getBin(tx, key);
        int originalSize = bin.size();
        Value result = bin.remove(key);
        int newSize = bin.size();
        if (newSize != originalSize) {
            this.store(tx, bin);
            --this.metadata.size;
            if (newSize == 0) {
                --this.metadata.binsActive;
            }
        }
        if (this.metadata.binsActive <= this.decreaseThreshold && this.metadata.binCapacity != (newSize = Math.max(this.minimumBinCapacity, this.metadata.binCapacity / 2))) {
            this.resize(tx, newSize);
        }
        return result;
    }

    @Override
    public synchronized void clear(Transaction tx) throws IOException {
        this.assertLoaded();
        for (int i2 = 0; i2 < this.metadata.binCapacity; ++i2) {
            long pageId = this.metadata.binPageId + (long)i2;
            this.clearBinAtPage(tx, pageId);
        }
        this.metadata.size = 0;
        this.metadata.binsActive = 0;
    }

    @Override
    public Iterator<Map.Entry<Key, Value>> iterator(Transaction tx) throws IOException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    private void clearBinAtPage(Transaction tx, long pageId) throws IOException {
        Page page = tx.load(pageId, null);
        HashBin bin = new HashBin();
        bin.setPage(page);
        page.set(bin);
        this.store(tx, bin);
    }

    public String toString() {
        String str = "HashIndex" + System.identityHashCode(this) + ": " + this.pageFile;
        return str;
    }

    private void assertLoaded() throws IllegalStateException {
        if (!this.loaded.get()) {
            throw new IllegalStateException("The HashIndex is not loaded");
        }
    }

    public synchronized void store(Transaction tx, HashBin<Key, Value> bin) throws IOException {
        tx.store(bin.getPage(), this.hashBinMarshaller, true);
    }

    private void resize(Transaction tx, int newSize) throws IOException {
        int i2;
        LOG.debug("Resizing to: " + newSize);
        int resizeCapacity = newSize;
        long resizePageId = tx.allocate(resizeCapacity).getPageId();
        for (i2 = 0; i2 < resizeCapacity; ++i2) {
            long pageId = resizePageId + (long)i2;
            this.clearBinAtPage(tx, pageId);
        }
        this.metadata.binsActive = 0;
        for (i2 = 0; i2 < this.metadata.binCapacity; ++i2) {
            HashBin<Key, Value> bin = this.getBin(tx, i2);
            for (Map.Entry<Key, Value> entry : bin.getAll(tx).entrySet()) {
                HashBin<Key, Value> resizeBin = this.getBin(tx, entry.getKey(), resizePageId, resizeCapacity);
                resizeBin.put(entry.getKey(), entry.getValue());
                this.store(tx, resizeBin);
                if (resizeBin.size() != 1) continue;
                ++this.metadata.binsActive;
            }
        }
        tx.free(this.metadata.binPageId, this.metadata.binCapacity);
        this.metadata.binCapacity = resizeCapacity;
        this.metadata.binPageId = resizePageId;
        this.metadata.state = 2;
        tx.store(this.metadata.page, this.metadataMarshaller, true);
        this.calcThresholds();
        LOG.debug("Resizing done.  New bins start at: " + this.metadata.binPageId);
        resizeCapacity = 0;
        resizePageId = 0L;
    }

    private void calcThresholds() {
        this.increaseThreshold = this.metadata.binCapacity * this.loadFactor / 100;
        this.decreaseThreshold = this.metadata.binCapacity * this.loadFactor * this.loadFactor / 20000;
    }

    private HashBin<Key, Value> getBin(Transaction tx, Key key) throws IOException {
        return this.getBin(tx, key, this.metadata.binPageId, this.metadata.binCapacity);
    }

    private HashBin<Key, Value> getBin(Transaction tx, int i2) throws IOException {
        return this.getBin(tx, i2, this.metadata.binPageId);
    }

    private HashBin<Key, Value> getBin(Transaction tx, Key key, long basePage, int capacity) throws IOException {
        int i2 = this.indexFor(key, capacity);
        return this.getBin(tx, i2, basePage);
    }

    private HashBin<Key, Value> getBin(Transaction tx, int i2, long basePage) throws IOException {
        Page page = tx.load(basePage + (long)i2, this.hashBinMarshaller);
        HashBin rc = (HashBin)page.get();
        rc.setPage(page);
        return rc;
    }

    int indexFor(Key x, int length) {
        return Math.abs(x.hashCode() % length);
    }

    public Marshaller<Key> getKeyMarshaller() {
        return this.keyMarshaller;
    }

    @Override
    public void setKeyMarshaller(Marshaller<Key> marshaller) {
        this.keyMarshaller = marshaller;
    }

    public Marshaller<Value> getValueMarshaller() {
        return this.valueMarshaller;
    }

    @Override
    public void setValueMarshaller(Marshaller<Value> valueMarshaller) {
        this.valueMarshaller = valueMarshaller;
    }

    public int getBinCapacity() {
        return this.metadata.binCapacity;
    }

    public void setBinCapacity(int binCapacity) {
        if (this.loaded.get() && binCapacity != this.metadata.binCapacity) {
            throw new RuntimeException("Pages already loaded - can't reset bin capacity");
        }
        this.metadata.binCapacity = binCapacity;
    }

    @Override
    public boolean isTransient() {
        return false;
    }

    public int getLoadFactor() {
        return this.loadFactor;
    }

    public void setLoadFactor(int loadFactor) {
        this.loadFactor = loadFactor;
    }

    public int setMaximumBinCapacity() {
        return this.maximumBinCapacity;
    }

    public void setMaximumBinCapacity(int maximumCapacity) {
        this.maximumBinCapacity = maximumCapacity;
    }

    public synchronized int size(Transaction tx) {
        return this.metadata.size;
    }

    public synchronized int getActiveBins() {
        return this.metadata.binsActive;
    }

    public long getBinPageId() {
        return this.metadata.binPageId;
    }

    public PageFile getPageFile() {
        return this.pageFile;
    }

    public int getBinsActive() {
        return this.metadata.binsActive;
    }

    static class Metadata {
        private Page<Metadata> page;
        private int state;
        private long binPageId;
        private int binCapacity = DEFAULT_BIN_CAPACITY;
        private int binsActive;
        private int size;

        Metadata() {
        }

        public void read(DataInput is) throws IOException {
            this.state = is.readInt();
            this.binPageId = is.readLong();
            this.binCapacity = is.readInt();
            this.size = is.readInt();
            this.binsActive = is.readInt();
        }

        public void write(DataOutput os) throws IOException {
            os.writeInt(this.state);
            os.writeLong(this.binPageId);
            os.writeInt(this.binCapacity);
            os.writeInt(this.size);
            os.writeInt(this.binsActive);
        }

        static class Marshaller
        extends VariableMarshaller<Metadata> {
            Marshaller() {
            }

            @Override
            public Metadata readPayload(DataInput dataIn) throws IOException {
                Metadata rc = new Metadata();
                rc.read(dataIn);
                return rc;
            }

            @Override
            public void writePayload(Metadata object, DataOutput dataOut) throws IOException {
                object.write(dataOut);
            }
        }
    }
}

