/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.jms.pool;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.Connection;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Session;
import org.apache.activemq.jms.pool.PooledSession;
import org.apache.activemq.jms.pool.SessionKey;
import org.apache.commons.pool.KeyedObjectPool;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionPool {
    private static final transient Logger LOG = LoggerFactory.getLogger(ConnectionPool.class);
    protected Connection connection;
    private int referenceCount;
    private long lastUsed;
    private final long firstUsed;
    private boolean hasExpired;
    private int idleTimeout;
    private long expiryTimeout;
    private boolean useAnonymousProducers;
    private final AtomicBoolean started;
    private final GenericKeyedObjectPool<SessionKey, PooledSession> sessionPool;
    private final List<PooledSession> loanedSessions;

    public ConnectionPool(Connection connection) {
        this.firstUsed = this.lastUsed = System.currentTimeMillis();
        this.idleTimeout = 30000;
        this.expiryTimeout = 0L;
        this.useAnonymousProducers = true;
        this.started = new AtomicBoolean(false);
        this.loanedSessions = new CopyOnWriteArrayList<PooledSession>();
        this.connection = this.wrap(connection);
        this.sessionPool = new GenericKeyedObjectPool((KeyedPoolableObjectFactory)new KeyedPoolableObjectFactory<SessionKey, PooledSession>(){

            public void activateObject(SessionKey key, PooledSession session) throws Exception {
                ConnectionPool.this.loanedSessions.add(session);
            }

            public void destroyObject(SessionKey key, PooledSession session) throws Exception {
                ConnectionPool.this.loanedSessions.remove(session);
                session.getInternalSession().close();
            }

            public PooledSession makeObject(SessionKey key) throws Exception {
                Session session = ConnectionPool.this.makeSession(key);
                return new PooledSession(key, session, (KeyedObjectPool<SessionKey, PooledSession>)ConnectionPool.this.sessionPool, key.isTransacted(), ConnectionPool.this.useAnonymousProducers);
            }

            public void passivateObject(SessionKey key, PooledSession session) throws Exception {
                ConnectionPool.this.loanedSessions.remove(session);
            }

            public boolean validateObject(SessionKey key, PooledSession session) {
                return true;
            }
        });
    }

    public void setHasExpired(boolean val) {
        this.hasExpired = val;
    }

    protected Session makeSession(SessionKey key) throws JMSException {
        return this.connection.createSession(key.isTransacted(), key.getAckMode());
    }

    protected Connection wrap(Connection connection) {
        return connection;
    }

    protected void unWrap(Connection connection) {
    }

    public void start() throws JMSException {
        if (this.started.compareAndSet(false, true)) {
            try {
                this.connection.start();
            }
            catch (JMSException e) {
                this.started.set(false);
                throw e;
            }
        }
    }

    public synchronized Connection getConnection() {
        return this.connection;
    }

    public Session createSession(boolean transacted, int ackMode) throws JMSException {
        PooledSession session;
        SessionKey key = new SessionKey(transacted, ackMode);
        try {
            session = (PooledSession)this.sessionPool.borrowObject((Object)key);
        }
        catch (Exception e) {
            IllegalStateException illegalStateException = new IllegalStateException(e.toString());
            illegalStateException.initCause(e);
            throw illegalStateException;
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() {
        if (this.connection != null) {
            try {
                this.sessionPool.close();
            }
            catch (Exception e) {
                try {
                    this.connection.close();
                }
                catch (Exception exception) {
                }
                finally {
                    this.connection = null;
                }
            }
            finally {
                try {
                    this.connection.close();
                }
                catch (Exception e) {
                }
                finally {
                    this.connection = null;
                }
            }
        }
    }

    public synchronized void incrementReferenceCount() {
        ++this.referenceCount;
        this.lastUsed = System.currentTimeMillis();
    }

    public synchronized void decrementReferenceCount() {
        --this.referenceCount;
        this.lastUsed = System.currentTimeMillis();
        if (this.referenceCount == 0) {
            for (PooledSession session : this.loanedSessions) {
                try {
                    session.close();
                }
                catch (Exception exception) {}
            }
            this.loanedSessions.clear();
            this.unWrap(this.getConnection());
            this.expiredCheck();
        }
    }

    public synchronized boolean expiredCheck() {
        boolean expired = false;
        if (this.connection == null) {
            return true;
        }
        if (this.hasExpired && this.referenceCount == 0) {
            this.close();
            expired = true;
        }
        if (this.expiryTimeout > 0L && System.currentTimeMillis() > this.firstUsed + this.expiryTimeout) {
            this.hasExpired = true;
            if (this.referenceCount == 0) {
                this.close();
                expired = true;
            }
        }
        if (this.referenceCount == 0 && this.idleTimeout > 0 && System.currentTimeMillis() > this.lastUsed + (long)this.idleTimeout) {
            this.hasExpired = true;
            this.close();
            expired = true;
        }
        return expired;
    }

    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(int idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public void setExpiryTimeout(long expiryTimeout) {
        this.expiryTimeout = expiryTimeout;
    }

    public long getExpiryTimeout() {
        return this.expiryTimeout;
    }

    public int getMaximumActiveSessionPerConnection() {
        return this.sessionPool.getMaxActive();
    }

    public void setMaximumActiveSessionPerConnection(int maximumActiveSessionPerConnection) {
        this.sessionPool.setMaxActive(maximumActiveSessionPerConnection);
    }

    public boolean isUseAnonymousProducers() {
        return this.useAnonymousProducers;
    }

    public void setUseAnonymousProducers(boolean value) {
        this.useAnonymousProducers = value;
    }

    public int getNumSessions() {
        return this.sessionPool.getNumIdle() + this.sessionPool.getNumActive();
    }

    public int getNumIdleSessions() {
        return this.sessionPool.getNumIdle();
    }

    public int getNumActiveSessions() {
        return this.sessionPool.getNumActive();
    }

    public void setBlockIfSessionPoolIsFull(boolean block) {
        this.sessionPool.setWhenExhaustedAction(block ? (byte)1 : 0);
    }

    public boolean isBlockIfSessionPoolIsFull() {
        return this.sessionPool.getWhenExhaustedAction() == 1;
    }

    public long getBlockIfSessionPoolIsFullTimeout() {
        return this.sessionPool.getMaxWait();
    }

    public void setBlockIfSessionPoolIsFullTimeout(long blockIfSessionPoolIsFullTimeout) {
        this.sessionPool.setMaxWait(blockIfSessionPoolIsFullTimeout);
    }

    public String toString() {
        return "ConnectionPool[" + this.connection + "]";
    }
}

