/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.persistence.btreeimpl.btreestorage;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Set;
import org.netbeans.mdr.persistence.MOFID;
import org.netbeans.mdr.persistence.SinglevaluedIndex;
import org.netbeans.mdr.persistence.Storage;
import org.netbeans.mdr.persistence.StorageBadRequestException;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.CachedPage;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.Converter;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.FileCache;

public class PrimaryIndex
implements SinglevaluedIndex {
    private FileCache fileCache;
    private int fileId;
    private Storage.EntryType keyType;
    private Storage.EntryType dataType;
    private String indexName;
    private int valuesInPage;
    private final long firstMofIdSerial;
    private static final int NO_VALUE = 0;
    private static final int sizeof_int = 4;
    private static final int reservedValues = 16;
    static /* synthetic */ Class class$org$netbeans$mdr$persistence$btreeimpl$btreestorage$PrimaryIndex;

    PrimaryIndex(String name, int id, FileCache cache, long firstSerial, Storage.EntryType key, Storage.EntryType data) {
        this.indexName = name;
        this.fileId = id;
        this.fileCache = cache;
        this.firstMofIdSerial = firstSerial;
        this.keyType = key;
        this.dataType = data;
        this.valuesInPage = cache.getPageSize() / 4;
    }

    public void add(Object key, Object value) throws StorageException {
        this.put(key, value);
    }

    public Object get(Object key) throws StorageException, StorageBadRequestException {
        Object result = this.getIfExists(key);
        if (result == null) {
            throw new StorageBadRequestException(MessageFormat.format("Key {0} not found in index", key));
        }
        return result;
    }

    public Object getIfExists(Object key) throws StorageException {
        ValInfo info = new ValInfo(key);
        int value = Converter.readInt(((ValInfo)info).page.contents, info.index);
        this.fileCache.unpin(info.page);
        if (value == 0) {
            return null;
        }
        return new Integer(value);
    }

    public Storage.EntryType getKeyType() throws StorageException {
        return this.keyType;
    }

    public String getName() throws StorageException {
        return this.indexName;
    }

    public Object getObject(Object key, SinglevaluedIndex repos) throws StorageException {
        Object result = this.getObjectIfExists(key, repos);
        if (result == null) {
            throw new StorageBadRequestException(MessageFormat.format("Key {0} not found in index", key));
        }
        return result;
    }

    public Object getObjectIfExists(Object key, SinglevaluedIndex repos) throws StorageException {
        throw new UnsupportedOperationException();
    }

    public Storage.EntryType getValueType() throws StorageException {
        return this.dataType;
    }

    public Set keySet() throws StorageException {
        throw new UnsupportedOperationException();
    }

    public boolean put(Object key, Object value) throws StorageException {
        int val;
        ValInfo info = new ValInfo(key);
        int oldVal = Converter.readInt(((ValInfo)info).page.contents, info.index);
        if (oldVal != (val = ((Integer)value).intValue())) {
            this.fileCache.setWritable(info.page);
            Converter.writeInt(((ValInfo)info).page.contents, info.index, val);
        }
        this.fileCache.unpin(info.page);
        return oldVal != 0;
    }

    public Collection queryByKeyPrefix(Object prefix, SinglevaluedIndex repos) throws StorageException {
        throw new UnsupportedOperationException();
    }

    public boolean remove(Object key) throws StorageException {
        ValInfo info = new ValInfo(key);
        int val = Converter.readInt(((ValInfo)info).page.contents, info.index);
        if (val != 0) {
            this.fileCache.setWritable(info.page);
            Converter.writeInt(((ValInfo)info).page.contents, info.index, 0);
        }
        this.fileCache.unpin(info.page);
        return val != 0;
    }

    public void replace(Object key, Object value) throws StorageException, StorageBadRequestException {
        ValInfo info = new ValInfo(key);
        int oldVal = Converter.readInt(((ValInfo)info).page.contents, info.index);
        if (oldVal == 0) {
            throw new StorageBadRequestException(MessageFormat.format("Key {0} not found in index", key));
        }
        int val = (Integer)value;
        this.fileCache.setWritable(info.page);
        Converter.writeInt(((ValInfo)info).page.contents, info.index, val);
        this.fileCache.unpin(info.page);
    }

    public Collection values() throws StorageException {
        throw new UnsupportedOperationException();
    }

    private class ValInfo {
        private int index;
        private CachedPage page;
        static final /* synthetic */ boolean $assertionsDisabled;

        ValInfo(Object mofId) throws StorageException {
            MOFID mid = (MOFID)mofId;
            long serial = mid.getSerialNumber();
            if (serial >= 128L) {
                if (!$assertionsDisabled && serial < PrimaryIndex.this.firstMofIdSerial) {
                    throw new AssertionError();
                }
                serial -= PrimaryIndex.this.firstMofIdSerial - 128L;
            }
            long pageNum = (serial += 16L) / (long)PrimaryIndex.this.valuesInPage;
            this.page = PrimaryIndex.this.fileCache.getPage(PrimaryIndex.this.fileId, (int)pageNum);
            this.index = (int)(serial % (long)PrimaryIndex.this.valuesInPage) * 4;
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$mdr$persistence$btreeimpl$btreestorage$PrimaryIndex == null ? (class$org$netbeans$mdr$persistence$btreeimpl$btreestorage$PrimaryIndex = PrimaryIndex.class$("org.netbeans.mdr.persistence.btreeimpl.btreestorage.PrimaryIndex")) : class$org$netbeans$mdr$persistence$btreeimpl$btreestorage$PrimaryIndex).desiredAssertionStatus();
        }
    }
}

