/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.templateengines.velocity;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.andromda.core.common.AndroMDALogger;
import org.andromda.core.common.Constants;
import org.andromda.core.common.ExceptionUtils;
import org.andromda.core.common.Merger;
import org.andromda.core.common.ResourceUtils;
import org.andromda.core.common.ResourceWriter;
import org.andromda.core.templateengine.TemplateEngine;
import org.andromda.core.templateengine.TemplateEngineException;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;
import org.apache.velocity.runtime.resource.loader.FileResourceLoader;
import org.apache.velocity.tools.generic.EscapeTool;

public class VelocityTemplateEngine
implements TemplateEngine {
    protected static Logger logger = null;
    protected FileAppender appender = null;
    private static final String PROPERTIES_DIR = "META-INF/";
    private static final String PROPERTIES_SUFFIX = "-velocity.properties";
    private static final String TEMPORARY_TEMPLATE_LOCATION = Constants.TEMPORARY_DIRECTORY + "velocity/merged";
    private String mergeLocation;
    private String namespace;
    private VelocityEngine velocityEngine;
    private VelocityContext velocityContext;
    private final List<String> macroLibraries = new ArrayList<String>();
    private final Map<String, Template> discoveredTemplates = new HashMap<String, Template>();
    private final Collection<File> mergedTemplateFiles = new ArrayList<File>();
    private static final String LOG_TAG = "logtag";

    public void initialize(String namespace) throws Exception {
        this.namespace = namespace;
        this.initLogger(namespace);
        ExtendedProperties engineProperties = new ExtendedProperties();
        engineProperties.setProperty("resource.loader", (Object)"file,classpath");
        engineProperties.setProperty("file.resource.loader.class", (Object)FileResourceLoader.class.getName());
        engineProperties.setProperty("classpath.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
        engineProperties.setProperty("runtime.log.logsystem.class", (Object)"org.apache.velocity.runtime.log.Log4JLogChute");
        engineProperties.setProperty("runtime.log.logsystem.log4j.logger", (Object)logger.getName());
        for (String macroLibrary : this.getMacroLibraries()) {
            engineProperties.addProperty("velocimacro.library", (Object)macroLibrary);
        }
        this.velocityEngine = new VelocityEngine();
        this.velocityEngine.setExtendedProperties(engineProperties);
        if (this.mergeLocation != null) {
            this.velocityEngine.addProperty("file.resource.loader.path", (Object)this.mergeLocation);
        }
        if (Merger.instance().requiresMerge(this.namespace)) {
            this.velocityEngine.addProperty("file.resource.loader.path", (Object)this.getMergedTemplatesLocation());
        }
        this.addProperties(namespace);
        this.velocityEngine.init();
    }

    private void addProperties(String pluginName) throws IOException {
        URL propertiesUri = ResourceUtils.getResource((String)(PROPERTIES_DIR + StringUtils.trimToEmpty((String)pluginName) + PROPERTIES_SUFFIX));
        if (propertiesUri != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("loading properties from --> '" + propertiesUri + '\''));
            }
            Properties properties = new Properties();
            properties.load(propertiesUri.openStream());
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                String property = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("setting property '" + property + "' with --> '" + value + '\''));
                }
                this.velocityEngine.setProperty(property, (Object)value);
            }
        }
    }

    public void processTemplate(String templateFile, Map<String, Object> templateObjects, Writer output) throws Exception {
        String methodName = "VelocityTemplateEngine.processTemplate";
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("performing VelocityTemplateEngine.processTemplate with templateFile '" + templateFile + "' and templateObjects '" + templateObjects + '\''));
        }
        ExceptionUtils.checkEmpty((String)"templateFile", (String)templateFile);
        ExceptionUtils.checkNull((String)"output", (Object)output);
        this.velocityContext = new VelocityContext();
        this.loadVelocityContext(templateObjects);
        Template template = this.discoveredTemplates.get(templateFile);
        if (template == null) {
            template = this.velocityEngine.getTemplate(templateFile);
            Merger merger = Merger.instance();
            if (merger.requiresMerge(this.namespace)) {
                String mergedTemplateLocation = this.getMergedTemplateLocation(templateFile);
                InputStream resource = template.getResourceLoader().getResourceStream(templateFile);
                ResourceWriter.instance().writeStringToFile(merger.getMergedString(resource, this.namespace), mergedTemplateLocation);
                template = this.velocityEngine.getTemplate(templateFile);
                this.mergedTemplateFiles.add(new File(mergedTemplateLocation));
            }
            this.discoveredTemplates.put(templateFile, template);
        }
        template.merge((Context)this.velocityContext, output);
    }

    private void loadVelocityContext(Map<String, Object> templateObjects) {
        if (templateObjects != null) {
            for (Map.Entry<String, Object> entry : templateObjects.entrySet()) {
                this.velocityContext.put(entry.getKey(), entry.getValue());
            }
        }
        this.velocityContext.put("esc", (Object)new EscapeTool());
    }

    private String getMergedTemplateLocation(String templatePath) {
        return this.getMergedTemplatesLocation() + '/' + templatePath;
    }

    private String getMergedTemplatesLocation() {
        return TEMPORARY_TEMPLATE_LOCATION + '/' + this.namespace;
    }

    public String getEvaluatedExpression(String expression, Map<String, Object> templateObjects) {
        String evaluatedExpression = null;
        if (StringUtils.isNotBlank((String)expression)) {
            if (this.velocityContext == null) {
                this.velocityContext = new VelocityContext();
                this.loadVelocityContext(templateObjects);
            }
            try {
                StringWriter writer = new StringWriter();
                this.velocityEngine.evaluate((Context)this.velocityContext, (Writer)writer, LOG_TAG, expression);
                evaluatedExpression = writer.toString();
            }
            catch (Throwable throwable) {
                throw new TemplateEngineException(throwable);
            }
        }
        return evaluatedExpression;
    }

    public List<String> getMacroLibraries() {
        return this.macroLibraries;
    }

    public void addMacroLibrary(String libraryName) {
        this.macroLibraries.add(libraryName);
    }

    public void setMergeLocation(String mergeLocation) {
        this.mergeLocation = mergeLocation;
    }

    public void shutdown() {
        FileUtils.deleteQuietly((File)new File(TEMPORARY_TEMPLATE_LOCATION));
        this.discoveredTemplates.clear();
        this.velocityEngine = null;
        if (null != logger && null != this.appender) {
            logger.removeAppender((Appender)this.appender);
        }
    }

    private void initLogger(String pluginName) throws IOException {
        logger = AndroMDALogger.getNamespaceLogger((String)pluginName);
        logger.setAdditivity(false);
        this.appender = new FileAppender((Layout)new PatternLayout("%-5p %d - %m%n"), AndroMDALogger.getNamespaceLogFileName((String)pluginName), true);
        logger.addAppender((Appender)this.appender);
    }
}

