/*
 * Decompiled with CFR 0.152.
 */
package org.andromda.maven.plugin.andromdapp;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.andromda.maven.plugins:andromdapp-maven-plugin:3.4", 0);
        this.append(sb, "", 0);
        this.append(sb, "AndroMDA Application Generator Maven Plugin", 0);
        this.append(sb, "A plugin for running AndroMDA's AndroMDApp application generator to generate Maven2 AndroMDA powered applications.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 10 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "build".equals(this.goal)) {
            this.append(sb, "andromdapp:build", 0);
            this.append(sb, "A Mojo used for executing the build goals from the top level project.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "baseDirectory", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "Expression: ${project.basedir}", 3);
                this.append(sb, "", 0);
                this.append(sb, "environmentVariablePrefix", 2);
                this.append(sb, "The prefix environment variables must have.", 3);
                this.append(sb, "Expression: env.", 3);
                this.append(sb, "", 0);
                this.append(sb, "executionProperties", 2);
                this.append(sb, "Any execution properties.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goals", 2);
                this.append(sb, "The default module goals to execute.", 3);
                this.append(sb, "", 0);
                this.append(sb, "modules", 2);
                this.append(sb, "A comma separated list of modules to execute in the form: -Dmodules=mda,core,common or if you want to specify the goals to execute as well: -Dmodules=mda:[goal1+goal2+goal3],core:[goal1].", 3);
                this.append(sb, "Expression: ${modules}", 3);
                this.append(sb, "", 0);
                this.append(sb, "session", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "Expression: ${session}", 3);
                this.append(sb, "", 0);
                this.append(sb, "startConsole", 2);
                this.append(sb, "If defined starts the build console (i.e. keeps maven loaded and running)", 3);
                this.append(sb, "Expression: ${console}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "clean-structure".equals(this.goal)) {
            this.append(sb, "andromdapp:clean-structure", 0);
            this.append(sb, "Removes the an AndroMDApp generated application structure.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "configurationUri", 2);
                this.append(sb, "The URI to an optional AndroMDApp configuration file.", 3);
                this.append(sb, "Expression: ${configuration.uri}", 3);
                this.append(sb, "", 0);
                this.append(sb, "propertyFiles", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "Expression: ${project.build.filters}", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip", 2);
                this.append(sb, "Set this to 'true' to bypass cartridge tests entirely. Its use is NOT RECOMMENDED, but quite convenient on occasion.", 3);
                this.append(sb, "Expression: ${maven.test.skip}", 3);
                this.append(sb, "", 0);
                this.append(sb, "skipProcessing", 2);
                this.append(sb, "Whether or not processing should be skipped (this is if you want to completely skip code generation, i.e. if code is already generated and you are creating the site from already generated source code).", 3);
                this.append(sb, "Expression: ${andromdapp.run.skip}", 3);
                this.append(sb, "", 0);
                this.append(sb, "skipTests", 2);
                this.append(sb, "Set this to 'true' to skip running tests, but still compile them. Its use is NOT RECOMMENDED, but quite convenient on occasion.", 3);
                this.append(sb, "Expression: ${skipTests}", 3);
                this.append(sb, "", 0);
                this.append(sb, "testFailureIgnore (Default: false)", 2);
                this.append(sb, "Set this to true to ignore a failure during testing. Its use is NOT RECOMMENDED, but quite convenient on occasion.", 3);
                this.append(sb, "Expression: ${maven.test.failure.ignore}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "deploy".equals(this.goal)) {
            this.append(sb, "andromdapp:deploy", 0);
            this.append(sb, "Provides the deployment of applications to a given directory.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "deploy", 2);
                this.append(sb, "Indicates whether or not this plugin should perform the deploy.", 3);
                this.append(sb, "Expression: ${deploy}", 3);
                this.append(sb, "", 0);
                this.append(sb, "deployLocation", 2);
                this.append(sb, "The location (i.e. path) to deploy.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "Any files to exclude in the deploy.", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "Any additional files to include in the deploy liked datasource files etc (the files must reside in the project build directory). By default nothing besides the file artifact is deployed.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "eclipse".equals(this.goal)) {
            this.append(sb, "andromdapp:eclipse", 0);
            this.append(sb, "Writes the necessary .classpath and .project files for a new eclipse application.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "classpathArtifactTypes", 2);
                this.append(sb, "The artifact types which should be included in the generated Eclipse classpath.", 3);
                this.append(sb, "", 0);
                this.append(sb, "classpathMerge", 2);
                this.append(sb, "Allows non-generated configuration to be 'merged' into the generated .classpath file.", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludePoms", 2);
                this.append(sb, "Defines the POMs to exclude when generating the eclipse files.", 3);
                this.append(sb, "Expression: ${exclude.poms}", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "Defines the POMs to exclude when generating the eclipse files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "Defines the POMs to include when generating the eclipse files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "repositoryVariableName", 2);
                this.append(sb, "The name of the variable that will store the maven repository location.", 3);
                this.append(sb, "Expression: ${repository.variable.name}", 3);
                this.append(sb, "", 0);
                this.append(sb, "resolveTransitiveDependencies", 2);
                this.append(sb, "Whether or not transitive dependencies shall be included in any resources (i.e. .classpath that are generated by this mojo).", 3);
                this.append(sb, "Expression: ${resolveTransitiveDependencies}", 3);
                this.append(sb, "", 0);
                this.append(sb, "session", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "Expression: ${session}", 3);
                this.append(sb, "", 0);
                this.append(sb, "skipProcessing", 2);
                this.append(sb, "Whether or not processing should be skipped (this is if you just want to force AndroMDA not to run on your model).", 3);
                this.append(sb, "Expression: ${andromda.run.skip}", 3);
                this.append(sb, "", 0);
                this.append(sb, "variables", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "generate".equals(this.goal)) {
            this.append(sb, "andromdapp:generate", 0);
            this.append(sb, "AndroMDA application generator Mojo.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "configurationUri", 2);
                this.append(sb, "The URI to an optional AndroMDApp configuration file.", 3);
                this.append(sb, "Expression: ${configuration.uri}", 3);
                this.append(sb, "", 0);
                this.append(sb, "propertyFiles", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "Expression: ${project.build.filters}", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip", 2);
                this.append(sb, "Set this to 'true' to bypass cartridge tests entirely. Its use is NOT RECOMMENDED, but quite convenient on occasion.", 3);
                this.append(sb, "Expression: ${maven.test.skip}", 3);
                this.append(sb, "", 0);
                this.append(sb, "skipProcessing", 2);
                this.append(sb, "Whether or not processing should be skipped (this is if you want to completely skip code generation, i.e. if code is already generated and you are creating the site from already generated source code).", 3);
                this.append(sb, "Expression: ${andromdapp.run.skip}", 3);
                this.append(sb, "", 0);
                this.append(sb, "skipTests", 2);
                this.append(sb, "Set this to 'true' to skip running tests, but still compile them. Its use is NOT RECOMMENDED, but quite convenient on occasion.", 3);
                this.append(sb, "Expression: ${skipTests}", 3);
                this.append(sb, "", 0);
                this.append(sb, "testFailureIgnore (Default: false)", 2);
                this.append(sb, "Set this to true to ignore a failure during testing. Its use is NOT RECOMMENDED, but quite convenient on occasion.", 3);
                this.append(sb, "Expression: ${maven.test.failure.ignore}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "andromdapp:help", 0);
            this.append(sb, "Display help information on andromdapp-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0andromdapp:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "Expression: ${detail}", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "Expression: ${goal}", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "Expression: ${indentSize}", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "Expression: ${lineLength}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "instrument-scripts".equals(this.goal)) {
            this.append(sb, "andromdapp:instrument-scripts", 0);
            this.append(sb, "Allows for the ScriptClassGenerator mojo to be invoked. on one or more given classes.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "locations", 2);
                this.append(sb, "Defines the java files who's classes will be instrumented.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "scriptWrapper", 2);
                this.append(sb, "Defines the fully qualified class name of the script wrapper implementation.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "link".equals(this.goal)) {
            this.append(sb, "andromdapp:link", 0);
            this.append(sb, "Basically post processes a previously built ear and replaces any war artifacts with symbolic links and then symbolic links the ear to the deploy directory so that we don't have to redeploy an ear in order to make jsp changes.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "deployLocation", 2);
                this.append(sb, "The location in which to link the exploded ear.", 3);
                this.append(sb, "Expression: ${env.JBOSS_HOME}/server/default/deploy", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "schema".equals(this.goal)) {
            this.append(sb, "andromdapp:schema", 0);
            this.append(sb, "Provides the ability to drop database schemas.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "executeScripts", 2);
                this.append(sb, "Whether or not scripts should be executed (if this is set to false, they will only be generated, but not executed).", 3);
                this.append(sb, "Expression: ${executeScripts}", 3);
                this.append(sb, "", 0);
                this.append(sb, "jdbcConnectionUrl", 2);
                this.append(sb, "The JDBC connection URL.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "jdbcDriver", 2);
                this.append(sb, "The name of the JDBC driver class.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "jdbcDriverJar", 2);
                this.append(sb, "The jar containing the JDBC driver.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "jdbcPassword", 2);
                this.append(sb, "The JDBC password for the database.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jdbcUsername", 2);
                this.append(sb, "The JDBC username for the database.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "pluginArtifacts", 2);
                this.append(sb, "(no description available)", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${plugin.artifacts}", 3);
                this.append(sb, "", 0);
                this.append(sb, "properties", 2);
                this.append(sb, "The properties that can be passed to the schema task.", 3);
                this.append(sb, "", 0);
                this.append(sb, "propertyFiles", 2);
                this.append(sb, "Any property files that should be loaded into the schema properties.", 3);
                this.append(sb, "", 0);
                this.append(sb, "scripts", 2);
                this.append(sb, "Defines the location(s) of any SQL scripts to be executed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "tasks", 2);
                this.append(sb, "The schema task to execute (create, drop, update, validate)", 3);
                this.append(sb, "Expression: ${tasks}", 3);
                this.append(sb, "", 0);
                this.append(sb, "taskType", 2);
                this.append(sb, "The type of the create schema task to execute.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: hibernate", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "undeploy".equals(this.goal)) {
            this.append(sb, "andromdapp:undeploy", 0);
            this.append(sb, "Provides the undeployment of applications from a given directory.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "deployLocation", 2);
                this.append(sb, "The location (i.e. path) to deploy.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

