/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.smb.server.nio;

import java.nio.channels.SelectionKey;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.server.thread.ThreadRequest;
import org.alfresco.jlan.smb.server.PacketHandler;
import org.alfresco.jlan.smb.server.SMBSrvPacket;
import org.alfresco.jlan.smb.server.SMBSrvSession;

public class NIOCIFSThreadRequest
implements ThreadRequest {
    private static final int MaxPacketsPerRun = 4;
    private SMBSrvSession m_sess;
    private SelectionKey m_selectionKey;

    public NIOCIFSThreadRequest(SMBSrvSession sess, SelectionKey selKey) {
        this.m_sess = sess;
        this.m_selectionKey = selKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runRequest() {
        if (!this.m_sess.isShutdown()) {
            int pktCount = 0;
            boolean morePkts = true;
            boolean pktError = false;
            boolean asyncPkt = false;
            SMBSrvPacket smbPkt = null;
            while (pktCount < 4 && morePkts && !pktError) {
                try {
                    PacketHandler pktHandler = this.m_sess.getPacketHandler();
                    smbPkt = pktHandler.readPacket();
                    if (smbPkt == null) {
                        if (pktCount == 0) {
                            if (this.m_sess.hasDebug(0x400000)) {
                                Debug.println("Received null packet, closing session sess=" + this.m_sess.getUniqueId() + ", addr=" + this.m_sess.getRemoteAddress().getHostAddress());
                            }
                            this.m_sess.hangupSession("Client closed socket");
                            this.m_sess.processPacket(null);
                            this.m_selectionKey.cancel();
                            this.m_selectionKey.selector().wakeup();
                            pktError = true;
                        }
                        morePkts = false;
                        continue;
                    }
                    ++pktCount;
                    if (!asyncPkt && this.m_sess.hasAsyncResponseQueued()) {
                        asyncPkt = true;
                    } else if (pktCount == 4 && !asyncPkt) {
                        this.m_selectionKey.interestOps(this.m_selectionKey.interestOps() | 1);
                        this.m_selectionKey.selector().wakeup();
                    }
                    this.m_sess.processPacket(smbPkt);
                    smbPkt = null;
                }
                catch (Throwable ex) {
                    if (this.m_sess.hasDebug(0x400000)) {
                        Debug.println("Error during packet receive, closing session sess=" + this.m_sess.getUniqueId() + ", addr=" + this.m_sess.getRemoteAddress().getHostAddress() + " ex=" + ex.getMessage());
                    }
                    this.m_sess.hangupSession("Client closed socket");
                    this.m_sess.processPacket(null);
                    this.m_selectionKey.cancel();
                    this.m_selectionKey.selector().wakeup();
                    pktError = true;
                }
                finally {
                    if (smbPkt == null) continue;
                    this.m_sess.getPacketPool().releasePacket(smbPkt);
                }
            }
            if (asyncPkt) {
                int asyncCnt = this.m_sess.sendQueuedAsyncResponses();
                if (this.m_sess.hasDebug(0x400000)) {
                    Debug.println("Sent queued async packets count=" + asyncCnt + ", sess=" + this.m_sess.getUniqueId() + ", addr=" + this.m_sess.getRemoteAddress().getHostAddress());
                }
            }
            if (!pktError && (pktCount < 4 || asyncPkt)) {
                this.m_selectionKey.interestOps(this.m_selectionKey.interestOps() | 1);
                this.m_selectionKey.selector().wakeup();
            }
            if (this.m_sess.hasDebug(0x2000000) && pktCount > 1) {
                Debug.println("Processed " + pktCount + " packets for addr=" + this.m_sess.getRemoteAddress().getHostAddress() + " in one thread run (max=" + 4 + ")");
            }
        }
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[NIO CIFS Sess=");
        str.append(this.m_sess.getUniqueId());
        str.append("]");
        return str.toString();
    }
}

