/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.auth.passthru;

import java.io.IOException;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.netbios.NetworkSession;
import org.alfresco.jlan.server.auth.ntlm.Type1NTLMMessage;
import org.alfresco.jlan.server.auth.ntlm.Type2NTLMMessage;
import org.alfresco.jlan.server.auth.ntlm.Type3NTLMMessage;
import org.alfresco.jlan.server.auth.passthru.SMBPacket;
import org.alfresco.jlan.smb.Dialect;
import org.alfresco.jlan.smb.NTTime;
import org.alfresco.jlan.smb.PCShare;
import org.alfresco.jlan.smb.SMBDate;
import org.alfresco.jlan.smb.SMBException;
import org.alfresco.jlan.util.DataPacker;

public class AuthenticateSession {
    private static final int DefaultPacketSize = 1024;
    public static final int SecurityModeUser = 1;
    public static final int SecurityModeShare = 2;
    protected static final int Closed = -1;
    public static final int DBGPacketType = 1;
    public static final int DBGDumpPacket = 2;
    public static final int DBGHexDump = 4;
    public static final int DEFAULT_BUFSIZE = 4096;
    private int m_dialect;
    private String m_diaStr;
    private NetworkSession m_netSession;
    protected SMBPacket m_pkt;
    private int m_defFlags = 8;
    private int m_defFlags2 = 1;
    private PCShare m_remoteShr;
    private String m_domain;
    private String m_srvOS;
    private String m_srvLM;
    private int m_secMode;
    private byte[] m_encryptKey;
    private int m_sessIdx;
    private int m_userId;
    private int m_processId;
    protected int m_treeid;
    private int m_devtype;
    private int m_maxPktSize;
    private int m_sessCaps;
    private int m_maxVCs;
    private int m_maxMPX;
    private boolean m_guest;
    private boolean m_extendedSec;
    private byte[] m_serverGUID;
    private Type2NTLMMessage m_type2Msg;
    private static int m_sessionIdx = 1;
    private static int m_multiplexId = 1;
    private static int m_debug = 0;

    protected AuthenticateSession(PCShare shr, NetworkSession sess, int dialect, SMBPacket pkt) throws IOException, SMBException {
        this.m_dialect = dialect;
        this.m_remoteShr = shr;
        this.m_sessIdx = this.getNextSessionId();
        this.m_pkt = pkt;
        if (pkt == null) {
            this.m_pkt = new SMBPacket(4096);
        }
        this.setSession(sess);
        this.processNegotiateResponse();
    }

    protected final SMBPacket allocatePacket(int pref) {
        if (pref > this.m_maxPktSize) {
            return new SMBPacket(this.m_maxPktSize + 4);
        }
        return new SMBPacket(pref + 4);
    }

    public final boolean supportsExtendedSecurity() {
        return (this.m_sessCaps & Integer.MIN_VALUE) != 0;
    }

    public final boolean supportsRawMode() {
        return (this.m_sessCaps & 1) != 0;
    }

    public final boolean supportsUnicode() {
        return (this.m_sessCaps & 4) != 0;
    }

    public final boolean supportsLargeFiles() {
        return (this.m_sessCaps & 8) != 0;
    }

    public final boolean supportsNTSmbs() {
        return (this.m_sessCaps & 0x10) != 0;
    }

    public final boolean supportsRPCAPIs() {
        return (this.m_sessCaps & 0x20) != 0;
    }

    public final boolean supportsNTStatusCodes() {
        return (this.m_sessCaps & 0x40) != 0;
    }

    public final boolean supportsLevel2Oplocks() {
        return (this.m_sessCaps & 0x80) != 0;
    }

    public final boolean supportsLockAndRead() {
        return (this.m_sessCaps & 0x100) != 0;
    }

    public final boolean supportsNTFind() {
        return (this.m_sessCaps & 0x200) != 0;
    }

    public void CloseSession() throws IOException, SMBException {
        if (this.isActive()) {
            this.m_netSession.Close();
            this.m_netSession = null;
        }
    }

    public final int getDefaultFlags() {
        return this.m_defFlags;
    }

    public final int getDefaultFlags2() {
        return this.m_defFlags2;
    }

    public final int getDeviceType() {
        return this.m_devtype;
    }

    public final int getDialect() {
        return this.m_dialect;
    }

    public final String getDialectString() {
        return this.m_diaStr;
    }

    public final String getDomain() {
        return this.m_domain;
    }

    public final boolean hasEncryptionKey() {
        return this.m_encryptKey != null;
    }

    public final byte[] getEncryptionKey() {
        return this.m_encryptKey;
    }

    public final String getLANManagerType() {
        return this.m_srvLM;
    }

    public final int getMaximumMultiplexedRequests() {
        return this.m_maxMPX;
    }

    public final int getMaximumPacketSize() {
        return this.m_maxPktSize;
    }

    public final int getMaximumVirtualCircuits() {
        return this.m_maxVCs;
    }

    public final synchronized int getNextMultiplexId() {
        return m_multiplexId++;
    }

    protected final synchronized int getNextSessionId() {
        return m_sessionIdx++;
    }

    public final String getOperatingSystem() {
        return this.m_srvOS;
    }

    public final String getPassword() {
        return this.m_remoteShr.getPassword();
    }

    public final PCShare getPCShare() {
        return this.m_remoteShr;
    }

    public final int getSecurityMode() {
        return this.m_secMode;
    }

    public final String getServer() {
        return this.m_remoteShr.getNodeName();
    }

    public final NetworkSession getSession() {
        return this.m_netSession;
    }

    public final int getCapabilities() {
        return this.m_sessCaps;
    }

    public final int getProcessId() {
        return this.m_processId;
    }

    public final int getSessionId() {
        return this.m_sessIdx;
    }

    public final String getShareName() {
        return this.m_remoteShr.getShareName();
    }

    public final int getTreeId() {
        return this.m_treeid;
    }

    public final int getUserId() {
        return this.m_userId;
    }

    public final String getUserName() {
        return this.m_remoteShr.getUserName();
    }

    public final boolean hasDataAvailable() throws IOException {
        return this.m_netSession.hasData();
    }

    public static boolean hasDebugOption(int opt) {
        if (m_debug == 0) {
            return false;
        }
        return (m_debug & opt) != 0;
    }

    public final boolean isActive() {
        return this.m_netSession != null;
    }

    public static boolean hasDebug() {
        return m_debug != 0;
    }

    public final boolean isGuest() {
        return this.m_guest;
    }

    public final boolean isUnicode() {
        return (this.m_defFlags2 & 0x8000) != 0;
    }

    public final boolean isUsingExtendedSecurity() {
        return this.m_extendedSec;
    }

    public final void pingServer() throws IOException, SMBException {
        this.pingServer(1);
    }

    public final void pingServer(int cnt) throws IOException, SMBException {
        this.m_pkt.setCommand(43);
        this.m_pkt.setFlags(0);
        this.m_pkt.setTreeId(this.getTreeId());
        this.m_pkt.setUserId(this.getUserId());
        this.m_pkt.setProcessId(this.getProcessId());
        this.m_pkt.setMultiplexId(1);
        this.m_pkt.setParameterCount(1);
        this.m_pkt.setParameter(0, cnt);
        String echoStr = "ECHO";
        this.m_pkt.setBytes(echoStr.getBytes());
        this.m_pkt.SendSMB(this);
        while (cnt > 0) {
            this.m_pkt.ReceiveSMB(this);
            --cnt;
        }
    }

    public static void setDebug(int dbg) {
        m_debug = dbg;
    }

    protected final void setDefaultFlags(int flg) {
        this.m_defFlags = flg;
    }

    protected final void setDefaultFlags2(int flg2) {
        this.m_defFlags2 = flg2;
    }

    protected final void setDeviceType(int dev) {
        this.m_devtype = dev;
    }

    protected final void setDialect(int dia) {
        this.m_dialect = dia;
    }

    protected final void setDialectString(String dia) {
        this.m_diaStr = dia;
    }

    protected final void setDomain(String dom) {
        this.m_domain = dom;
    }

    public final void setEncryptionKey(byte[] key) {
        this.m_encryptKey = key;
    }

    protected final void setGuest(boolean sts) {
        this.m_guest = sts;
    }

    protected final void setLANManagerType(String lm) {
        this.m_srvLM = lm;
    }

    protected final void setMaximumMultiplexedRequests(int maxMulti) {
        this.m_maxMPX = maxMulti;
    }

    protected final void setMaximumPacketSize(int siz) {
        this.m_maxPktSize = siz;
    }

    protected final void setMaximumVirtualCircuits(int maxVC) {
        this.m_maxVCs = maxVC;
    }

    protected final void setOperatingSystem(String os) {
        this.m_srvOS = os;
    }

    protected final void setPassword(String pwd) {
        this.m_remoteShr.setPassword(pwd);
    }

    public final void setSecurityMode(int secMode) {
        this.m_secMode = secMode;
    }

    protected final void setServer(String srv) {
        this.m_remoteShr.setNodeName(srv);
    }

    protected final void setSession(NetworkSession netSess) {
        this.m_netSession = netSess;
    }

    protected final void setCapabilities(int caps) {
        this.m_sessCaps = caps;
    }

    protected final void setShareName(String shr) {
        this.m_remoteShr.setShareName(shr);
    }

    protected final void setProcessId(int id) {
        this.m_processId = id;
    }

    protected final void setTreeId(int id) {
        this.m_treeid = id;
    }

    protected final void setUserId(int uid) {
        this.m_userId = uid;
    }

    protected final void setUserName(String user) {
        this.m_remoteShr.setUserName(user);
    }

    protected void processAsynchResponse(SMBPacket pkt) {
        if (AuthenticateSession.hasDebug()) {
            Debug.println("++ Asynchronous response received, command = 0x" + pkt.getCommand());
        }
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("[\\\\");
        str.append(this.getServer());
        str.append("\\");
        str.append(this.getShareName());
        str.append(":");
        str.append(Dialect.DialectTypeString(this.m_dialect));
        str.append(",UserId=");
        str.append(this.getUserId());
        str.append("]");
        return str.toString();
    }

    public final void doSessionSetup(String userName, byte[] ascPwd, byte[] uniPwd) throws IOException, SMBException {
        this.doSessionSetup(null, userName, null, ascPwd, uniPwd, 0);
    }

    public final void doSessionSetup(Type3NTLMMessage type3Msg) throws IOException, SMBException {
        this.doSessionSetup(type3Msg.getDomain(), type3Msg.getUserName(), type3Msg.getWorkstation(), type3Msg.getLMHash(), type3Msg.getNTLMHash(), 0);
    }

    public final void doSessionSetup(String domain, String userName, String wksName, byte[] ascPwd, byte[] uniPwd, int vcNum) throws IOException, SMBException {
        int pos;
        if (this.isUsingExtendedSecurity()) {
            this.doExtendedSessionSetupPhase2(domain, userName, wksName, ascPwd, uniPwd, vcNum);
            return;
        }
        SMBPacket pkt = new SMBPacket();
        pkt.setCommand(115);
        if (this.getDialect() == 7) {
            pkt.setParameterCount(13);
            pkt.setAndXCommand(255);
            pkt.setParameter(1, 0);
            pkt.setParameter(2, 1024);
            pkt.setParameter(3, 1);
            pkt.setParameter(4, vcNum);
            pkt.setParameterLong(5, 0);
            pkt.setParameter(7, ascPwd != null ? ascPwd.length : 0);
            pkt.setParameter(8, uniPwd != null ? uniPwd.length : 0);
            pkt.setParameter(9, 0);
            pkt.setParameter(10, 0);
            int caps = 124;
            pkt.setParameterLong(11, caps);
            pos = pkt.getByteOffset();
            pkt.setPosition(pos);
            if (ascPwd != null) {
                pkt.packBytes(ascPwd, ascPwd.length);
            }
            if (uniPwd != null) {
                pkt.packBytes(uniPwd, uniPwd.length);
            }
            pkt.packString(userName, false);
            if (this.getPCShare().hasDomain()) {
                pkt.packString(this.getPCShare().getDomain(), false);
            } else if (domain != null) {
                pkt.packString(domain, false);
            } else {
                pkt.packString("?", false);
            }
            pkt.packString("Java VM", false);
            pkt.packString("Alfresco CIFS", false);
            pkt.setByteCount(pkt.getPosition() - pos);
        } else {
            pkt.setUserId(1);
            pkt.setParameterCount(10);
            pkt.setAndXCommand(255);
            pkt.setParameter(1, 0);
            pkt.setParameter(2, 1024);
            pkt.setParameter(3, 1);
            pkt.setParameter(4, 0);
            pkt.setParameter(5, 0);
            pkt.setParameter(6, 0);
            pkt.setParameter(7, ascPwd != null ? ascPwd.length : 0);
            pkt.setParameter(8, 0);
            pkt.setParameter(9, 0);
            byte[] buf = pkt.getBuffer();
            pos = pkt.getByteOffset();
            if (ascPwd != null) {
                for (int i = 0; i < ascPwd.length; ++i) {
                    buf[pos++] = ascPwd[i];
                }
            }
            StringBuffer clbuf = new StringBuffer();
            clbuf.append(this.getPCShare().getUserName());
            clbuf.append('\u0000');
            if (this.getPCShare().hasDomain()) {
                clbuf.append(this.getPCShare().getDomain());
            } else {
                clbuf.append("?");
            }
            clbuf.append('\u0000');
            clbuf.append("Java VM");
            clbuf.append('\u0000');
            clbuf.append("Alfresco CIFS");
            clbuf.append('\u0000');
            byte[] byts = clbuf.toString().getBytes();
            for (int i = 0; i < byts.length; ++i) {
                buf[pos++] = byts[i];
            }
            int pwdLen = ascPwd != null ? ascPwd.length : 0;
            pkt.setByteCount(pwdLen + byts.length);
        }
        pkt.ExchangeSMB(this, pkt, true);
        this.setUserId(pkt.getUserId());
        if (pkt.getParameterCount() >= 3) {
            this.setGuest(pkt.getParameter(2) != 0);
        }
        if (pkt.getByteCount() > 0) {
            byte[] buf = pkt.getBuffer();
            int offset = pkt.getByteOffset();
            int maxlen = offset + pkt.getByteCount();
            String srvOS = DataPacker.getString(buf, offset, maxlen);
            this.setOperatingSystem(srvOS);
            String lanman = DataPacker.getString(buf, offset += srvOS.length() + 1, maxlen -= srvOS.length() + 1);
            this.setLANManagerType(lanman);
            if (this.getDomain() == null || this.getDomain().length() == 0) {
                String dom = DataPacker.getString(buf, offset += lanman.length() + 1, maxlen += lanman.length() + 1);
                this.setDomain(dom);
            }
        }
        if (this.getDialect() == 0 || this.getDialect() == 1) {
            this.setMaximumPacketSize(pkt.getParameter(2));
        }
    }

    private void processNegotiateResponse() throws IOException, SMBException {
        int keyLen = 0;
        boolean unicodeStr = false;
        boolean encAlgorithm = false;
        int defFlags2 = 0;
        if (this.getDialect() == 7) {
            this.m_pkt.resetParameterPointer();
            this.m_pkt.skipBytes(2);
            this.setSecurityMode(this.m_pkt.unpackByte());
            this.setMaximumMultiplexedRequests(this.m_pkt.unpackWord());
            this.setMaximumVirtualCircuits(this.m_pkt.unpackWord());
            this.setMaximumPacketSize(this.m_pkt.unpackInt());
            this.m_pkt.skipBytes(8);
            this.setCapabilities(this.m_pkt.unpackInt());
            if (this.supportsExtendedSecurity()) {
                this.m_extendedSec = true;
            }
            SMBDate srvTime = NTTime.toSMBDate(this.m_pkt.unpackLong());
            int tzone = this.m_pkt.unpackWord();
            keyLen = this.m_pkt.unpackByte();
            unicodeStr = true;
            encAlgorithm = true;
            defFlags2 = 49157;
            if (this.isUsingExtendedSecurity()) {
                defFlags2 += 2048;
            }
        } else if (this.getDialect() > 1) {
            int secMode = this.m_pkt.getParameter(1);
            this.setSecurityMode((secMode & 1) != 0 ? 1 : 2);
            if (this.m_pkt.getParameterCount() >= 11) {
                keyLen = this.m_pkt.getParameter(11) & 0xFF;
            }
            this.setMaximumMultiplexedRequests(this.m_pkt.getParameter(3));
            this.setMaximumVirtualCircuits(this.m_pkt.getParameter(4));
            if (this.m_pkt.isUnicode()) {
                unicodeStr = true;
            }
            defFlags2 = 1;
        }
        this.setDefaultFlags2(defFlags2);
        if (this.m_pkt.getByteCount() > 0) {
            int bytsiz = this.m_pkt.getByteCount();
            int bytpos = this.m_pkt.getByteOffset();
            byte[] buf = this.m_pkt.getBuffer();
            if (!this.isUsingExtendedSecurity()) {
                if (keyLen > 0) {
                    byte[] encryptKey = new byte[keyLen];
                    for (int keyIdx = 0; keyIdx < keyLen; ++keyIdx) {
                        encryptKey[keyIdx] = buf[bytpos++];
                    }
                    this.setEncryptionKey(encryptKey);
                }
                String dom = !unicodeStr ? DataPacker.getString(buf, bytpos, bytsiz) : DataPacker.getUnicodeString(buf, bytpos, bytsiz / 2);
                this.setDomain(dom);
            } else {
                this.m_serverGUID = new byte[16];
                System.arraycopy(buf, bytpos, this.m_serverGUID, 0, 16);
                this.doExtendedSessionSetupPhase1();
            }
        }
    }

    private final void doExtendedSessionSetupPhase1() throws IOException, SMBException {
        SMBPacket pkt = new SMBPacket();
        pkt.setCommand(115);
        pkt.setFlags(this.getDefaultFlags());
        pkt.setFlags2(this.getDefaultFlags2());
        pkt.setParameterCount(12);
        pkt.setAndXCommand(255);
        pkt.setParameter(1, 0);
        pkt.setParameter(2, 1024);
        pkt.setParameter(3, 1);
        pkt.setParameter(4, 0);
        pkt.setParameterLong(5, 0);
        pkt.setParameter(7, 0);
        pkt.setParameterLong(8, 0);
        int caps = -2147483524;
        pkt.setParameterLong(10, caps);
        int pos = pkt.getByteOffset();
        pkt.setPosition(pos);
        Type1NTLMMessage type1Msg = new Type1NTLMMessage(pkt.getBuffer(), pos, 0);
        int type1Flags = this.getPCShare().getExtendedSecurityFlags();
        if (type1Flags == 0) {
            type1Flags = 517;
        }
        type1Msg.buildType1(type1Flags, null, null);
        pkt.setPosition(pos + type1Msg.getLength());
        pkt.setParameter(7, type1Msg.getLength());
        pkt.packString("Java VM", true);
        pkt.packString("Alfresco CIFS", true);
        pkt.packString("", true);
        pkt.setByteCount(pkt.getPosition() - pos);
        pkt.ExchangeSMB(this, pkt, false);
        if (!pkt.isLongErrorCode() || pkt.getLongErrorCode() != -1073741802) {
            pkt.checkForError();
        }
        this.setUserId(pkt.getUserId());
        int type2Len = pkt.getParameter(3);
        if (pkt.getByteCount() > 0) {
            byte[] buf = pkt.getBuffer();
            int offset = pkt.getByteOffset();
            int maxlen = offset + pkt.getByteCount();
            this.m_type2Msg = new Type2NTLMMessage();
            this.m_type2Msg.copyFrom(buf, offset, type2Len);
            this.m_encryptKey = this.m_type2Msg.getChallenge();
            offset = DataPacker.wordAlign(offset + type2Len);
            String srvOS = DataPacker.getString(buf, offset, maxlen -= type2Len);
            this.setOperatingSystem(srvOS);
            String lanman = DataPacker.getString(buf, offset += srvOS.length() + 1, maxlen -= srvOS.length() + 1);
            this.setLANManagerType(lanman);
        }
    }

    private final void doExtendedSessionSetupPhase2(String domain, String userName, String wksName, byte[] lmPwd, byte[] ntlmPwd, int vcNum) throws IOException, SMBException {
        if (domain == null) {
            domain = this.getPCShare().hasDomain() && this.getPCShare().getDomain().length() > 0 ? this.getPCShare().getDomain() : this.m_type2Msg.getTarget();
        }
        SMBPacket pkt = new SMBPacket();
        pkt.setCommand(115);
        pkt.setFlags(this.getDefaultFlags());
        pkt.setFlags2(this.getDefaultFlags2());
        pkt.setUserId(this.getUserId());
        pkt.setParameterCount(12);
        pkt.setAndXCommand(255);
        pkt.setParameter(1, 0);
        pkt.setParameter(2, 1024);
        pkt.setParameter(3, 1);
        pkt.setParameter(4, vcNum);
        pkt.setParameterLong(5, 0);
        pkt.setParameter(7, 0);
        pkt.setParameterLong(8, 0);
        int caps = -2147483524;
        pkt.setParameterLong(10, caps);
        int pos = pkt.getByteOffset();
        pkt.setPosition(pos);
        Type3NTLMMessage type3Msg = new Type3NTLMMessage(pkt.getBuffer(), pos, 0, true);
        type3Msg.buildType3(lmPwd, ntlmPwd, domain, userName, wksName != null ? wksName : "", null, this.m_type2Msg.getFlags());
        pkt.setPosition(pos + type3Msg.getLength());
        pkt.setParameter(7, type3Msg.getLength());
        pkt.packString("Java VM", true);
        pkt.packString("Alfresco CIFS", true);
        pkt.packString("", true);
        pkt.setByteCount(pkt.getPosition() - pos);
        pkt.ExchangeSMB(this, pkt, true);
        this.setGuest(pkt.getParameter(2) != 0);
    }
}

