/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.auth.kerberos;

import java.io.IOException;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosKey;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.server.auth.AuthContext;
import org.alfresco.jlan.server.auth.asn.DER;
import org.alfresco.jlan.server.auth.asn.DERBuffer;
import org.alfresco.jlan.server.auth.asn.DERObject;
import org.alfresco.jlan.server.auth.asn.DEROid;
import org.alfresco.jlan.server.auth.kerberos.EncApRepPart;
import org.alfresco.jlan.server.auth.kerberos.EncKrbTicket;
import org.alfresco.jlan.server.auth.kerberos.KerberosApRep;
import org.alfresco.jlan.server.auth.kerberos.KerberosApReq;
import org.alfresco.jlan.server.auth.kerberos.KrbAuthenticator;
import org.alfresco.jlan.server.auth.kerberos.KrbTicket;
import org.alfresco.jlan.util.HexDump;
import sun.security.krb5.EncryptedData;
import sun.security.krb5.EncryptionKey;

public class KrbAuthContext
extends AuthContext {
    private KerberosApReq m_apReq;
    private EncKrbTicket m_encTkt;
    private KrbAuthenticator m_krbAuth;
    private boolean m_debug;

    public final void parseKerberosApReq(Subject subj, KerberosApReq apReq) throws IOException {
        block11: {
            this.m_apReq = apReq;
            KrbTicket krbTkt = new KrbTicket(apReq.getTicket());
            if (this.hasDebug()) {
                Debug.println("Kerberos ticket - " + krbTkt);
            }
            Set<KerberosKey> krbKeySet = subj.getPrivateCredentials(KerberosKey.class);
            for (KerberosKey krbKey : krbKeySet) {
                if (krbKey.getKeyType() != krbTkt.getEncryptedType()) continue;
                EncryptionKey encKey = new EncryptionKey(krbKey.getEncoded(), krbKey.getKeyType(), new Integer(2));
                try {
                    DERBuffer derBuf;
                    byte[] encTktByts;
                    EncryptedData encPart = new EncryptedData(krbTkt.getEncryptedType(), krbTkt.getEncryptedPartKeyVersion() != -1 ? new Integer(krbTkt.getEncryptedPartKeyVersion()) : null, krbTkt.getEncryptedPart());
                    byte[] decPart = encPart.decrypt(encKey, 2);
                    if (this.hasDebug()) {
                        Debug.println("Decrypted ticket = Len=" + decPart.length + ", key=[Type=" + encKey.getEType() + ", Kvno=" + encKey.getKeyVersionNumber() + ", Key=" + HexDump.hexString(encKey.getBytes()) + "]");
                    }
                    if ((encTktByts = (derBuf = new DERBuffer(decPart)).unpackApplicationSpecificBytes()) == null) continue;
                    this.m_encTkt = new EncKrbTicket(encTktByts);
                    if (!this.hasDebug()) continue;
                    Debug.println("Enc Krb Ticket Part = " + this.m_encTkt);
                }
                catch (Exception ex) {
                    if (!this.hasDebug()) continue;
                    Debug.println("Ticket Error: " + ex);
                }
            }
            if (this.m_encTkt != null) {
                EncryptionKey encKey = new EncryptionKey(this.m_encTkt.getEncryptionKeyType(), this.m_encTkt.getEncryptionKey());
                try {
                    DERBuffer derBuf;
                    byte[] krbAuthByts;
                    EncryptedData encPart = new EncryptedData(apReq.getAuthenticatorEncType(), apReq.getAuthenticatorKeyVersion() != -1 ? new Integer(apReq.getAuthenticatorKeyVersion()) : null, apReq.getAuthenticator());
                    byte[] decPart = encPart.decrypt(encKey, 11);
                    if (this.hasDebug()) {
                        Debug.println("Decrypted authenticator = Len=" + decPart.length + ", key=[Type=" + encKey.getEType() + ", Kvno=" + encKey.getKeyVersionNumber() + ", Key=" + HexDump.hexString(encKey.getBytes()) + "]");
                    }
                    if ((krbAuthByts = (derBuf = new DERBuffer(decPart)).unpackApplicationSpecificBytes()) == null) break block11;
                    this.m_krbAuth = new KrbAuthenticator(krbAuthByts);
                    if (this.hasDebug()) {
                        Debug.println("Krb Authenticator = " + this.m_krbAuth);
                    }
                    break block11;
                }
                catch (Exception ex) {
                    if (this.hasDebug()) {
                        Debug.println("Auth Error: " + ex);
                    }
                    break block11;
                }
            }
            throw new IOException("Failed to decrypt Kerberos ticket");
        }
    }

    public final byte[] parseKerberosApRep(byte[] respTok) throws Exception {
        byte[] encApRepByts;
        DERBuffer derBuf = new DERBuffer(respTok);
        byte[] aprepBlob = null;
        DEROid oid = null;
        int tokId = 0;
        DERObject derObj = derBuf.unpackApplicationSpecific();
        if (derObj != null) {
            if (derObj instanceof DEROid) {
                oid = (DEROid)derObj;
            }
            tokId = derBuf.unpackByte();
            tokId += derBuf.unpackByte() >> 8;
            if (DER.isApplicationSpecific(derBuf.peekType())) {
                aprepBlob = derBuf.unpackApplicationSpecificBytes();
            }
        }
        KerberosApRep krbApRep = new KerberosApRep(aprepBlob);
        if (this.hasDebug()) {
            Debug.println("Kerberos AP-REP - " + krbApRep);
        }
        EncryptionKey encKey = new EncryptionKey(this.m_encTkt.getEncryptionKeyType(), this.m_encTkt.getEncryptionKey());
        byte[] updRespTok = null;
        EncryptedData encPart = new EncryptedData(krbApRep.getEncryptionType(), krbApRep.getKeyVersion() != -1 ? new Integer(krbApRep.getKeyVersion()) : null, krbApRep.getEncryptedPart());
        byte[] decPart = encPart.decrypt(encKey, 12);
        if (this.hasDebug()) {
            Debug.println("Decrypted AP-REP Len=" + decPart.length + ", key=[Type=" + encKey.getEType() + ", Key=" + HexDump.hexString(encKey.getBytes()) + "]");
        }
        if ((encApRepByts = (derBuf = new DERBuffer(decPart)).unpackApplicationSpecificBytes()) != null) {
            Debug.println("EncApRep bytes:");
            HexDump.Dump(decPart, decPart.length, 0, Debug.getDebugInterface());
            EncApRepPart encApRep = new EncApRepPart(encApRepByts);
            if (this.hasDebug()) {
                Debug.println("EncApRep = " + encApRep);
            }
            if (encApRep.getSubKey() == null) {
                encApRep.setSubkey(this.m_krbAuth.getSubKeyType(), this.m_krbAuth.getSubKey());
                if (this.hasDebug()) {
                    Debug.println("Using client sub-key, type=" + this.m_krbAuth.getSubKeyType() + ", key=" + HexDump.hexString(this.m_krbAuth.getSubKey()));
                }
                decPart = encApRep.encodeApRep();
                Debug.println("Re-encoded EncapRep bytes:");
                HexDump.Dump(decPart, decPart.length, 0, Debug.getDebugInterface());
                encPart = new EncryptedData(encKey, decPart, 12);
                krbApRep.setEncryptedPart(krbApRep.getEncryptionType(), encPart.getBytes(), krbApRep.getKeyVersion());
                aprepBlob = krbApRep.encodeApRep();
                DERBuffer oidBuf = new DERBuffer();
                oid.derEncode(oidBuf);
                byte[] oidBytes = oidBuf.getBytes();
                updRespTok = new byte[aprepBlob.length + 2 + oidBytes.length];
                int pos = 0;
                System.arraycopy(oidBytes, 0, updRespTok, pos, oidBytes.length);
                pos += oidBytes.length;
                updRespTok[pos++] = (byte)(tokId & 0xFF);
                updRespTok[pos++] = (byte)(tokId >> 8 & 0xFF);
                System.arraycopy(aprepBlob, 0, updRespTok, pos, aprepBlob.length);
                DERBuffer appBuf = new DERBuffer();
                appBuf.packApplicationSpecific(updRespTok);
                updRespTok = appBuf.getBytes();
            }
        }
        return updRespTok;
    }

    public final boolean hasDebug() {
        return this.m_debug;
    }

    public final void setDebug(boolean ena) {
        this.m_debug = ena;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("[KrbAuthCtx:AP-REQ=");
        str.append(this.m_apReq);
        str.append(",EncTkt=");
        str.append(this.m_encTkt);
        str.append(",KrbAuth=");
        str.append(this.m_krbAuth);
        str.append("]");
        return str.toString();
    }
}

