/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.server.auth.asn;

import java.io.IOException;
import java.util.List;
import org.alfresco.jlan.server.auth.asn.DER;
import org.alfresco.jlan.server.auth.asn.DERApplicationSpecific;
import org.alfresco.jlan.server.auth.asn.DERBitString;
import org.alfresco.jlan.server.auth.asn.DERBoolean;
import org.alfresco.jlan.server.auth.asn.DEREnumerated;
import org.alfresco.jlan.server.auth.asn.DERGeneralString;
import org.alfresco.jlan.server.auth.asn.DERGeneralizedTime;
import org.alfresco.jlan.server.auth.asn.DERInteger;
import org.alfresco.jlan.server.auth.asn.DERObject;
import org.alfresco.jlan.server.auth.asn.DEROctetString;
import org.alfresco.jlan.server.auth.asn.DEROid;
import org.alfresco.jlan.server.auth.asn.DERSequence;
import org.alfresco.jlan.util.DataPacker;

public class DERBuffer {
    private static final int DefaultBufferSize = 256;
    private static final boolean DebugEnable = false;
    private byte[] m_data;
    private int m_pos;
    private int m_endpos;
    private int m_offset;

    public DERBuffer() {
        this.m_data = new byte[256];
        this.m_pos = 0;
        this.m_offset = 0;
    }

    public DERBuffer(int siz) {
        this.m_data = new byte[siz];
        this.m_pos = 0;
        this.m_offset = 0;
    }

    public DERBuffer(byte[] buf, int off, int len) {
        this.m_data = buf;
        this.m_offset = off;
        this.m_pos = off;
        this.m_endpos = off + len;
    }

    public DERBuffer(byte[] buf) {
        this.m_data = buf;
        this.m_offset = 0;
        this.m_pos = 0;
        this.m_endpos = buf.length;
    }

    public final byte[] getBuffer() {
        return this.m_data;
    }

    public final int getLength() {
        if (this.m_endpos != 0) {
            return this.m_endpos - this.m_offset;
        }
        return this.m_pos - this.m_offset;
    }

    public final int getLengthInWords() {
        return this.getLength() / 2;
    }

    public final int getAvailableLength() {
        if (this.m_endpos == 0) {
            return -1;
        }
        return this.m_endpos - this.m_pos;
    }

    public final int getPosition() {
        return this.m_pos;
    }

    public final byte[] getBytes() {
        if (this.getLength() == 0) {
            return null;
        }
        byte[] byts = new byte[this.getLength()];
        System.arraycopy(this.m_data, this.m_offset, byts, 0, this.getLength());
        return byts;
    }

    public final int unpackByte() {
        if (this.m_data.length - this.m_pos < 1) {
            throw new ArrayIndexOutOfBoundsException("End of data buffer");
        }
        return this.m_data[this.m_pos++] & 0xFF;
    }

    public final byte[] unpackBytes(int len) {
        if (this.m_data.length - this.m_pos < len) {
            throw new ArrayIndexOutOfBoundsException("End of data buffer");
        }
        byte[] byts = new byte[len];
        System.arraycopy(this.m_data, this.m_pos, byts, 0, len);
        this.m_pos += len;
        return byts;
    }

    public final int peekType() {
        if (this.m_data.length - this.m_pos < 1) {
            throw new ArrayIndexOutOfBoundsException("End of data buffer");
        }
        return this.m_data[this.m_pos] & 0xFF;
    }

    public final int unpackType() {
        return this.unpackByte();
    }

    public final int unpackLength() {
        int dlen;
        if (this.m_data.length - this.m_pos < 1) {
            throw new ArrayIndexOutOfBoundsException("End of data buffer");
        }
        if (((dlen = this.m_data[this.m_pos++] & 0xFF) & 0x80) != 0) {
            int numByts = dlen & 0x7F;
            dlen = 0;
            while (numByts-- > 0) {
                dlen = (dlen << 8) + (this.m_data[this.m_pos++] & 0xFF);
            }
        }
        return dlen;
    }

    public final DERObject unpackObject() throws IOException {
        int objTyp = this.peekType();
        int tagNo = -1;
        if ((objTyp & 0x80) != 0) {
            tagNo = objTyp & 0x1F;
            this.unpackType();
            this.unpackLength();
            objTyp = this.peekType();
        }
        DERObject derObj = null;
        if ((objTyp & 0x40) != 0) {
            derObj = new DERApplicationSpecific();
        } else {
            switch (DER.isType(objTyp)) {
                case 3: {
                    derObj = new DERBitString();
                    break;
                }
                case 1: {
                    derObj = new DERBoolean();
                    break;
                }
                case 10: {
                    derObj = new DEREnumerated();
                    break;
                }
                case 27: {
                    derObj = new DERGeneralString();
                    break;
                }
                case 2: {
                    derObj = new DERInteger();
                    break;
                }
                case 18: {
                    break;
                }
                case 6: {
                    derObj = new DEROid();
                    break;
                }
                case 4: {
                    derObj = new DEROctetString();
                    break;
                }
                case 19: {
                    break;
                }
                case 16: {
                    derObj = new DERSequence();
                    break;
                }
                case 28: {
                    break;
                }
                case 12: {
                    break;
                }
                case 24: {
                    derObj = new DERGeneralizedTime();
                }
            }
        }
        if (derObj == null) {
            throw new IOException("ASN.1 type 0x" + Integer.toHexString(objTyp) + " decode not supported");
        }
        derObj.derDecode(this);
        if (tagNo != -1) {
            derObj.setTagNo(tagNo);
        }
        return derObj;
    }

    public final int unpackInt(int len) {
        if (this.m_data.length - this.m_pos < len) {
            throw new ArrayIndexOutOfBoundsException("End of data buffer");
        }
        int ival = 0;
        for (int i = 0; i < len; ++i) {
            ival <<= 8;
            ival += this.unpackByte();
        }
        return ival;
    }

    public final long unpackLong(int len) {
        if (this.m_data.length - this.m_pos < len) {
            throw new ArrayIndexOutOfBoundsException("End of data buffer");
        }
        int lval = 0;
        for (int i = 0; i < len; ++i) {
            lval <<= 8;
            lval += this.unpackByte();
        }
        return lval;
    }

    public final void packByte(int bval) {
        if (this.m_data.length - this.m_pos < 1) {
            this.extendBuffer();
        }
        this.m_data[this.m_pos++] = (byte)(bval & 0xFF);
    }

    public final void packByteAt(int pos, int bval) {
        this.m_data[pos] = (byte)(bval & 0xFF);
    }

    public final void packBytes(byte[] buf, int off, int len) {
        if (this.m_data.length - this.m_pos < len) {
            this.extendBuffer(len);
        }
        System.arraycopy(buf, off, this.m_data, this.m_pos, len);
        this.m_pos += len;
    }

    public final void packBytes(DERBuffer buf) {
        if (this.m_data.length - this.m_pos < buf.getLength()) {
            this.extendBuffer(buf.getLength());
        }
        System.arraycopy(buf.getBuffer(), 0, this.m_data, this.m_pos, buf.getLength());
        this.m_pos += buf.getLength();
    }

    public final void packLength(int len) {
        if (this.m_data.length - this.m_pos < 4) {
            this.extendBuffer();
        }
        if (len < 128) {
            this.packByte(len);
        } else {
            int sizByts = this.calculateLengthBytes(len);
            this.packByte(sizByts + 128);
            for (int shift = (sizByts - 1) * 8; shift >= 0; shift -= 8) {
                this.packByte(len >> shift);
            }
        }
    }

    public final void packInt(int ival) {
        if (this.m_data.length - this.m_pos < 4) {
            this.extendBuffer();
        }
        DataPacker.putIntelInt(ival, this.m_data, this.m_pos);
        this.m_pos += 4;
    }

    public final void packLong(long lval) {
        if (this.m_data.length - this.m_pos < 8) {
            this.extendBuffer();
        }
        DataPacker.putIntelLong(lval, this.m_data, this.m_pos);
        this.m_pos += 8;
    }

    public final void packObject(DERObject derObj) throws IOException {
        if (derObj.isTagged()) {
            DERBuffer derBuf = new DERBuffer();
            derObj.derEncode(derBuf);
            this.packByte(160 + derObj.getTagNo());
            this.packLength(derBuf.getLength());
            this.packBytes(derBuf);
        } else {
            derObj.derEncode(this);
        }
    }

    public final void packApplicationSpecific(DERObject derObj) throws IOException {
        this.packApplicationSpecific(0, derObj);
    }

    public final void packApplicationSpecific(int tagId, DERObject derObj) throws IOException {
        this.packByte(96 + (tagId & 0x1F));
        DERBuffer derBuf = new DERBuffer();
        derBuf.packObject(derObj);
        this.packLength(derBuf.getLength());
        this.packBytes(derBuf);
    }

    public final void packApplicationSpecific(List derList) throws IOException {
        this.packApplicationSpecific(0, derList);
    }

    public final void packApplicationSpecific(int tagId, List derList) throws IOException {
        this.packByte(96 + (tagId & 0x1F));
        DERBuffer derBuf = null;
        if (derList != null && derList.size() > 0) {
            derBuf = new DERBuffer();
            for (int i = 0; i < derList.size(); ++i) {
                DERObject derObj = (DERObject)derList.get(i);
                derBuf.packObject(derObj);
            }
            this.packLength(derBuf.getLength());
            this.packBytes(derBuf);
        } else {
            this.packLength(0);
        }
    }

    public final void packApplicationSpecific(int tagId, byte[] byts) throws IOException {
        this.packByte(96 + (tagId & 0x1F));
        this.packLength(byts.length);
        this.packBytes(byts, 0, byts.length);
    }

    public final void packApplicationSpecific(byte[] byts) throws IOException {
        this.packApplicationSpecific(0, byts);
    }

    public final DERObject unpackApplicationSpecific() throws IOException {
        DERObject derObj = null;
        int typ = this.unpackType();
        if (!DER.isApplicationSpecific(typ)) {
            throw new IOException("Wrong DER type, expected Application or Context");
        }
        this.unpackLength();
        derObj = this.unpackObject();
        return derObj;
    }

    public final byte[] unpackApplicationSpecificBytes() throws IOException {
        int typ = this.unpackType();
        byte[] objByts = null;
        if (!DER.isApplicationSpecific(typ)) {
            throw new IOException("Wrong DER type, expected Application or Context");
        }
        int len = this.unpackLength();
        objByts = this.unpackBytes(len);
        return objByts;
    }

    public final int calculateLengthBytes(int len) {
        int sizByts = 1;
        if (len > 255) {
            sizByts = 2;
            if (len > 0xFFFFFF) {
                sizByts = 4;
            } else if (len > 65535) {
                sizByts = 3;
            }
        }
        return sizByts;
    }

    public final void setPosition(int pos) {
        this.m_pos = pos;
    }

    public final void setEndOfBuffer() {
        this.m_endpos = this.m_pos;
        this.m_pos = this.m_offset;
    }

    public final void setLength(int len) {
        this.m_pos = this.m_offset + len;
    }

    private final void extendBuffer(int ext) {
        byte[] newBuf = new byte[this.m_data.length + ext];
        System.arraycopy(this.m_data, 0, newBuf, 0, this.m_data.length);
        this.m_data = newBuf;
    }

    private final void extendBuffer() {
        this.extendBuffer(this.m_data.length * 2);
    }
}

