/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.client;

import java.io.IOException;
import java.net.SocketTimeoutException;
import org.alfresco.jlan.client.SMBFile;
import org.alfresco.jlan.client.SMBPacket;
import org.alfresco.jlan.client.Session;
import org.alfresco.jlan.client.info.FileInfo;
import org.alfresco.jlan.smb.SMBDate;
import org.alfresco.jlan.smb.SMBException;

public final class DataPipeFile
extends SMBFile {
    private static final int DataSize = 4000;
    private static final int PacketSize = 4128;
    private static final int WriteDataOffset = 64;
    private static final int WriteDataPadding = 1;
    private static final long Maximum32BitOffset = 0xFFFFFFFFL;
    private static final int PipeBroken = 4096;
    public static final int NoTimeout = 0;
    private boolean m_NTdialect;

    protected DataPipeFile(Session sess, FileInfo finfo, int fid) {
        super(sess, finfo, fid);
        this.m_NTdialect = sess.getDialect() == 7;
    }

    @Override
    public final void Close(SMBDate wrDateTime) throws IOException, SMBException {
        if (this.m_txlen > 0) {
            this.Flush();
        }
        SMBPacket pkt = new SMBPacket();
        pkt.setUserId(this.m_sess.getUserId());
        pkt.setTreeId(this.m_sess.getTreeId());
        pkt.setCommand(4);
        pkt.setParameterCount(3);
        pkt.setParameter(0, this.m_FID);
        pkt.setParameter(1, 0);
        pkt.setParameter(2, 0);
        this.setStateFlag(2, true);
        try {
            pkt.ExchangeSMB(this.m_sess, pkt);
        }
        catch (IOException ex) {
            return;
        }
        this.m_rxpkt = null;
        this.m_txpkt = null;
        this.getSession().CloseSession();
    }

    @Override
    public final void Flush() throws IOException, SMBException {
        if (this.m_txlen > 0) {
            this.WriteData();
        }
    }

    @Override
    public final int Read(byte[] buf, int siz, int offset) throws IOException, SMBException {
        return this.Read(buf, siz, offset, 0, siz);
    }

    public final int Read(byte[] buf, int siz, int offset, int minSiz) throws IOException, SMBException {
        return this.Read(buf, siz, offset, 0, minSiz);
    }

    private final int Read(byte[] buf, int siz, int offset, int tmo, int minSiz) throws IOException, SMBException {
        int retlen;
        if (this.isClosed()) {
            return -1;
        }
        if (this.m_rxlen == 0) {
            if (!this.ReadData(tmo, minSiz)) {
                return -1;
            }
            if (this.m_rxlen == 0) {
                return 0;
            }
        }
        if ((retlen = this.m_rxlen) > siz) {
            retlen = siz;
        }
        byte[] pktbuf = this.m_rxpkt.getBuffer();
        System.arraycopy(pktbuf, this.m_rxoffset, buf, offset, retlen);
        this.m_rxlen -= retlen;
        this.m_rxoffset += retlen;
        return retlen;
    }

    private final boolean ReadData(int tmo, int minSiz) throws SMBException, IOException {
        if (!this.isNTDialect() && this.m_rxpos > 0xFFFFFFFFL) {
            throw new SMBException(5, 7);
        }
        if (this.isPipeBroken()) {
            throw new SMBException(6, -1073741493);
        }
        if (this.m_rxpkt == null) {
            this.m_rxpkt = this.m_sess.allocatePacket(4128);
            this.m_rxpkt.setUserId(this.m_sess.getUserId());
            this.m_rxpkt.setTreeId(this.m_sess.getTreeId());
        }
        this.m_rxpkt.setCommand(46);
        this.m_rxpkt.setParameterCount(this.isNTDialect() ? 12 : 10);
        this.m_rxpkt.setAndXCommand(255);
        this.m_rxpkt.setFlags(this.m_sess.getDefaultFlags());
        this.m_rxpkt.setFlags2(this.m_sess.getDefaultFlags2());
        this.m_rxpkt.setProcessId(this.m_sess.getProcessId());
        this.m_rxpkt.setParameter(2, this.getFileId());
        this.m_rxpkt.setParameterLong(3, (int)(this.m_rxpos & 0xFFFFFFFFFFFFFFFFL));
        int maxCount = this.m_rxpkt.getBuffer().length - 64;
        this.m_rxpkt.setParameter(5, maxCount);
        this.m_rxpkt.setParameter(6, minSiz);
        this.m_rxpkt.setParameterLong(7, tmo);
        this.m_rxpkt.setParameter(9, maxCount);
        if (this.isNTDialect()) {
            this.m_rxpkt.setParameterLong(10, (int)(this.m_rxpos >> 32 & 0xFFFFFFFFL));
        }
        this.m_rxpkt.setByteCount(0);
        try {
            this.m_rxpkt.ExchangeSMB(this.m_sess, this.m_rxpkt, true);
        }
        catch (SocketTimeoutException ex) {
            return false;
        }
        catch (SMBException ex) {
            if (ex.getErrorClass() == 6 && ex.getErrorCode() == -1073741607) {
                return true;
            }
            if (ex.getErrorClass() == 6 && (ex.getErrorCode() == -1073741493 || ex.getErrorCode() == -1073741648)) {
                this.setStateFlag(1, true);
                this.setStateFlag(4096, true);
                return false;
            }
            throw ex;
        }
        if (this.m_rxpkt.isValidResponse()) {
            this.m_rxlen = this.m_rxpkt.getParameter(5);
            this.m_rxoffset = this.m_rxpkt.getParameter(6) + 4;
            this.m_rxpos += (long)this.m_rxlen;
            return true;
        }
        return false;
    }

    @Override
    public final int Write(byte[] buf, int siz, int offset) throws IOException, SMBException {
        if (this.isClosed()) {
            return 0;
        }
        if (this.m_txpkt == null) {
            this.m_txpkt = this.m_sess.allocatePacket(4128);
            this.m_txpkt.setUserId(this.m_sess.getUserId());
            this.m_txpkt.setTreeId(this.m_sess.getTreeId());
            this.m_txpkt.setProcessId(this.m_sess.getProcessId());
            this.m_txpkt.setParameterCount(this.isNTDialect() ? 14 : 12);
            this.m_txlen = 0;
            this.m_txoffset = 64;
            if (this.isNTDialect()) {
                this.m_txoffset += 4;
            }
        }
        int txlen = 0;
        while (txlen < siz) {
            byte[] pktbuf = this.m_txpkt.getBuffer();
            int len = pktbuf.length - this.m_txoffset;
            if (len > siz - txlen) {
                len = siz - txlen;
            }
            System.arraycopy(buf, offset, pktbuf, this.m_txoffset, len);
            this.m_txoffset += len;
            offset += len;
            txlen += len;
            this.m_txlen += len;
            this.WriteData();
        }
        return txlen;
    }

    private final boolean WriteData() throws SMBException, IOException {
        if (!this.isNTDialect() && this.m_txpos > 0xFFFFFFFFL) {
            throw new SMBException(5, 7);
        }
        this.m_txpkt.setCommand(47);
        this.m_txpkt.setAndXCommand(255);
        this.m_txpkt.setFlags(this.m_sess.getDefaultFlags());
        this.m_txpkt.setFlags2(this.m_sess.getDefaultFlags2());
        this.m_txpkt.setParameterCount(this.isNTDialect() ? 14 : 12);
        this.m_txpkt.setParameter(2, this.getFileId());
        this.m_txpkt.setParameterLong(3, (int)(this.m_txpos & 0xFFFFFFFFFFFFFFFFL));
        this.m_txpkt.setParameterLong(5, 0);
        this.m_txpkt.setParameter(7, 8);
        this.m_txpkt.setParameter(8, this.m_txlen);
        this.m_txpkt.setParameter(9, 0);
        this.m_txpkt.setParameter(10, this.m_txlen);
        int offset = 60;
        if (this.isNTDialect()) {
            offset += 4;
        }
        this.m_txpkt.setParameter(11, offset);
        if (this.isNTDialect()) {
            this.m_txpkt.setParameterLong(12, (int)(this.m_txpos >> 32 & 0xFFFFFFFFL));
        }
        this.m_txpkt.setByteCount(this.m_txlen + 1);
        this.m_txpkt.ExchangeSMB(this.m_sess, this.m_txpkt, false);
        if (this.m_txpkt.isValidResponse()) {
            int txlen = this.m_txpkt.getParameter(2);
            this.m_txpos += (long)txlen;
            this.m_txlen = 0;
            this.m_txoffset = 64;
            if (this.isNTDialect()) {
                this.m_txoffset += 4;
            }
            return true;
        }
        this.m_txlen = 0;
        this.m_txoffset = 64;
        if (this.isNTDialect()) {
            this.m_txoffset += 4;
        }
        this.m_txpkt.checkForError();
        return false;
    }

    @Override
    public long Seek(long pos, int typ) throws IOException, SMBException {
        if (this.isClosed()) {
            throw new IOException("Seek on closed file");
        }
        this.Flush();
        switch (typ) {
            case 0: {
                this.m_txpos = this.m_rxpos = pos;
                break;
            }
            case 1: {
                this.m_rxpos = this.m_txpos = this.m_rxpos + pos;
                break;
            }
            case 2: {
                this.m_txpos = this.m_rxpos = this.getFileSize() + pos;
            }
        }
        this.m_txlen = 0;
        this.m_rxlen = 0;
        return this.m_rxpos;
    }

    @Override
    public void Lock(long offset, long len) throws IOException, SMBException {
        if (!this.isNTDialect() && offset > 0xFFFFFFFFL) {
            throw new SMBException(5, 7);
        }
        SMBPacket pkt = new SMBPacket();
        pkt.setUserId(this.m_sess.getUserId());
        pkt.setTreeId(this.m_sess.getTreeId());
        pkt.setCommand(36);
        pkt.setProcessId(this.m_sess.getProcessId());
        pkt.setParameterCount(8);
        pkt.setAndXCommand(255);
        pkt.setParameter(2, this.m_FID);
        pkt.setParameter(3, this.m_sess.supportsLargeFiles() ? 16 : 0);
        pkt.setParameterLong(4, 0);
        pkt.setParameter(6, 0);
        pkt.setParameter(7, 1);
        pkt.resetBytePointer();
        if (this.m_sess.supportsLargeFiles()) {
            pkt.packWord(this.m_sess.getProcessId());
            pkt.packWord(0);
            pkt.packInt((int)(offset >> 32 & 0xFFFFFFFFL));
            pkt.packInt((int)(offset & 0xFFFFFFFFL));
            pkt.packInt((int)(len >> 32 & 0xFFFFFFFFL));
            pkt.packInt((int)(len & 0xFFFFFFFFL));
        } else {
            pkt.packWord(this.m_sess.getProcessId());
            pkt.packInt((int)(offset & 0xFFFFFFFFL));
            pkt.packInt((int)(len & 0xFFFFFFFFL));
        }
        pkt.setByteCount();
        pkt.ExchangeSMB(this.m_sess, pkt, true);
    }

    @Override
    public void Unlock(long offset, long len) throws IOException, SMBException {
        if (!this.isNTDialect() && offset > 0xFFFFFFFFL) {
            throw new SMBException(5, 7);
        }
        SMBPacket pkt = new SMBPacket();
        pkt.setUserId(this.m_sess.getUserId());
        pkt.setTreeId(this.m_sess.getTreeId());
        pkt.setCommand(36);
        pkt.setProcessId(this.m_sess.getProcessId());
        pkt.setParameterCount(8);
        pkt.setAndXCommand(255);
        pkt.setParameter(2, this.m_FID);
        pkt.setParameter(3, this.m_sess.supportsLargeFiles() ? 16 : 0);
        pkt.setParameterLong(4, 0);
        pkt.setParameter(6, 1);
        pkt.setParameter(7, 0);
        pkt.resetBytePointer();
        if (this.m_sess.supportsLargeFiles()) {
            pkt.packWord(this.m_sess.getProcessId());
            pkt.packWord(0);
            pkt.packInt((int)(offset >> 32 & 0xFFFFFFFFL));
            pkt.packInt((int)(offset & 0xFFFFFFFFL));
            pkt.packInt((int)(len >> 32 & 0xFFFFFFFFL));
            pkt.packInt((int)(len & 0xFFFFFFFFL));
        } else {
            pkt.packWord(this.m_sess.getProcessId());
            pkt.packInt((int)(offset & 0xFFFFFFFFL));
            pkt.packInt((int)(len & 0xFFFFFFFFL));
        }
        pkt.setByteCount();
        pkt.ExchangeSMB(this.m_sess, pkt, true);
    }

    protected final boolean isNTDialect() {
        return this.m_NTdialect;
    }

    public final boolean isPipeBroken() {
        return this.hasStateFlag(4096);
    }
}

