/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.jlan.app;

import java.io.File;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import org.alfresco.jlan.app.DriveMappingsConfigSection;
import org.alfresco.jlan.app.XMLServerConfiguration;
import org.alfresco.jlan.debug.Debug;
import org.alfresco.jlan.debug.DebugConfigSection;
import org.alfresco.jlan.netbios.server.NetBIOSNameServer;
import org.alfresco.jlan.netbios.win32.Win32NetBIOS;
import org.alfresco.jlan.server.NetworkServer;
import org.alfresco.jlan.server.ServerListener;
import org.alfresco.jlan.server.config.ServerConfiguration;
import org.alfresco.jlan.smb.SMBErrorText;
import org.alfresco.jlan.smb.server.CIFSConfigSection;
import org.alfresco.jlan.smb.server.SMBServer;
import org.alfresco.jlan.smb.util.DriveMapping;
import org.alfresco.jlan.smb.util.DriveMappingList;
import org.alfresco.jlan.util.ConsoleIO;
import org.alfresco.jlan.util.Platform;
import org.alfresco.jlan.util.win32.Win32Utils;

public class JLANCifsServer
implements ServerListener {
    public static final int CheckPointStarting = 0;
    public static final int CheckPointConfigLoading = 1;
    public static final int CheckPointConfigLoaded = 2;
    public static final int CheckPointCheckIPAddress = 3;
    public static final int CheckPointCreateSMBServer = 4;
    public static final int CheckPointServersStart = 5;
    public static final int CheckPointServersStarted = 6;
    public static final int CheckPointRunning = 7;
    public static final int CheckPointServersStop = 8;
    public static final int CheckPointServersStopped = 9;
    public static final int CheckPointFinished = 10;
    private static final String DEFAULT_CONFIGFILENAME = "jlanserver.xml";
    private static final boolean CheckLocalIPAddress = false;
    protected static boolean m_shutdown = false;
    protected static boolean m_restart = false;
    protected static boolean m_allowShutViaConsole = true;
    protected static boolean m_dumpStackOnError = true;
    private ServerConfiguration m_srvConfig;

    public static void main(String[] args) {
        JLANCifsServer jlanServer = new JLANCifsServer();
        while (!m_shutdown) {
            jlanServer.start(args);
            if (!m_restart) continue;
            Debug.println("Restarting server ...");
            Debug.println("--------------------------------------------------");
        }
    }

    protected JLANCifsServer() {
    }

    public static final void setAllowConsoleShutdown(boolean consoleShut) {
        m_allowShutViaConsole = consoleShut;
    }

    protected final void enableExceptionStackDump(boolean ena) {
        m_dumpStackOnError = ena;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void start(String[] args) {
        PrintStream out = this.createOutputStream();
        m_shutdown = true;
        m_restart = false;
        this.checkPoint(out, 0);
        this.m_srvConfig = null;
        try {
            this.checkPoint(out, 1);
            this.m_srvConfig = this.loadConfiguration(out, args);
            this.checkPoint(out, 2);
        }
        catch (Exception ex) {
            this.checkPointError(out, 1, ex);
            return;
        }
        try {
            if (this.m_srvConfig.hasConfigSection("CIFS")) {
                this.checkPoint(out, 4);
                CIFSConfigSection cifsConfig = (CIFSConfigSection)this.m_srvConfig.getConfigSection("CIFS");
                if (cifsConfig.hasWin32NetBIOS()) {
                    Win32NetBIOS.LanaEnumerate();
                }
                if (cifsConfig.hasNetBIOSSMB()) {
                    this.m_srvConfig.addServer(this.createNetBIOSServer(this.m_srvConfig));
                }
                this.m_srvConfig.addServer(this.createSMBServer(this.m_srvConfig));
            }
            this.checkPoint(out, 5);
            DebugConfigSection dbgConfig = (DebugConfigSection)this.m_srvConfig.getConfigSection("Debug");
            for (int i = 0; i < this.m_srvConfig.numberOfServers(); ++i) {
                NetworkServer server = this.m_srvConfig.getServer(i);
                if (dbgConfig != null && dbgConfig.hasDebug()) {
                    Debug.println("Starting server " + server.getProtocolName() + " ...");
                }
                this.m_srvConfig.getServer(i).startServer();
            }
            this.checkPoint(out, 6);
            boolean service = false;
            if (!ConsoleIO.isValid()) {
                service = true;
            }
            this.checkPoint(out, 7);
            m_shutdown = false;
            while (!m_shutdown && !m_restart) {
                if (!service && m_allowShutViaConsole) {
                    int inChar = ConsoleIO.readCharacter();
                    if (inChar == 120 || inChar == 88) {
                        m_shutdown = true;
                        continue;
                    }
                    if (inChar == 114 || inChar == 82) {
                        m_restart = true;
                        continue;
                    }
                    if (inChar != -1) continue;
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex) {}
                    continue;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ex) {}
            }
            this.checkPoint(out, 8);
            int idx = this.m_srvConfig.numberOfServers() - 1;
            while (idx >= 0) {
                NetworkServer server = this.m_srvConfig.getServer(idx--);
                if (dbgConfig != null && dbgConfig.hasDebug()) {
                    Debug.println("Shutting server " + server.getProtocolName() + " ...");
                }
                server.shutdownServer(false);
            }
            this.m_srvConfig.closeConfiguration();
            this.checkPoint(out, 9);
        }
        catch (Exception ex) {
            this.checkPointError(out, 6, ex);
        }
        finally {
            int idx = this.m_srvConfig.numberOfServers() - 1;
            while (idx >= 0) {
                NetworkServer srv;
                if (!(srv = this.m_srvConfig.getServer(idx--)).isActive()) continue;
                srv.shutdownServer(true);
            }
        }
        this.checkPoint(out, 10);
    }

    public static final void shutdownServer(String[] args) {
        m_shutdown = true;
    }

    protected final NetworkServer createSMBServer(ServerConfiguration config) throws Exception {
        SMBServer smbServer = new SMBServer(config);
        if (Platform.isPlatformType() == Platform.Type.WINDOWS && config.hasConfigSection("DriveMappings")) {
            smbServer.addServerListener(this);
        }
        return smbServer;
    }

    protected final NetworkServer createNetBIOSServer(ServerConfiguration config) throws Exception {
        return new NetBIOSNameServer(config);
    }

    protected final NetworkServer createServer(String className, ServerConfiguration config) throws Exception {
        NetworkServer srv = null;
        Class[] classes = new Class[]{ServerConfiguration.class};
        Constructor<?> srvConstructor = Class.forName(className).getConstructor(classes);
        Object[] args = new Object[]{config};
        srv = (NetworkServer)srvConstructor.newInstance(args);
        return srv;
    }

    protected ServerConfiguration loadConfiguration(PrintStream out, String[] cmdLineArgs) throws Exception {
        String fileName = null;
        fileName = cmdLineArgs.length < 1 ? System.getProperty("user.home") + File.separator + DEFAULT_CONFIGFILENAME : cmdLineArgs[0];
        XMLServerConfiguration srvCfg = null;
        srvCfg = new XMLServerConfiguration();
        ((ServerConfiguration)srvCfg).loadConfiguration(fileName);
        return srvCfg;
    }

    protected PrintStream createOutputStream() {
        return System.out;
    }

    protected void checkPoint(PrintStream out, int check) {
    }

    protected void checkPointError(PrintStream out, int check, Exception ex) {
        String msg = "%% Error occurred";
        switch (check) {
            case 1: {
                msg = "%% Failed to load server configuration";
                break;
            }
            case 3: {
                msg = "%% Failed to get local IP address details";
                break;
            }
            case 6: {
                msg = "%% Server error";
            }
        }
        out.println(msg);
        if (m_dumpStackOnError) {
            ex.printStackTrace(out);
        }
    }

    @Override
    public void serverStatusEvent(NetworkServer server, int event) {
        block5: {
            DriveMappingsConfigSection mapConfig;
            block6: {
                if (!(server instanceof SMBServer)) break block5;
                mapConfig = (DriveMappingsConfigSection)this.m_srvConfig.getConfigSection("DriveMappings");
                if (mapConfig == null) {
                    return;
                }
                if (event != 0) break block6;
                DriveMappingList mapList = mapConfig.getMappedDrives();
                for (int i = 0; i < mapList.numberOfMappings(); ++i) {
                    int sts;
                    DriveMapping driveMap = mapList.getMappingAt(i);
                    if (mapConfig.hasDebug()) {
                        Debug.println("Mapping drive " + driveMap.getLocalDrive() + " to " + driveMap.getRemotePath() + " ...");
                    }
                    if ((sts = Win32Utils.MapNetworkDrive(driveMap.getRemotePath(), driveMap.getLocalDrive(), driveMap.getUserName(), driveMap.getPassword(), driveMap.hasInteractive(), driveMap.hasPrompt())) == 0) continue;
                    Debug.println("Failed to map drive " + driveMap.getLocalDrive() + " to " + driveMap.getRemotePath() + ", status = " + SMBErrorText.ErrorString(8, sts));
                }
                break block5;
            }
            if (event != 2) break block5;
            DriveMappingList mapList = mapConfig.getMappedDrives();
            for (int i = 0; i < mapList.numberOfMappings(); ++i) {
                int sts;
                DriveMapping driveMap = mapList.getMappingAt(i);
                if (mapConfig.hasDebug()) {
                    Debug.println("Removing mapped drive " + driveMap.getLocalDrive() + " to " + driveMap.getRemotePath() + " ...");
                }
                if ((sts = Win32Utils.DeleteNetworkDrive(driveMap.getLocalDrive(), false, true)) == 0) continue;
                Debug.println("Failed to delete mapped drive " + driveMap.getLocalDrive() + " from " + driveMap.getRemotePath() + ", status = " + SMBErrorText.ErrorString(8, sts));
            }
        }
    }
}

