/*
 * Decompiled with CFR 0.152.
 */
package nu.zoom.catonine.tail;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import nu.zoom.catonine.tail.Tailer;
import nu.zoom.catonine.tail.TailerListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractExecutorTailer
implements Tailer {
    private final Log log = LogFactory.getLog(this.getClass());
    private final ArrayList<TailerListener> listeners = new ArrayList();
    protected final ExecutorService executor = Executors.newCachedThreadPool();

    @Override
    public synchronized void addListener(TailerListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public synchronized void removeListener(TailerListener listener) {
        this.listeners.remove(listener);
    }

    private synchronized List<TailerListener> copyListenerList() {
        ArrayList<TailerListener> copy = new ArrayList<TailerListener>(this.listeners);
        return Collections.unmodifiableList(copy);
    }

    protected void fireLinesRead(List<TailerListener.LogEntry> lines) {
        this.log.trace((Object)"Informing listeners that we have read new lines");
        List<TailerListener.LogEntry> readonlyList = Collections.unmodifiableList(lines);
        List<TailerListener> listeners = this.copyListenerList();
        TailerListener.TailerLinesEvent event = new TailerListener.TailerLinesEvent();
        event.source = this;
        event.entries = readonlyList;
        for (TailerListener listener : listeners) {
            listener.lines(event);
        }
    }

    protected void fireWork(final boolean working) {
        this.log.trace((Object)("Informing listeners of work status: " + working));
        final List<TailerListener> listeners = this.copyListenerList();
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                for (TailerListener listener : listeners) {
                    if (working) {
                        listener.tailerWorking();
                        continue;
                    }
                    listener.tailerIdle();
                }
            }
        });
    }

    protected void fireStopped() {
        this.log.trace((Object)"Informing listeners that tailer has stopped");
        final List<TailerListener> listeners = this.copyListenerList();
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                for (TailerListener listener : listeners) {
                    listener.tailerStopped();
                }
            }
        });
    }

    protected void fireReset() {
        this.log.trace((Object)"Informing listeners that tailer has been reset");
        final List<TailerListener> listeners = this.copyListenerList();
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                for (TailerListener listener : listeners) {
                    listener.tailerHasBeenReset();
                }
            }
        });
    }
}

