/*
 * Decompiled with CFR 0.152.
 */
package nu.zoom.catonine.stylerule;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import nu.zoom.catonine.stylerule.ChangeTracker;
import nu.zoom.catonine.stylerule.StyleRules;
import nu.zoom.catonine.stylerule.StyleRulesManagerListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@XmlRootElement(name="StyleRulesCollection")
public class StyleRulesManager
implements Serializable,
ChangeTracker {
    private static final long serialVersionUID = 1L;
    private transient Log log = LogFactory.getLog(this.getClass());
    private transient boolean changed = false;
    private final ArrayList<StyleRulesManagerListener> listeners = new ArrayList();
    @XmlElement
    private ArrayList<StyleRules> styleRules = new ArrayList();

    public synchronized void add(StyleRules styleRulesToAdd) {
        if (styleRulesToAdd == null) {
            throw new NullPointerException("newRuleSet may not be null");
        }
        this.log.trace((Object)("Adding styleRules: " + styleRulesToAdd));
        this.styleRules.add(styleRulesToAdd);
        this.log.trace((Object)"Sorting style rules");
        Collections.sort(this.styleRules, new StyleRulesComparator());
        this.fireStructureChanged();
    }

    public synchronized void remove(StyleRules styleRulesToRemove) {
        this.log.trace((Object)("Removing style rules: " + styleRulesToRemove));
        this.styleRules.remove(styleRulesToRemove);
        this.log.trace((Object)"Sorting style rules");
        Collections.sort(this.styleRules, new StyleRulesComparator());
        this.fireStructureChanged();
    }

    public synchronized List<StyleRules> getStyleRules() {
        return Collections.unmodifiableList(this.styleRules);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(StyleRulesManagerListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener may not be null");
        }
        ArrayList<StyleRulesManagerListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(StyleRulesManagerListener listener) {
        ArrayList<StyleRulesManagerListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireStructureChanged() {
        this.changed = true;
        ArrayList<Thread> notifierThreads = new ArrayList<Thread>();
        ArrayList<StyleRulesManagerListener> arrayList = this.listeners;
        synchronized (arrayList) {
            this.log.debug((Object)("Notifying: " + this.listeners.size() + " listeners that structure has changed"));
            for (final StyleRulesManagerListener listener : this.listeners) {
                notifierThreads.add(new Thread(new Runnable(){

                    @Override
                    public void run() {
                        listener.styleRulesChanged(StyleRulesManager.this);
                    }
                }));
            }
        }
        for (Thread t : notifierThreads) {
            t.start();
        }
    }

    public void copyListenersTo(StyleRulesManager newManager) {
        newManager.listeners.addAll(this.listeners);
    }

    public void importManager(StyleRulesManager importFrom) {
        for (StyleRules importRules : importFrom.styleRules) {
            boolean shouldImport = true;
            for (StyleRules myRules : this.styleRules) {
                if (!myRules.getGuid().equals(importRules.getGuid())) continue;
                shouldImport = false;
                break;
            }
            if (!shouldImport) continue;
            this.add(importRules);
        }
    }

    @Override
    public synchronized boolean isChanged() {
        if (!this.changed) {
            for (StyleRules rules : this.styleRules) {
                if (!rules.isChanged()) continue;
                this.log.trace((Object)"Found a style rules that is changed, setting changed status");
                this.changed = true;
            }
        }
        return this.changed;
    }

    @Override
    public synchronized void resetChangeStatus() {
        this.changed = false;
        this.log.trace((Object)"Resetting changed status");
        for (StyleRules rules : this.styleRules) {
            rules.resetChangeStatus();
        }
    }

    public class StyleRulesComparator
    implements Comparator<StyleRules> {
        @Override
        public int compare(StyleRules rules1, StyleRules rules2) {
            if (rules1.getName() != null) {
                return rules1.getName().compareTo(rules2.getName());
            }
            return 1;
        }
    }
}

