/*
 * Decompiled with CFR 0.152.
 */
package nu.zoom.catonine.stylerule;

import java.awt.Color;
import java.awt.Font;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import nu.zoom.catonine.stylerule.ChangeTracker;
import nu.zoom.catonine.stylerule.StyleRuleListener;
import nu.zoom.catonine.xml.JAXBColorAdapter;
import nu.zoom.catonine.xml.JAXBFontAdapter;
import nu.zoom.catonine.xml.JAXBPatternAdapter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(propOrder={"guid", "supress", "fold", "foreground", "background", "pattern", "font"})
public class StyleRule
implements Serializable,
ChangeTracker {
    private static final long serialVersionUID = 1L;
    private transient Log log = LogFactory.getLog(this.getClass());
    private transient boolean changed = false;
    private transient boolean disabled;
    private transient ArrayList<StyleRuleListener> listeners = new ArrayList();
    private String guid = UUID.randomUUID().toString();
    private boolean supress;
    private boolean fold;
    @XmlJavaTypeAdapter(value=JAXBColorAdapter.class)
    private Color foreground;
    @XmlJavaTypeAdapter(value=JAXBColorAdapter.class)
    private Color background;
    @XmlJavaTypeAdapter(value=JAXBPatternAdapter.class)
    private Pattern pattern;
    @XmlJavaTypeAdapter(value=JAXBFontAdapter.class)
    private Font font;

    public synchronized Font getFont() {
        return this.font;
    }

    public synchronized Color getBackground() {
        return this.background;
    }

    public synchronized Color getForeground() {
        return this.foreground;
    }

    public synchronized Pattern getPattern() {
        return this.pattern;
    }

    public synchronized String getGuid() {
        return this.guid;
    }

    public synchronized boolean isSupress() {
        return this.supress;
    }

    public synchronized void setFont(Font font) {
        this.font = font;
        this.firePatternChanged();
    }

    public synchronized void setBackground(Color background) {
        this.background = background;
        this.firePatternChanged();
    }

    public synchronized void setDisabled(boolean disabled) {
        this.disabled = disabled;
        this.firePatternChanged();
    }

    public synchronized void setForeground(Color foreground) {
        this.foreground = foreground;
        this.firePatternChanged();
    }

    public synchronized void setPattern(String pattern) {
        this.pattern = Pattern.compile(pattern, 32);
        this.firePatternChanged();
    }

    public synchronized void setSupress(boolean supress) {
        this.supress = supress;
        this.firePatternChanged();
    }

    public void setFold(boolean fold) {
        this.fold = fold;
        this.firePatternChanged();
    }

    public boolean isFold() {
        return this.fold;
    }

    public synchronized boolean isDisabled() {
        return this.disabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(StyleRuleListener listener) {
        this.log.trace((Object)("Adding listener:" + listener));
        ArrayList<StyleRuleListener> arrayList = this.getListeners();
        synchronized (arrayList) {
            this.getListeners().add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(StyleRuleListener listener) {
        this.log.trace((Object)("Remove listener:" + listener));
        ArrayList<StyleRuleListener> arrayList = this.getListeners();
        synchronized (arrayList) {
            this.getListeners().remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePatternChanged() {
        this.log.trace((Object)"Notifying listeners that pattern has changed");
        this.changed = true;
        ArrayList<Thread> notifierThreads = new ArrayList<Thread>();
        ArrayList<StyleRuleListener> arrayList = this.getListeners();
        synchronized (arrayList) {
            for (final StyleRuleListener listener : this.getListeners()) {
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        listener.patternChanged(StyleRule.this);
                    }
                });
                notifierThreads.add(t);
            }
        }
        for (Thread t : notifierThreads) {
            t.start();
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof StyleRule) {
            return this.guid.equals(((StyleRule)obj).guid);
        }
        return false;
    }

    public int hashCode() {
        int hash = 5;
        hash = 97 * hash + (this.guid != null ? this.guid.hashCode() : 0);
        return hash;
    }

    public String toString() {
        return this.pattern == null ? "<no pattern>" : this.pattern.toString();
    }

    @Override
    public boolean isChanged() {
        return this.changed;
    }

    @Override
    public void resetChangeStatus() {
        this.changed = false;
    }

    private ArrayList<StyleRuleListener> getListeners() {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        return this.listeners;
    }
}

