/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.types.internal.infer;

import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.pmd.lang.java.types.JArrayType;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;

class MethodResolutionPhase
extends Enum<MethodResolutionPhase> {
    public static final /* enum */ MethodResolutionPhase STRICT = new MethodResolutionPhase();
    public static final /* enum */ MethodResolutionPhase LOOSE = new MethodResolutionPhase();
    public static final /* enum */ MethodResolutionPhase VARARGS = new MethodResolutionPhase(){

        @Override
        public JTypeMirror ithFormal(List<JTypeMirror> formals, int i) {
            assert (i >= 0);
            if (i >= formals.size() - 1) {
                JTypeMirror lastFormal = formals.get(formals.size() - 1);
                return ((JArrayType)lastFormal).getComponentType();
            }
            return formals.get(i);
        }
    };
    public static final /* enum */ MethodResolutionPhase INVOC_STRICT = new MethodResolutionPhase();
    public static final /* enum */ MethodResolutionPhase INVOC_LOOSE = new MethodResolutionPhase();
    public static final /* enum */ MethodResolutionPhase INVOC_VARARGS = new MethodResolutionPhase(){

        @Override
        public JTypeMirror ithFormal(List<JTypeMirror> formals, int i) {
            return VARARGS.ithFormal(formals, i);
        }
    };
    static final Set<MethodResolutionPhase> APPLICABILITY_TESTS;
    private static final /* synthetic */ MethodResolutionPhase[] $VALUES;

    public static MethodResolutionPhase[] values() {
        return (MethodResolutionPhase[])$VALUES.clone();
    }

    public static MethodResolutionPhase valueOf(String name) {
        return Enum.valueOf(MethodResolutionPhase.class, name);
    }

    public JTypeMirror ithFormal(List<JTypeMirror> formals, int i) {
        assert (i >= 0 && i < formals.size());
        return formals.get(i);
    }

    MethodResolutionPhase asInvoc() {
        switch (this) {
            case STRICT: {
                return INVOC_STRICT;
            }
            case LOOSE: {
                return INVOC_LOOSE;
            }
            case VARARGS: {
                return INVOC_VARARGS;
            }
        }
        return this;
    }

    boolean requiresVarargs() {
        return this == INVOC_VARARGS || this == VARARGS;
    }

    boolean canBox() {
        return this != STRICT;
    }

    boolean isInvocation() {
        return this == INVOC_STRICT || this == INVOC_LOOSE || this == INVOC_VARARGS;
    }

    static {
        $VALUES = new MethodResolutionPhase[]{STRICT, LOOSE, VARARGS, INVOC_STRICT, INVOC_LOOSE, INVOC_VARARGS};
        APPLICABILITY_TESTS = EnumSet.of(STRICT, LOOSE, VARARGS);
    }
}

