/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.design;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameter;
import net.sourceforge.pmd.lang.java.ast.ASTImportDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTPackageDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTType;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.ast.Annotatable;
import net.sourceforge.pmd.lang.java.ast.JModifier;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.java.types.JArrayType;
import net.sourceforge.pmd.lang.java.types.JPrimitiveType;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;
import net.sourceforge.pmd.util.StringUtil;
import org.apache.commons.lang3.StringUtils;

public class InvalidJavaBeanRule
extends AbstractJavaRulechainRule {
    private static final String LOMBOK_PACKAGE = "lombok";
    private static final String LOMBOK_DATA = "Data";
    private static final String LOMBOK_GETTER = "Getter";
    private static final String LOMBOK_SETTER = "Setter";
    private static final PropertyDescriptor<Boolean> ENSURE_SERIALIZATION = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"ensureSerialization").desc("Require that beans implement java.io.Serializable.")).defaultValue((Object)false)).build();
    private static final PropertyDescriptor<List<String>> PACKAGES_DESCRIPTOR = ((PropertyBuilder.GenericCollectionPropertyBuilder)PropertyFactory.stringListProperty((String)"packages").desc("Consider classes in only these package to be beans. Set to an empty value to check all classes.")).defaultValues((Object)"org.example.beans", (Object[])new String[0]).build();
    private Map<String, PropertyInfo> properties;

    public InvalidJavaBeanRule() {
        super(ASTClassOrInterfaceDeclaration.class, new Class[0]);
        this.definePropertyDescriptor(ENSURE_SERIALIZATION);
        this.definePropertyDescriptor(PACKAGES_DESCRIPTOR);
    }

    @Override
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        List packages;
        String packageName = "";
        ASTPackageDeclaration packageDeclaration = node.getRoot().getPackageDeclaration();
        if (packageDeclaration != null) {
            packageName = packageDeclaration.getName();
        }
        if (!(packages = (List)this.getProperty(PACKAGES_DESCRIPTOR)).isEmpty() && !packages.contains(packageName)) {
            return null;
        }
        String beanName = node.getSimpleName();
        if (((Boolean)this.getProperty(ENSURE_SERIALIZATION)).booleanValue() && !TypeTestUtil.isA(Serializable.class, (TypeNode)node)) {
            this.asCtx(data).addViolationWithMessage((Node)node, "The bean ''{0}'' does not implement java.io.Serializable.", new Object[]{beanName});
        }
        if (!this.hasNoArgConstructor(node)) {
            this.asCtx(data).addViolationWithMessage((Node)node, "The bean ''{0}'' is missing a no-arg constructor.", new Object[]{beanName});
        }
        if (InvalidJavaBeanRule.hasLombokDataAnnotation(node)) {
            return null;
        }
        this.properties = new HashMap<String, PropertyInfo>();
        this.collectFields(node);
        this.collectMethods(node);
        for (PropertyInfo propertyInfo : this.properties.values()) {
            if (!InvalidJavaBeanRule.hasLombokGetterAnnotation(node) && !InvalidJavaBeanRule.hasLombokSetterAnnotation(node) && propertyInfo.hasMissingGetter() && propertyInfo.hasMissingSetter()) {
                this.asCtx(data).addViolationWithMessage((Node)propertyInfo.getDeclaratorId(), "The bean ''{0}'' is missing a getter and a setter for property ''{1}''.", new Object[]{beanName, propertyInfo.getName()});
            } else if (!InvalidJavaBeanRule.hasLombokGetterAnnotation(node) && propertyInfo.hasMissingGetter()) {
                this.asCtx(data).addViolationWithMessage((Node)propertyInfo.getDeclaratorId(), "The bean ''{0}'' is missing a getter for property ''{1}''.", new Object[]{beanName, propertyInfo.getName()});
            } else if (!InvalidJavaBeanRule.hasLombokSetterAnnotation(node) && propertyInfo.hasMissingSetter()) {
                this.asCtx(data).addViolationWithMessage((Node)propertyInfo.getDeclaratorId(), "The bean ''{0}'' is missing a setter for property ''{1}''.", new Object[]{beanName, propertyInfo.getName()});
            }
            if (propertyInfo.hasWrongGetterType()) {
                this.asCtx(data).addViolationWithMessage((Node)propertyInfo.getGetter(), "The bean ''{0}'' should return a ''{1}'' in getter of property ''{2}''.", new Object[]{beanName, propertyInfo.getTypeName(), propertyInfo.getName()});
            }
            if (propertyInfo.hasWrongBooleanGetterName()) {
                this.asCtx(data).addViolationWithMessage((Node)propertyInfo.getGetter(), "The bean ''{0}'' should use the method name ''is{1}'' for the getter of property ''{2}''.", new Object[]{beanName, propertyInfo.getName(), propertyInfo.getName()});
            }
            if (propertyInfo.hasWrongTypeGetterAndSetter()) {
                this.asCtx(data).addViolationWithMessage((Node)propertyInfo.getGetter(), "The bean ''{0}'' has a property ''{1}'' with getter and setter that don''t have the same type.", new Object[]{beanName, propertyInfo.getName()});
            }
            if (propertyInfo.hasWrongIndexedGetterType()) {
                this.asCtx(data).addViolationWithMessage((Node)propertyInfo.indexedGetter, "The bean ''{0}'' has a property ''{1}'' with an indexed getter using the wrong type.", new Object[]{beanName, propertyInfo.getName()});
            }
            if (!propertyInfo.hasWrongIndexedSetterType()) continue;
            this.asCtx(data).addViolationWithMessage((Node)propertyInfo.indexedSetter, "The bean ''{0}'' has a property ''{1}'' with an indexed setter using the wrong type.", new Object[]{beanName, propertyInfo.getName()});
        }
        return null;
    }

    private void collectFields(ASTClassOrInterfaceDeclaration node) {
        for (ASTFieldDeclaration fieldDeclaration : node.getDeclarations(ASTFieldDeclaration.class).toList()) {
            for (ASTVariableDeclaratorId variableDeclaratorId : fieldDeclaration) {
                String propertyName = StringUtils.capitalize((String)variableDeclaratorId.getName());
                if (fieldDeclaration.hasModifiers(JModifier.STATIC, new JModifier[0]) || fieldDeclaration.hasModifiers(JModifier.TRANSIENT, new JModifier[0])) continue;
                PropertyInfo field = this.getOrCreatePropertyInfo(propertyName);
                field.setDeclaratorId(variableDeclaratorId);
                field.setReadonly(fieldDeclaration.hasModifiers(JModifier.FINAL, new JModifier[0]));
            }
        }
    }

    private PropertyInfo getOrCreatePropertyInfo(String propertyName) {
        PropertyInfo propertyInfo = this.properties.get(propertyName);
        if (propertyInfo == null) {
            propertyInfo = new PropertyInfo(propertyName);
            this.properties.put(propertyName, propertyInfo);
        }
        return propertyInfo;
    }

    private void collectMethods(ASTClassOrInterfaceDeclaration node) {
        for (ASTMethodDeclaration methodDeclaration : node.getDeclarations(ASTMethodDeclaration.class).toList()) {
            PropertyInfo propertyInfo;
            String methodName = methodDeclaration.getName();
            int parameterCount = methodDeclaration.getArity();
            String propertyName = StringUtil.withoutPrefixes((String)methodName, (String[])new String[]{"get", "set", "is"});
            if (methodName.startsWith("get") || methodName.startsWith("is")) {
                if (parameterCount == 0) {
                    propertyInfo = this.getOrCreatePropertyInfo(propertyName);
                    propertyInfo.setGetter(methodDeclaration);
                    continue;
                }
                if (parameterCount != 1 || !InvalidJavaBeanRule.getFirstParameterType(methodDeclaration).isPrimitive(JPrimitiveType.PrimitiveTypeKind.INT)) continue;
                propertyInfo = this.getOrCreatePropertyInfo(propertyName);
                propertyInfo.setIndexedGetter(methodDeclaration);
                continue;
            }
            if (!methodName.startsWith("set")) continue;
            if (parameterCount == 1) {
                propertyInfo = this.getOrCreatePropertyInfo(propertyName);
                propertyInfo.setSetter(methodDeclaration);
                continue;
            }
            if (parameterCount != 2 || !InvalidJavaBeanRule.getFirstParameterType(methodDeclaration).isPrimitive(JPrimitiveType.PrimitiveTypeKind.INT)) continue;
            propertyInfo = this.getOrCreatePropertyInfo(propertyName);
            propertyInfo.setIndexedSetter(methodDeclaration);
        }
    }

    private static JTypeMirror getFirstParameterType(ASTMethodDeclaration declaration) {
        return InvalidJavaBeanRule.getParameterType(declaration, 0);
    }

    private static JTypeMirror getParameterType(ASTMethodDeclaration declaration, int i) {
        if (declaration.getArity() >= i + 1) {
            ASTFormalParameter firstParameter = (ASTFormalParameter)declaration.getFormalParameters().children(ASTFormalParameter.class).get(i);
            return firstParameter.getTypeMirror();
        }
        return null;
    }

    private static JTypeMirror getResultType(ASTMethodDeclaration declaration) {
        ASTType resultType = declaration.getResultTypeNode();
        return resultType.getTypeMirror();
    }

    private boolean hasNoArgConstructor(ASTClassOrInterfaceDeclaration node) {
        int constructorCount = 0;
        for (ASTConstructorDeclaration ctor : node.getDeclarations(ASTConstructorDeclaration.class)) {
            if (ctor.getArity() == 0) {
                return true;
            }
            ++constructorCount;
        }
        return constructorCount == 0;
    }

    private static boolean hasLombokImport(Annotatable node) {
        return node.getRoot().descendants(ASTImportDeclaration.class).filter(ASTImportDeclaration::isImportOnDemand).filterNot(ASTImportDeclaration::isStatic).any(i -> LOMBOK_PACKAGE.equals(i.getImportedName()));
    }

    private static boolean hasLombokDataAnnotation(Annotatable node) {
        return node.isAnnotationPresent("lombok.Data") || InvalidJavaBeanRule.hasLombokImport(node) && node.isAnnotationPresent(LOMBOK_DATA);
    }

    private static boolean hasLombokGetterAnnotation(Annotatable node) {
        return node.isAnnotationPresent("lombok.Getter") || InvalidJavaBeanRule.hasLombokImport(node) && node.isAnnotationPresent(LOMBOK_GETTER);
    }

    private static boolean hasLombokSetterAnnotation(Annotatable node) {
        return node.isAnnotationPresent("lombok.Setter") || InvalidJavaBeanRule.hasLombokImport(node) && node.isAnnotationPresent(LOMBOK_SETTER);
    }

    private static class PropertyInfo {
        private final String name;
        private ASTVariableDeclaratorId declaratorId;
        private boolean readonly;
        private ASTMethodDeclaration getter;
        private ASTMethodDeclaration indexedGetter;
        private ASTMethodDeclaration setter;
        private ASTMethodDeclaration indexedSetter;

        PropertyInfo(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public ASTVariableDeclaratorId getDeclaratorId() {
            return this.declaratorId;
        }

        public void setDeclaratorId(ASTVariableDeclaratorId declaratorId) {
            this.declaratorId = declaratorId;
        }

        public boolean isReadonly() {
            return this.readonly;
        }

        public void setReadonly(boolean readonly) {
            this.readonly = readonly;
        }

        public ASTMethodDeclaration getGetter() {
            return this.getter;
        }

        public void setGetter(ASTMethodDeclaration getter) {
            this.getter = getter;
        }

        public ASTMethodDeclaration getIndexedGetter() {
            return this.indexedGetter;
        }

        public void setIndexedGetter(ASTMethodDeclaration indexedGetter) {
            this.indexedGetter = indexedGetter;
        }

        public ASTMethodDeclaration getSetter() {
            return this.setter;
        }

        public void setSetter(ASTMethodDeclaration setter) {
            this.setter = setter;
        }

        public ASTMethodDeclaration getIndexedSetter() {
            return this.indexedSetter;
        }

        public void setIndexedSetter(ASTMethodDeclaration indexedSetter) {
            this.indexedSetter = indexedSetter;
        }

        private boolean hasMissingGetter() {
            return this.declaratorId != null && this.getter == null && !this.hasFieldLombokGetter();
        }

        private boolean hasMissingSetter() {
            return this.declaratorId != null && !this.readonly && this.setter == null && !this.hasFieldLombokSetter();
        }

        private String getTypeName() {
            JTypeMirror type = null;
            if (this.declaratorId != null) {
                type = this.declaratorId.getTypeMirror();
            } else if (this.getter != null) {
                type = InvalidJavaBeanRule.getResultType(this.getter);
            } else if (this.setter != null) {
                type = InvalidJavaBeanRule.getFirstParameterType(this.setter);
            }
            if (type != null) {
                return type.toString();
            }
            return "<unknown type>";
        }

        private boolean hasWrongGetterType() {
            return this.declaratorId != null && this.getter != null && !this.getter.getResultTypeNode().isVoid() && !this.declaratorId.getTypeMirror().equals(InvalidJavaBeanRule.getResultType(this.getter));
        }

        private boolean hasWrongBooleanGetterName() {
            if (this.getter != null && (TypeTestUtil.isA(Boolean.class, (TypeNode)this.declaratorId) || TypeTestUtil.isA(Boolean.TYPE, (TypeNode)this.declaratorId))) {
                return !this.getter.getName().startsWith("is");
            }
            return false;
        }

        private boolean hasWrongTypeGetterAndSetter() {
            if (this.declaratorId != null || this.getter == null || this.setter == null) {
                return false;
            }
            JTypeMirror parameterType = InvalidJavaBeanRule.getFirstParameterType(this.setter);
            return this.getter.getResultTypeNode().isVoid() || !InvalidJavaBeanRule.getResultType(this.getter).equals(parameterType);
        }

        private boolean hasWrongIndexedGetterType() {
            JTypeMirror getterType;
            if (this.getter == null || this.indexedGetter == null) {
                return false;
            }
            JTypeMirror propertyType = InvalidJavaBeanRule.getResultType(this.getter);
            if (propertyType != null && propertyType.isArray()) {
                propertyType = ((JArrayType)propertyType).getComponentType();
            }
            return !propertyType.equals(getterType = InvalidJavaBeanRule.getResultType(this.indexedGetter));
        }

        private boolean hasWrongIndexedSetterType() {
            JTypeMirror setterType;
            if (this.setter == null || this.indexedSetter == null) {
                return false;
            }
            JTypeMirror propertyType = InvalidJavaBeanRule.getFirstParameterType(this.setter);
            if (propertyType != null && propertyType.isArray()) {
                propertyType = ((JArrayType)propertyType).getComponentType();
            }
            return !propertyType.equals(setterType = InvalidJavaBeanRule.getParameterType(this.indexedSetter, 1));
        }

        private boolean hasFieldLombokGetter() {
            ASTFieldDeclaration fieldDeclaration = this.declaratorId != null ? (ASTFieldDeclaration)this.declaratorId.ancestors(ASTFieldDeclaration.class).first() : null;
            return fieldDeclaration != null && InvalidJavaBeanRule.hasLombokGetterAnnotation(fieldDeclaration);
        }

        private boolean hasFieldLombokSetter() {
            ASTFieldDeclaration fieldDeclaration = this.declaratorId != null ? (ASTFieldDeclaration)this.declaratorId.ancestors(ASTFieldDeclaration.class).first() : null;
            return fieldDeclaration != null && InvalidJavaBeanRule.hasLombokSetterAnnotation(fieldDeclaration);
        }
    }
}

