/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.bestpractices;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTArgumentList;
import net.sourceforge.pmd.lang.java.ast.ASTBooleanLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceType;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorCall;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTMethodCall;
import net.sourceforge.pmd.lang.java.ast.ASTStringLiteral;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.java.types.InvocationMatcher;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;

public class PrimitiveWrapperInstantiationRule
extends AbstractJavaRulechainRule {
    private static final InvocationMatcher BOOLEAN_VALUEOF_MATCHER = InvocationMatcher.parse("java.lang.Boolean#valueOf(_)");

    public PrimitiveWrapperInstantiationRule() {
        super(ASTConstructorCall.class, ASTMethodCall.class);
    }

    @Override
    public Object visit(ASTConstructorCall node, Object data) {
        ASTClassOrInterfaceType type = (ASTClassOrInterfaceType)node.firstChild(ASTClassOrInterfaceType.class);
        if (type == null) {
            return data;
        }
        if (TypeTestUtil.isA(Double.class, (TypeNode)type) || TypeTestUtil.isA(Float.class, (TypeNode)type) || TypeTestUtil.isA(Long.class, (TypeNode)type) || TypeTestUtil.isA(Integer.class, (TypeNode)type) || TypeTestUtil.isA(Short.class, (TypeNode)type) || TypeTestUtil.isA(Byte.class, (TypeNode)type) || TypeTestUtil.isA(Character.class, (TypeNode)type)) {
            this.addViolation(data, (Node)node, type.getSimpleName());
        } else if (TypeTestUtil.isA(Boolean.class, (TypeNode)type)) {
            this.checkArguments(node.getArguments(), node, data);
        }
        return data;
    }

    @Override
    public Object visit(ASTMethodCall node, Object data) {
        if (BOOLEAN_VALUEOF_MATCHER.matchesCall(node)) {
            this.checkArguments(node.getArguments(), node, data);
        }
        return data;
    }

    private void checkArguments(ASTArgumentList arguments, JavaNode node, Object data) {
        if (arguments == null || arguments.size() != 1) {
            return;
        }
        boolean isNewBoolean = node instanceof ASTConstructorCall;
        String messagePart = isNewBoolean ? "Do not use `new Boolean" : "Do not use `Boolean.valueOf";
        ASTStringLiteral stringLiteral = PrimitiveWrapperInstantiationRule.getFirstArgStringLiteralOrNull(arguments);
        ASTBooleanLiteral boolLiteral = PrimitiveWrapperInstantiationRule.getFirstArgBooleanLiteralOrNull(arguments);
        if (stringLiteral != null) {
            if ("\"true\"".equals(stringLiteral.getImage())) {
                this.addViolationWithMessage(data, (Node)node, messagePart + "(\"true\")`, prefer `Boolean.TRUE`");
            } else if ("\"false\"".equals(stringLiteral.getImage())) {
                this.addViolationWithMessage(data, (Node)node, messagePart + "(\"false\")`, prefer `Boolean.FALSE`");
            } else {
                this.addViolationWithMessage(data, (Node)node, messagePart + "(\"...\")`, prefer `Boolean.valueOf`");
            }
        } else if (boolLiteral != null) {
            if (boolLiteral.isTrue()) {
                this.addViolationWithMessage(data, (Node)node, messagePart + "(true)`, prefer `Boolean.TRUE`");
            } else {
                this.addViolationWithMessage(data, (Node)node, messagePart + "(false)`, prefer `Boolean.FALSE`");
            }
        } else if (isNewBoolean) {
            this.addViolationWithMessage(data, (Node)node, messagePart + "(...)`, prefer `Boolean.valueOf`");
        }
    }

    private static ASTStringLiteral getFirstArgStringLiteralOrNull(ASTArgumentList arguments) {
        ASTExpression firstArg;
        if (arguments.size() == 1 && (firstArg = (ASTExpression)arguments.get(0)) instanceof ASTStringLiteral) {
            return (ASTStringLiteral)firstArg;
        }
        return null;
    }

    private static ASTBooleanLiteral getFirstArgBooleanLiteralOrNull(ASTArgumentList arguments) {
        ASTExpression firstArg;
        if (arguments.size() == 1 && (firstArg = (ASTExpression)arguments.get(0)) instanceof ASTBooleanLiteral) {
            return (ASTBooleanLiteral)firstArg;
        }
        return null;
    }
}

