/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.ast;

import java.util.Collections;
import java.util.List;
import net.sourceforge.pmd.annotation.InternalApi;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.xpath.internal.DeprecatedAttribute;
import net.sourceforge.pmd.lang.java.ast.ASTCatchStatement;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTForStatement;
import net.sourceforge.pmd.lang.java.ast.ASTFormalParameter;
import net.sourceforge.pmd.lang.java.ast.ASTLambdaExpression;
import net.sourceforge.pmd.lang.java.ast.ASTLocalVariableDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTPattern;
import net.sourceforge.pmd.lang.java.ast.ASTRecordComponent;
import net.sourceforge.pmd.lang.java.ast.ASTResource;
import net.sourceforge.pmd.lang.java.ast.ASTType;
import net.sourceforge.pmd.lang.java.ast.ASTTypePattern;
import net.sourceforge.pmd.lang.java.ast.AbstractJavaTypeNode;
import net.sourceforge.pmd.lang.java.ast.Dimensionable;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.JavaParser;
import net.sourceforge.pmd.lang.java.ast.JavaParserVisitor;
import net.sourceforge.pmd.lang.java.symboltable.VariableNameDeclaration;
import net.sourceforge.pmd.lang.symboltable.NameOccurrence;

public class ASTVariableDeclaratorId
extends AbstractJavaTypeNode
implements Dimensionable {
    private int arrayDepth;
    private VariableNameDeclaration nameDeclaration;
    private boolean explicitReceiverParameter = false;

    @Deprecated
    @InternalApi
    public ASTVariableDeclaratorId(int id) {
        super(id);
    }

    @Deprecated
    @InternalApi
    public ASTVariableDeclaratorId(JavaParser p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(JavaParserVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public VariableNameDeclaration getNameDeclaration() {
        return this.nameDeclaration;
    }

    @Deprecated
    @InternalApi
    public void setNameDeclaration(VariableNameDeclaration decl) {
        this.nameDeclaration = decl;
    }

    public List<NameOccurrence> getUsages() {
        List usages = (List)this.getScope().getDeclarations(VariableNameDeclaration.class).get(this.nameDeclaration);
        return usages == null ? Collections.emptyList() : usages;
    }

    @Deprecated
    public void bumpArrayDepth() {
        ++this.arrayDepth;
    }

    @Override
    @Deprecated
    public int getArrayDepth() {
        return this.arrayDepth;
    }

    @Override
    @Deprecated
    @DeprecatedAttribute(replaceWith="@ArrayType")
    public boolean isArray() {
        return this.arrayDepth > 0;
    }

    @DeprecatedAttribute(replaceWith="@Name")
    @Deprecated
    public String getImage() {
        return this.getName();
    }

    public String getName() {
        return super.getImage();
    }

    public boolean hasArrayType() {
        return this.arrayDepth > 0 || !this.isTypeInferred() && this.getTypeNode().isArrayType();
    }

    public boolean isExceptionBlockParameter() {
        return ((JavaNode)this.getParent()).getParent() instanceof ASTCatchStatement;
    }

    public boolean isFormalParameter() {
        return this.getParent() instanceof ASTFormalParameter && !this.isExceptionBlockParameter() && !this.isResourceDeclaration() || this.isLambdaParamWithNoType();
    }

    public boolean isLocalVariable() {
        return this.getNthParent(2) instanceof ASTLocalVariableDeclaration;
    }

    public boolean isForeachVariable() {
        return this.getNthParent(3) instanceof ASTForStatement;
    }

    public boolean isLambdaParameter() {
        return this.isLambdaParamWithNoType() || this.getParent() instanceof ASTFormalParameter && this.getNthParent(3) instanceof ASTLambdaExpression;
    }

    private boolean isLambdaParamWithNoType() {
        return this.getParent() instanceof ASTLambdaExpression;
    }

    public boolean isField() {
        return this.getNthParent(2) instanceof ASTFieldDeclaration;
    }

    @Deprecated
    @DeprecatedAttribute(replaceWith="@Name")
    public String getVariableName() {
        return this.getName();
    }

    public boolean isFinal() {
        if (this.isResourceDeclaration()) {
            return true;
        }
        if (this.isLambdaParamWithNoType()) {
            return false;
        }
        if (this.getParent() instanceof ASTTypePattern) {
            return ((ASTTypePattern)this.getParent()).isFinal();
        }
        if (this.getParent() instanceof ASTRecordComponent) {
            return true;
        }
        if (this.getParent() instanceof ASTFormalParameter) {
            return ((ASTFormalParameter)this.getParent()).isFinal();
        }
        Node grandpa = this.getNthParent(2);
        if (grandpa instanceof ASTLocalVariableDeclaration) {
            return ((ASTLocalVariableDeclaration)grandpa).isFinal();
        }
        if (grandpa instanceof ASTFieldDeclaration) {
            return ((ASTFieldDeclaration)grandpa).isFinal();
        }
        throw new IllegalStateException("All cases should be handled");
    }

    @Deprecated
    @InternalApi
    public void setExplicitReceiverParameter() {
        this.explicitReceiverParameter = true;
    }

    public boolean isExplicitReceiverParameter() {
        return this.explicitReceiverParameter;
    }

    public boolean isResourceDeclaration() {
        return this.getParent() instanceof ASTResource;
    }

    public boolean isTypeInferred() {
        return this.isLambdaParamWithNoType() || this.isLocalVariableTypeInferred() || this.isLambdaTypeInferred();
    }

    public boolean isPatternBinding() {
        return this.getParent() instanceof ASTPattern;
    }

    private boolean isLocalVariableTypeInferred() {
        if (this.isResourceDeclaration()) {
            return ((JavaNode)this.getParent()).getFirstChildOfType(ASTType.class) == null;
        }
        if (this.getNthParent(2) instanceof ASTLocalVariableDeclaration) {
            return this.getNthParent(2).getFirstChildOfType(ASTType.class) == null;
        }
        return false;
    }

    private boolean isLambdaTypeInferred() {
        return this.getNthParent(3) instanceof ASTLambdaExpression && ((JavaNode)this.getParent()).getFirstChildOfType(ASTType.class) == null;
    }

    public Node getTypeNameNode() {
        ASTType type = this.getTypeNode();
        return type == null ? null : (JavaNode)this.getTypeNode().getChild(0);
    }

    public ASTType getTypeNode() {
        if (this.getParent() instanceof ASTFormalParameter) {
            return ((ASTFormalParameter)this.getParent()).getTypeNode();
        }
        if (this.isTypeInferred()) {
            return null;
        }
        if (this.getParent() instanceof ASTTypePattern) {
            return ((ASTTypePattern)this.getParent()).getTypeNode();
        }
        if (this.getParent() instanceof ASTRecordComponent) {
            return ((ASTRecordComponent)this.getParent()).getTypeNode();
        }
        JavaNode n = ((JavaNode)this.getParent()).getParent();
        if (n instanceof ASTLocalVariableDeclaration || n instanceof ASTFieldDeclaration) {
            return (ASTType)n.getFirstChildOfType(ASTType.class);
        }
        return null;
    }

    @Override
    public Class<?> getType() {
        return super.getType();
    }
}

