/*
 * Decompiled with CFR 0.152.
 */
package net.sf.webdav.methods;

import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.webdav.ITransaction;
import net.sf.webdav.IWebdavStore;
import net.sf.webdav.StoredObject;
import net.sf.webdav.exceptions.AccessDeniedException;
import net.sf.webdav.exceptions.LockFailedException;
import net.sf.webdav.exceptions.WebdavException;
import net.sf.webdav.locking.IResourceLocks;
import net.sf.webdav.locking.LockedObject;
import net.sf.webdav.methods.AbstractMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DoPut
extends AbstractMethod {
    private static Logger LOG = LoggerFactory.getLogger(DoPut.class);
    private IWebdavStore _store;
    private IResourceLocks _resourceLocks;
    private boolean _readOnly;
    private boolean _lazyFolderCreationOnPut;
    private String _userAgent;

    public DoPut(IWebdavStore store, IResourceLocks resLocks, boolean readOnly, boolean lazyFolderCreationOnPut) {
        this._store = store;
        this._resourceLocks = resLocks;
        this._readOnly = readOnly;
        this._lazyFolderCreationOnPut = lazyFolderCreationOnPut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute(ITransaction transaction, HttpServletRequest req, HttpServletResponse resp) throws IOException, LockFailedException {
        LOG.trace("-- " + this.getClass().getName());
        if (!this._readOnly) {
            String path = this.getRelativePath(req);
            String parentPath = this.getParentPath(path);
            this._userAgent = req.getHeader("User-Agent");
            Hashtable<String, Integer> errorList = new Hashtable<String, Integer>();
            if (!this.checkLocks(transaction, req, resp, this._resourceLocks, parentPath)) {
                resp.setStatus(423);
                return;
            }
            if (!this.checkLocks(transaction, req, resp, this._resourceLocks, path)) {
                resp.setStatus(423);
                return;
            }
            String tempLockOwner = "doPut" + System.currentTimeMillis() + req.toString();
            if (this._resourceLocks.lock(transaction, path, tempLockOwner, false, 0, 10, true)) {
                StoredObject so = null;
                try {
                    StoredObject parentSo = this._store.getStoredObject(transaction, parentPath);
                    if (parentPath != null && parentSo != null && parentSo.isResource()) {
                        resp.sendError(403);
                        return;
                    }
                    if (parentPath != null && parentSo == null && this._lazyFolderCreationOnPut) {
                        this._store.createFolder(transaction, parentPath);
                    } else if (parentPath != null && parentSo == null && !this._lazyFolderCreationOnPut) {
                        errorList.put(parentPath, 404);
                        this.sendReport(req, resp, errorList);
                        return;
                    }
                    so = this._store.getStoredObject(transaction, path);
                    if (so == null) {
                        this._store.createResource(transaction, path);
                    } else if (so.isNullResource()) {
                        LockedObject nullResourceLo = this._resourceLocks.getLockedObjectByPath(transaction, path);
                        if (nullResourceLo == null) {
                            resp.sendError(500);
                            return;
                        }
                        String nullResourceLockToken = nullResourceLo.getID();
                        String[] lockTokens = this.getLockIdFromIfHeader(req);
                        String lockToken = null;
                        if (lockTokens == null) {
                            resp.sendError(400);
                            return;
                        }
                        lockToken = lockTokens[0];
                        if (lockToken.equals(nullResourceLockToken)) {
                            so.setNullResource(false);
                            so.setFolder(false);
                            String[] nullResourceLockOwners = nullResourceLo.getOwner();
                            String owner = null;
                            if (nullResourceLockOwners != null) {
                                owner = nullResourceLockOwners[0];
                            }
                            if (!this._resourceLocks.unlock(transaction, lockToken, owner)) {
                                resp.sendError(500);
                            }
                        } else {
                            errorList.put(path, 423);
                            this.sendReport(req, resp, errorList);
                        }
                    }
                    this.doUserAgentWorkaround(resp);
                    long resourceLength = this._store.setResourceContent(transaction, path, (InputStream)req.getInputStream(), null, null);
                    so = this._store.getStoredObject(transaction, path);
                    if (resourceLength == -1L) return;
                    so.setResourceLength(resourceLength);
                    return;
                }
                catch (AccessDeniedException e) {
                    resp.sendError(403);
                    return;
                }
                catch (WebdavException e) {
                    resp.sendError(500);
                    return;
                }
                finally {
                    this._resourceLocks.unlockTemporaryLockedObjects(transaction, path, tempLockOwner);
                }
            } else {
                resp.sendError(500);
            }
            return;
        } else {
            resp.sendError(403);
        }
    }

    private void doUserAgentWorkaround(HttpServletResponse resp) {
        if (this._userAgent != null && this._userAgent.indexOf("WebDAVFS") != -1 && this._userAgent.indexOf("Transmit") == -1) {
            LOG.trace("DoPut.execute() : do workaround for user agent '" + this._userAgent + "'");
            resp.setStatus(201);
        } else if (this._userAgent != null && this._userAgent.indexOf("Transmit") != -1) {
            LOG.trace("DoPut.execute() : do workaround for user agent '" + this._userAgent + "'");
            resp.setStatus(204);
        } else {
            resp.setStatus(201);
        }
    }
}

