/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.AbsolutePath;
import net.sf.saxon.om.CopyOptions;
import net.sf.saxon.om.FingerprintedNode;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.LocalNameTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NamespaceTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.NodeTestPattern;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.pattern.SameNameTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.AxisIteratorImpl;
import net.sf.saxon.tree.iter.AxisIteratorOverSequence;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.ReverseListIterator;
import net.sf.saxon.tree.iter.ReversibleIterator;
import net.sf.saxon.tree.iter.SingleNodeIterator;
import net.sf.saxon.tree.tiny.TinyNodeImpl;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.tree.util.NamespaceIterator;
import net.sf.saxon.tree.wrapper.SiblingCountingNode;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.UType;
import net.sf.saxon.type.Untyped;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Navigator {
    private static int[] nodeCategories = new int[]{-1, 3, 2, 3, -1, -1, -1, 3, 3, 0, -1, -1, -1, 1};

    private Navigator() {
    }

    public static String getAttributeValue(NodeInfo element, String uri, String localName) {
        return element.getAttributeValue(uri, localName);
    }

    public static StructuredQName getNodeName(NodeInfo node) {
        if (node.getLocalPart() != null) {
            return new StructuredQName(node.getPrefix(), node.getURI(), node.getLocalPart());
        }
        return null;
    }

    public static NodeInfo getOutermostElement(TreeInfo doc) {
        return doc.getRootNode().iterateAxis((byte)3, NodeKindTest.ELEMENT).next();
    }

    public static NodeTest makeNodeTest(NamePool pool, int nodeKind, String uri, String localName) {
        if (uri == null && localName == null) {
            return NodeKindTest.makeNodeKindTest(nodeKind);
        }
        if (uri == null) {
            return new LocalNameTest(pool, nodeKind, localName);
        }
        if (localName == null) {
            return new NamespaceTest(pool, nodeKind, uri);
        }
        int fp = pool.allocate("", uri, localName);
        return new NameTest(nodeKind, fp, pool);
    }

    public static String getBaseURI(NodeInfo node) {
        String xmlBase = node.getAttributeValue("http://www.w3.org/XML/1998/namespace", "base");
        if (xmlBase != null) {
            URI baseURI;
            try {
                baseURI = new URI(xmlBase);
                if (!baseURI.isAbsolute()) {
                    NodeInfo parent = node.getParent();
                    if (parent == null) {
                        URI base = new URI(node.getSystemId());
                        URI resolved = xmlBase.isEmpty() ? base : base.resolve(baseURI);
                        return resolved.toString();
                    }
                    String startSystemId = node.getSystemId();
                    if (startSystemId == null) {
                        return null;
                    }
                    String parentSystemId = parent.getSystemId();
                    URI base = new URI(startSystemId.equals(parentSystemId) ? parent.getBaseURI() : startSystemId);
                    baseURI = xmlBase.isEmpty() ? base : base.resolve(baseURI);
                }
            }
            catch (URISyntaxException e) {
                return xmlBase;
            }
            return baseURI.toString();
        }
        String startSystemId = node.getSystemId();
        if (startSystemId == null) {
            return null;
        }
        NodeInfo parent = node.getParent();
        if (parent == null) {
            return startSystemId;
        }
        String parentSystemId = parent.getSystemId();
        if (startSystemId.equals(parentSystemId) || parentSystemId.isEmpty()) {
            return parent.getBaseURI();
        }
        return startSystemId;
    }

    public static String getPath(NodeInfo node) {
        return Navigator.getPath(node, null);
    }

    public static String getPath(NodeInfo node, XPathContext context) {
        if (node == null) {
            return "";
        }
        NodeInfo parent = node.getParent();
        switch (node.getNodeKind()) {
            case 9: {
                return "/";
            }
            case 1: {
                if (parent == null) {
                    return node.getDisplayName();
                }
                String pre = Navigator.getPath(parent, context);
                if (pre.equals("/")) {
                    return '/' + node.getDisplayName();
                }
                try {
                    return pre + '/' + node.getDisplayName() + '[' + Navigator.getNumberSimple(node, context) + ']';
                }
                catch (UnsupportedOperationException e) {
                    return pre + '/' + node.getDisplayName();
                }
            }
            case 2: {
                return Navigator.getPath(parent, context) + "/@" + node.getDisplayName();
            }
            case 3: {
                String pre = Navigator.getPath(parent, context);
                try {
                    return (pre.equals("/") ? "" : pre) + "/text()[" + Navigator.getNumberSimple(node, context) + ']';
                }
                catch (UnsupportedOperationException e) {
                    return pre + "/text()";
                }
            }
            case 8: {
                String pre = Navigator.getPath(parent, context);
                try {
                    return (pre.equals("/") ? "" : pre) + "/comment()[" + Navigator.getNumberSimple(node, context) + ']';
                }
                catch (UnsupportedOperationException e) {
                    return pre + "/comment()";
                }
            }
            case 7: {
                String pre = Navigator.getPath(parent, context);
                try {
                    return (pre.equals("/") ? "" : pre) + "/processing-instruction()[" + Navigator.getNumberSimple(node, context) + ']';
                }
                catch (UnsupportedOperationException e) {
                    return pre + "/processing-instruction()";
                }
            }
            case 13: {
                String test = node.getLocalPart();
                if (test.isEmpty()) {
                    test = "*[not(local-name()]";
                }
                return Navigator.getPath(parent, context) + "/namespace::" + test;
            }
        }
        return "";
    }

    public static AbsolutePath getAbsolutePath(NodeInfo node) {
        LinkedList<AbsolutePath.PathElement> path = new LinkedList<AbsolutePath.PathElement>();
        String sysId = node.getSystemId();
        while (node != null && node.getNodeKind() != 9) {
            path.add(0, new AbsolutePath.PathElement(node.getNodeKind(), NameOfNode.makeName(node), Navigator.getNumberSimple(node, null)));
            node = node.getParent();
        }
        AbsolutePath a = new AbsolutePath(path);
        a.setSystemId(sysId);
        return a;
    }

    public static boolean haveSameName(NodeInfo n1, NodeInfo n2) {
        if (n1 instanceof FingerprintedNode && n2 instanceof FingerprintedNode) {
            return ((FingerprintedNode)n1).getFingerprint() == ((FingerprintedNode)n2).getFingerprint();
        }
        return n1.getLocalPart().equals(n2.getLocalPart()) && n1.getURI().equals(n2.getURI());
    }

    public static int getNumberSimple(NodeInfo node, XPathContext context) {
        NodeInfo prev;
        NodeTest same = node.getLocalPart().isEmpty() ? NodeKindTest.makeNodeKindTest(node.getNodeKind()) : new SameNameTest(node);
        Controller controller = context == null ? null : context.getController();
        AxisIterator preceding = node.iterateAxis((byte)11, same);
        int i = 1;
        while ((prev = preceding.next()) != null) {
            int memo;
            if (controller != null && (memo = controller.getRememberedNumber(prev)) > 0) {
                controller.setRememberedNumber(node, memo += i);
                return memo;
            }
            ++i;
        }
        if (controller != null) {
            controller.setRememberedNumber(node, i);
        }
        return i;
    }

    public static int getNumberSingle(NodeInfo node, Pattern count, Pattern from, XPathContext context) throws XPathException {
        NodeInfo target;
        block9: {
            if (count == null && from == null) {
                return Navigator.getNumberSimple(node, context);
            }
            boolean knownToMatch = false;
            if (count == null) {
                count = node.getLocalPart().isEmpty() ? new NodeTestPattern(NodeKindTest.makeNodeKindTest(node.getNodeKind())) : new NodeTestPattern(new SameNameTest(node));
                knownToMatch = true;
            }
            target = node;
            if (!knownToMatch) {
                do {
                    if (count.matches(target, context)) {
                        if (from != null) {
                            NodeInfo anc = target;
                            while (!from.matches(anc, context)) {
                                if ((anc = anc.getParent()) != null) continue;
                                return 0;
                            }
                        }
                        break block9;
                    }
                    if (from == null || !from.matches(target, context)) continue;
                    return 0;
                } while ((target = target.getParent()) != null);
                return 0;
            }
        }
        AxisIterator preceding = target.iterateAxis((byte)11, (NodeTest)count.getItemType());
        boolean alreadyChecked = count instanceof NodeTestPattern;
        int i = 1;
        NodeInfo p;
        while ((p = (NodeInfo)preceding.next()) != null) {
            if (!alreadyChecked && !count.matches(p, context)) continue;
            ++i;
        }
        return i;
    }

    public static int getNumberAny(Expression inst, NodeInfo node, Pattern count, Pattern from, XPathContext context, boolean hasVariablesInPatterns) throws XPathException {
        NodeInfo prev;
        Object[] memo;
        boolean memoise;
        NodeInfo memoNode = null;
        int memoNumber = 0;
        Controller controller = context.getController();
        assert (controller != null);
        boolean bl = memoise = !hasVariablesInPatterns && from == null;
        if (memoise && (memo = (Object[])controller.getUserData(inst.getLocation(), "xsl:number")) != null) {
            memoNode = (NodeInfo)memo[0];
            memoNumber = (Integer)memo[1];
        }
        int num = 0;
        if (count == null) {
            count = node.getLocalPart().isEmpty() ? new NodeTestPattern(NodeKindTest.makeNodeKindTest(node.getNodeKind())) : new NodeTestPattern(new SameNameTest(node));
            num = 1;
        } else if (count.matches(node, context)) {
            num = 1;
        }
        NodeTest filter = from == null ? (NodeTest)count.getItemType() : (from.getUType() == UType.ELEMENT && count.getUType() == UType.ELEMENT ? NodeKindTest.ELEMENT : AnyNodeTest.getInstance());
        if (from != null && from.matches(node, context)) {
            return num;
        }
        AxisIterator preceding = node.iterateAxis((byte)13, filter);
        while ((prev = (NodeInfo)preceding.next()) != null) {
            if (count.matches(prev, context)) {
                if (num == 1 && memoNode != null && prev.isSameNodeInfo(memoNode)) {
                    num = memoNumber + 1;
                    break;
                }
                ++num;
            }
            if (from == null || !from.matches(prev, context)) continue;
            break;
        }
        if (memoise) {
            Object[] memo2 = new Object[]{node, num};
            controller.setUserData(inst.getLocation(), "xsl:number", memo2);
        }
        return num;
    }

    public static List<Long> getNumberMulti(NodeInfo node, Pattern count, Pattern from, XPathContext context) throws XPathException {
        ArrayList<Long> v = new ArrayList<Long>(5);
        if (count == null) {
            count = node.getLocalPart().isEmpty() ? new NodeTestPattern(NodeKindTest.makeNodeKindTest(node.getNodeKind())) : new NodeTestPattern(new SameNameTest(node));
        }
        NodeInfo curr = node;
        do {
            if (!count.matches(curr, context)) continue;
            int num = Navigator.getNumberSingle(curr, count, null, context);
            v.add(0, Long.valueOf(num));
        } while ((from == null || !from.matches(curr, context)) && (curr = curr.getParent()) != null);
        return v;
    }

    public static void copy(NodeInfo node, Receiver out, int copyOptions, Location locationId) throws XPathException {
        switch (node.getNodeKind()) {
            case 9: {
                NodeInfo child;
                out.startDocument(CopyOptions.getStartDocumentProperties(copyOptions));
                AxisIterator children0 = node.iterateAxis((byte)3, AnyNodeTest.getInstance());
                while ((child = children0.next()) != null) {
                    child.copy(out, copyOptions, locationId);
                }
                out.endDocument();
                break;
            }
            case 1: {
                NodeInfo child;
                NodeInfo att;
                SchemaType annotation = (copyOptions & 4) != 0 ? node.getSchemaType() : Untyped.getInstance();
                out.startElement(NameOfNode.makeName(node), annotation, locationId, 0);
                if ((copyOptions & 1) != 0) {
                    NamespaceBinding[] localNamespaces;
                    for (NamespaceBinding ns : localNamespaces = node.getDeclaredNamespaces(null)) {
                        if (ns == null) break;
                        out.namespace(ns, 0);
                    }
                } else if ((copyOptions & 2) != 0) {
                    NamespaceIterator.sendNamespaces(node, out);
                }
                AxisIterator attributes = node.iterateAxis((byte)2, AnyNodeTest.getInstance());
                while ((att = attributes.next()) != null) {
                    att.copy(out, copyOptions, locationId);
                }
                out.startContent();
                AxisIterator children = node.iterateAxis((byte)3, AnyNodeTest.getInstance());
                int options = copyOptions;
                if ((options & 2) != 0) {
                    options = options & 0xFFFFFFFD | 1;
                }
                while ((child = children.next()) != null) {
                    child.copy(out, options, locationId);
                }
                out.endElement();
                return;
            }
            case 2: {
                BuiltInAtomicType annotation = (copyOptions & 4) != 0 ? (SimpleType)node.getSchemaType() : BuiltInAtomicType.UNTYPED_ATOMIC;
                out.attribute(NameOfNode.makeName(node), annotation, node.getStringValueCS(), locationId, 0);
                return;
            }
            case 3: {
                CharSequence value = node.getStringValueCS();
                if (value.length() != 0) {
                    out.characters(value, locationId, 0);
                }
                return;
            }
            case 8: {
                out.comment(node.getStringValueCS(), locationId, 0);
                return;
            }
            case 7: {
                out.processingInstruction(node.getLocalPart(), node.getStringValueCS(), locationId, 0);
                return;
            }
            case 13: {
                out.namespace(new NamespaceBinding(node.getLocalPart(), node.getStringValue()), 0);
                return;
            }
        }
    }

    public static int compareOrder(SiblingCountingNode first, SiblingCountingNode second) {
        NodeInfo p1;
        if (first.isSameNodeInfo(second)) {
            return 0;
        }
        NodeInfo firstParent = first.getParent();
        if (firstParent == null) {
            return -1;
        }
        NodeInfo secondParent = second.getParent();
        if (secondParent == null) {
            return 1;
        }
        if (firstParent.isSameNodeInfo(secondParent)) {
            int cat2;
            int cat1 = nodeCategories[first.getNodeKind()];
            if (cat1 == (cat2 = nodeCategories[second.getNodeKind()])) {
                return first.getSiblingPosition() - second.getSiblingPosition();
            }
            return cat1 - cat2;
        }
        int depth1 = 0;
        int depth2 = 0;
        NodeInfo p2 = second;
        for (p1 = first; p1 != null; p1 = p1.getParent()) {
            ++depth1;
        }
        while (p2 != null) {
            ++depth2;
            p2 = p2.getParent();
        }
        p1 = first;
        while (depth1 > depth2) {
            p1 = p1.getParent();
            assert (p1 != null);
            if (p1.isSameNodeInfo(second)) {
                return 1;
            }
            --depth1;
        }
        p2 = second;
        while (depth2 > depth1) {
            p2 = p2.getParent();
            assert (p2 != null);
            if (p2.isSameNodeInfo(first)) {
                return -1;
            }
            --depth2;
        }
        while (true) {
            NodeInfo par1 = p1.getParent();
            NodeInfo par2 = p2.getParent();
            if (par1 == null || par2 == null) {
                throw new NullPointerException("Node order comparison - internal error");
            }
            if (par1.isSameNodeInfo(par2)) {
                if (p1.getNodeKind() == 2 && p2.getNodeKind() != 2) {
                    return -1;
                }
                if (p1.getNodeKind() != 2 && p2.getNodeKind() == 2) {
                    return 1;
                }
                return ((SiblingCountingNode)p1).getSiblingPosition() - ((SiblingCountingNode)p2).getSiblingPosition();
            }
            p1 = par1;
            p2 = par2;
        }
    }

    public static int comparePosition(NodeInfo first, NodeInfo second) {
        NodeInfo p1;
        if (first.getNodeKind() == 2 || first.getNodeKind() == 13 || second.getNodeKind() == 2 || second.getNodeKind() == 13) {
            throw new UnsupportedOperationException();
        }
        if (first.isSameNodeInfo(second)) {
            return 12;
        }
        NodeInfo firstParent = first.getParent();
        if (firstParent == null) {
            return 0;
        }
        NodeInfo secondParent = second.getParent();
        if (secondParent == null) {
            return 4;
        }
        if (firstParent.isSameNodeInfo(secondParent)) {
            if (first.compareOrder(second) < 0) {
                return 10;
            }
            return 6;
        }
        int depth1 = 0;
        int depth2 = 0;
        NodeInfo p2 = second;
        for (p1 = first; p1 != null; p1 = p1.getParent()) {
            ++depth1;
        }
        while (p2 != null) {
            ++depth2;
            p2 = p2.getParent();
        }
        p1 = first;
        while (depth1 > depth2) {
            p1 = p1.getParent();
            assert (p1 != null);
            if (p1.isSameNodeInfo(second)) {
                return 4;
            }
            --depth1;
        }
        p2 = second;
        while (depth2 > depth1) {
            p2 = p2.getParent();
            assert (p2 != null);
            if (p2.isSameNodeInfo(first)) {
                return 0;
            }
            --depth2;
        }
        if (first.compareOrder(second) < 0) {
            return 10;
        }
        return 6;
    }

    public static void appendSequentialKey(SiblingCountingNode node, FastStringBuffer sb, boolean addDocNr) {
        if (addDocNr) {
            sb.append('w');
            sb.append(Long.toString(node.getTreeInfo().getDocumentNumber()));
        }
        if (node.getNodeKind() != 9) {
            NodeInfo parent = node.getParent();
            if (parent != null) {
                Navigator.appendSequentialKey((SiblingCountingNode)parent, sb, false);
            }
            if (node.getNodeKind() == 2) {
                sb.append('A');
            }
        }
        sb.append(Navigator.alphaKey(node.getSiblingPosition()));
    }

    public static String alphaKey(int value) {
        if (value < 1) {
            return "a";
        }
        if (value < 10) {
            return "b" + value;
        }
        if (value < 100) {
            return "c" + value;
        }
        if (value < 1000) {
            return "d" + value;
        }
        if (value < 10000) {
            return "e" + value;
        }
        if (value < 100000) {
            return "f" + value;
        }
        if (value < 1000000) {
            return "g" + value;
        }
        if (value < 10000000) {
            return "h" + value;
        }
        if (value < 100000000) {
            return "i" + value;
        }
        if (value < 1000000000) {
            return "j" + value;
        }
        return "k" + value;
    }

    public static boolean isAncestorOrSelf(NodeInfo a, NodeInfo d) {
        int k = a.getNodeKind();
        if (k != 1 && k != 9) {
            return a.isSameNodeInfo(d);
        }
        if (a instanceof TinyNodeImpl) {
            if (d instanceof TinyNodeImpl) {
                return ((TinyNodeImpl)a).isAncestorOrSelf((TinyNodeImpl)d);
            }
            if (d.getNodeKind() != 13) {
                return false;
            }
        }
        for (NodeInfo p = d; p != null; p = p.getParent()) {
            if (!a.isSameNodeInfo(p)) continue;
            return true;
        }
        return false;
    }

    public static AxisIterator filteredSingleton(NodeInfo node, NodeTest nodeTest) {
        if (node != null && nodeTest.matchesNode(node)) {
            return SingleNodeIterator.makeIterator(node);
        }
        return EmptyIterator.OfNodes.THE_INSTANCE;
    }

    public static int getSiblingPosition(NodeInfo node, NodeTest nodeTest, int max) throws XPathException {
        AxisIterator prev = node.iterateAxis((byte)11, nodeTest);
        int count = 1;
        while (prev.next() != null) {
            if (++count <= max) continue;
            return count;
        }
        return count;
    }

    public static final class PrecedingEnumeration
    extends AxisIteratorImpl {
        private NodeInfo start;
        private AxisIterator ancestorEnum;
        private AxisIterator siblingEnum = null;
        private AxisIterator descendEnum = null;
        private boolean includeAncestors;

        public PrecedingEnumeration(NodeInfo start, boolean includeAncestors) {
            this.start = start;
            this.includeAncestors = includeAncestors;
            this.ancestorEnum = new AncestorEnumeration(start, false);
            switch (start.getNodeKind()) {
                case 1: 
                case 3: 
                case 7: 
                case 8: {
                    this.siblingEnum = start.iterateAxis((byte)11);
                    break;
                }
                default: {
                    this.siblingEnum = EmptyIterator.OfNodes.THE_INSTANCE;
                }
            }
        }

        public final NodeInfo next() {
            NodeInfo nexta;
            if (this.descendEnum != null) {
                NodeInfo nextd = this.descendEnum.next();
                if (nextd != null) {
                    return nextd;
                }
                this.descendEnum = null;
            }
            if (this.siblingEnum != null) {
                NodeInfo nexts = this.siblingEnum.next();
                if (nexts != null) {
                    if (nexts.hasChildNodes()) {
                        this.descendEnum = new DescendantEnumeration(nexts, true, false);
                        return this.next();
                    }
                    this.descendEnum = null;
                    return nexts;
                }
                this.descendEnum = null;
                this.siblingEnum = null;
            }
            if ((nexta = this.ancestorEnum.next()) != null) {
                this.siblingEnum = nexta.getNodeKind() == 9 ? EmptyIterator.OfNodes.THE_INSTANCE : nexta.iterateAxis((byte)11);
                if (!this.includeAncestors) {
                    return this.next();
                }
                return nexta;
            }
            return null;
        }

        public AxisIterator getAnother() {
            return new PrecedingEnumeration(this.start, this.includeAncestors);
        }
    }

    public static final class FollowingEnumeration
    extends AxisIteratorImpl {
        private NodeInfo start;
        private AxisIterator ancestorEnum;
        private AxisIterator siblingEnum = null;
        private AxisIterator descendEnum = null;

        public FollowingEnumeration(NodeInfo start) {
            this.start = start;
            this.ancestorEnum = new AncestorEnumeration(start, false);
            switch (start.getNodeKind()) {
                case 1: 
                case 3: 
                case 7: 
                case 8: {
                    this.siblingEnum = start.iterateAxis((byte)7);
                    break;
                }
                case 2: 
                case 13: {
                    NodeInfo parent = start.getParent();
                    if (parent == null) {
                        this.siblingEnum = EmptyIterator.OfNodes.THE_INSTANCE;
                        break;
                    }
                    this.siblingEnum = parent.iterateAxis((byte)3);
                    break;
                }
                default: {
                    this.siblingEnum = EmptyIterator.OfNodes.THE_INSTANCE;
                }
            }
        }

        public final NodeInfo next() {
            NodeInfo nexta;
            if (this.descendEnum != null) {
                NodeInfo nextd = this.descendEnum.next();
                if (nextd != null) {
                    return nextd;
                }
                this.descendEnum = null;
            }
            if (this.siblingEnum != null) {
                NodeInfo nexts = this.siblingEnum.next();
                if (nexts != null) {
                    this.descendEnum = nexts.hasChildNodes() ? new DescendantEnumeration(nexts, false, true) : null;
                    return nexts;
                }
                this.descendEnum = null;
                this.siblingEnum = null;
            }
            if ((nexta = this.ancestorEnum.next()) != null) {
                this.siblingEnum = nexta.getNodeKind() == 9 ? EmptyIterator.OfNodes.THE_INSTANCE : nexta.iterateAxis((byte)7);
                return this.next();
            }
            return null;
        }

        public AxisIterator getAnother() {
            return new FollowingEnumeration(this.start);
        }
    }

    public static final class DescendantEnumeration
    extends AxisIteratorImpl {
        private AxisIterator children = null;
        private AxisIterator descendants = null;
        private NodeInfo start;
        private boolean includeSelf;
        private boolean forwards;
        private boolean atEnd = false;

        public DescendantEnumeration(NodeInfo start, boolean includeSelf, boolean forwards) {
            this.start = start;
            this.includeSelf = includeSelf;
            this.forwards = forwards;
        }

        public final NodeInfo next() {
            if (this.descendants != null) {
                NodeInfo nextd = this.descendants.next();
                if (nextd != null) {
                    return nextd;
                }
                this.descendants = null;
            }
            if (this.children != null) {
                NodeInfo n = this.children.next();
                if (n != null) {
                    if (n.hasChildNodes()) {
                        if (this.forwards) {
                            this.descendants = new DescendantEnumeration(n, false, this.forwards);
                            return n;
                        }
                        this.descendants = new DescendantEnumeration(n, true, this.forwards);
                        return this.next();
                    }
                    return n;
                }
                if (this.forwards || !this.includeSelf) {
                    return null;
                }
                this.atEnd = true;
                this.children = null;
                return this.start;
            }
            if (this.atEnd) {
                return null;
            }
            if (this.start.hasChildNodes()) {
                this.children = this.start.iterateAxis((byte)3);
                if (!this.forwards) {
                    if (this.children instanceof ReversibleIterator) {
                        this.children = (AxisIterator)((ReversibleIterator)((Object)this.children)).getReverseIterator();
                    } else {
                        NodeInfo n;
                        ArrayList<NodeInfo> list = new ArrayList<NodeInfo>(20);
                        AxisIterator forwards = this.start.iterateAxis((byte)3);
                        while ((n = forwards.next()) != null) {
                            list.add(n);
                        }
                        this.children = new AxisIteratorOverSequence(new ReverseListIterator(list));
                    }
                }
            } else {
                this.children = EmptyIterator.OfNodes.THE_INSTANCE;
            }
            if (this.forwards && this.includeSelf) {
                return this.start;
            }
            return this.next();
        }

        public void advance() {
        }

        public AxisIterator getAnother() {
            return new DescendantEnumeration(this.start, this.includeSelf, this.forwards);
        }
    }

    public static final class AncestorEnumeration
    extends AxisIteratorImpl {
        private boolean includeSelf;
        private boolean atStart;
        private NodeInfo start;
        private NodeInfo current;

        public AncestorEnumeration(NodeInfo start, boolean includeSelf) {
            this.start = start;
            this.includeSelf = includeSelf;
            this.current = start;
            this.atStart = true;
        }

        public final NodeInfo next() {
            if (this.atStart) {
                this.atStart = false;
                if (this.includeSelf) {
                    return this.current;
                }
            }
            this.current = this.current == null ? null : this.current.getParent();
            return this.current;
        }

        public AxisIterator getAnother() {
            return new AncestorEnumeration(this.start, this.includeSelf);
        }
    }

    public static class EmptyTextFilter
    extends AxisIteratorImpl {
        private AxisIterator base;

        public EmptyTextFilter(AxisIterator base) {
            this.base = base;
        }

        public NodeInfo next() {
            NodeInfo next;
            do {
                if ((next = this.base.next()) != null) continue;
                return null;
            } while (next.getNodeKind() == 3 && next.getStringValueCS().length() == 0);
            return next;
        }

        public AxisIterator getAnother() {
            return new EmptyTextFilter(this.base.getAnother());
        }
    }

    public static class AxisFilter
    extends AxisIteratorImpl {
        private AxisIterator base;
        private NodeTest nodeTest;

        public AxisFilter(AxisIterator base, NodeTest test) {
            this.base = base;
            this.nodeTest = test;
        }

        public NodeInfo next() {
            NodeInfo next;
            do {
                if ((next = this.base.next()) != null) continue;
                return null;
            } while (!this.nodeTest.matchesNode(next));
            return next;
        }

        public AxisIterator getAnother() {
            return new AxisFilter(this.base.getAnother(), this.nodeTest);
        }
    }
}

