/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ItemMappingFunction;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.RootExpression;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.RetainedStaticContext;
import net.sf.saxon.expr.sort.DocumentOrderIterator;
import net.sf.saxon.expr.sort.LocalOrderComparer;
import net.sf.saxon.functions.StandardFunction;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.LazySequence;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.TreeInfo;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.KeyDefinitionSet;
import net.sf.saxon.trans.KeyManager;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.EmptySequence;

public class KeyFn
extends SystemFunction {
    private KeyDefinitionSet staticKeySet = null;
    private transient boolean checked = false;
    private transient boolean internal = false;
    private boolean is30 = false;

    public StructuredQName getStaticKeyName() {
        return this.staticKeySet == null ? null : this.staticKeySet.getKeyName();
    }

    public KeyDefinitionSet getStaticKeySet() {
        return this.staticKeySet;
    }

    public KeyManager getKeyManager() {
        return this.getRetainedStaticContext().getPackageData().getKeyManager();
    }

    public boolean getInternal() {
        return this.internal;
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.getRetainedStaticContext();
    }

    public static Expression internalKeyCall(KeyManager keyManager, KeyDefinitionSet keySet, String name, Expression value, Expression doc, RetainedStaticContext rsc) {
        KeyFn k = new KeyFn();
        k.setDetails(StandardFunction.getFunction("key", 3));
        k.setArity(3);
        k.staticKeySet = keySet;
        k.checked = true;
        k.internal = true;
        k.is30 = true;
        k.setRetainedStaticContext(rsc);
        return k.makeFunctionCall(new StringLiteral(name), value, doc);
    }

    public int getSpecialProperties(Expression[] arguments) {
        int prop = 0xC20000;
        if (this.getArity() == 2 || (arguments[2].getSpecialProperties() & 0x10000) != 0) {
            prop |= 0x10000;
        }
        return prop;
    }

    public void export(ExpressionPresenter out) {
        super.export(out);
    }

    public Sequence call(XPathContext context, Sequence[] arguments) throws XPathException {
        SequenceIterator allResults;
        NodeInfo root;
        NodeInfo origin;
        if (arguments.length == 3) {
            Item arg2;
            try {
                arg2 = arguments[2].head();
            }
            catch (XPathException e) {
                String code = e.getErrorCodeLocalPart();
                if ("XPDY0002".equals(code) && arguments[2] instanceof RootExpression) {
                    throw new XPathException("Cannot call the key() function when there is no context node", "XTDE1270", context);
                }
                if ("XPDY0050".equals(code)) {
                    throw new XPathException("In the key() function, the node supplied in the third argument (or the context node if absent) must be in a tree whose root is a document node", "XTDE1270", context);
                }
                if ("XPTY0020".equals(code) || "XPTY0019".equals(code)) {
                    throw new XPathException("Cannot call the key() function when the context item is an atomic value", "XTDE1270", context);
                }
                throw e;
            }
            origin = (NodeInfo)arg2;
            root = origin.getRoot();
        } else {
            Item contextItem = context.getContextItem();
            if (contextItem == null) {
                throw new XPathException("Cannot call the key() function when there is no context item", "XTDE1270", context);
            }
            if (!(contextItem instanceof NodeInfo)) {
                throw new XPathException("Cannot call the key() function when the context item is not a node", "XTDE1270", context);
            }
            origin = root = ((NodeInfo)contextItem).getRoot();
        }
        if (root.getNodeKind() != 9) {
            throw new XPathException("In the key() function, the node supplied in the third argument (or the context node if absent) must be in a tree whose root is a document node", "XTDE1270", context);
        }
        NodeInfo doc = root;
        KeyDefinitionSet selectedKeySet = this.staticKeySet;
        if (selectedKeySet == null) {
            String givenkeyname = arguments[0].head().getStringValue();
            StructuredQName qName = null;
            try {
                qName = StructuredQName.fromLexicalQName(givenkeyname, false, true, this.getNamespaceResolver());
            }
            catch (XPathException err) {
                throw new XPathException("Invalid key name: " + err.getMessage(), "XTDE1260", context);
            }
            selectedKeySet = this.getKeyManager().getKeyDefinitionSet(qName);
            if (selectedKeySet == null) {
                throw new XPathException("Key '" + givenkeyname + "' has not been defined", "XTDE1260", context);
            }
        }
        if (selectedKeySet.isComposite()) {
            SequenceIterator soughtKey = arguments[1].iterate();
            return new LazySequence(this.getKeyManager().selectByCompositeKey(selectedKeySet, doc.getTreeInfo(), soughtKey, context));
        }
        if (!(arguments[1] instanceof GroundedValue) || ((GroundedValue)arguments[1]).getLength() > 1) {
            final XPathContext keyContext = context;
            final TreeInfo document = doc.getTreeInfo();
            final KeyManager keyManager = this.getKeyManager();
            final KeyDefinitionSet keySet = selectedKeySet;
            MappingFunction<AtomicValue, NodeInfo> map = new MappingFunction<AtomicValue, NodeInfo>(){

                @Override
                public SequenceIterator map(AtomicValue item) throws XPathException {
                    return keyManager.selectByKey(keySet, document, item, keyContext);
                }
            };
            SequenceIterator keys = arguments[1].iterate();
            MappingIterator<AtomicValue, NodeInfo> allValues = new MappingIterator<AtomicValue, NodeInfo>(keys, map);
            allResults = new DocumentOrderIterator(allValues, LocalOrderComparer.getInstance());
        } else {
            AtomicValue keyValue = (AtomicValue)arguments[1].head();
            if (keyValue == null) {
                return EmptySequence.getInstance();
            }
            allResults = this.getKeyManager().selectByKey(selectedKeySet, doc.getTreeInfo(), keyValue, context);
        }
        if (origin.isSameNodeInfo(root)) {
            return new LazySequence(allResults);
        }
        return new LazySequence(new ItemMappingIterator<NodeInfo, NodeInfo>(allResults, new SubtreeFilter(origin)));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SubtreeFilter
    implements ItemMappingFunction<NodeInfo, NodeInfo> {
        private NodeInfo origin;

        public SubtreeFilter(NodeInfo origin) {
            this.origin = origin;
        }

        @Override
        public NodeInfo mapItem(NodeInfo item) throws XPathException {
            if (Navigator.isAncestorOrSelf(this.origin, item)) {
                return item;
            }
            return null;
        }
    }
}

