<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:ixsl="http://saxonica.com/ns/interactiveXSLT"
  xmlns:prop="http://saxonica.com/ns/html-property"
  xmlns:style="http://saxonica.com/ns/html-style-property" xmlns:H="http://www.w3.org/1999/xhtml"
  extension-element-prefixes="ixsl" exclude-result-prefixes="xs" version="2.0">
  <xsl:template match="th[tokenize(@class,'\s+') = 'sortable']" mode="ixsl:onclick">
    <!-- This needs to be a little smarter to accomodate row and column spans -->
    <xsl:variable name="colNr" as="xs:integer" select="xs:integer(sum(preceding-sibling::th/number((@colspan,1)[1])) + 1)"/>
    <xsl:apply-templates select="ancestor::table[1]" mode="sort">
      <xsl:with-param name="colNr" select="$colNr"/>
      <xsl:with-param name="dataType"
        select="
          if (@data-type = 'number') then
            'number'
          else
            'text'"/>
      <xsl:with-param name="ascending" select="not(../../@data-order = $colNr)"/>
    </xsl:apply-templates>
  </xsl:template>
  <xsl:template match="table" mode="sort">
    <xsl:param name="colNr" as="xs:integer" required="yes"/>
    <xsl:param name="dataType" as="xs:string" required="yes"/>
    <xsl:param name="ascending" as="xs:boolean" required="yes"/>
    <xsl:result-document href="?select=." method="ixsl:replace-content">
      <thead data-order="{if ($ascending) then $colNr else -$colNr}">
        <xsl:copy-of select="thead/tr"/>
      </thead>
      <tbody>
        <xsl:variable name="footer" select="tbody/tr[@class = 'total']"/>
        <xsl:perform-sort select="tbody/tr except $footer">
          <xsl:sort select="replace(td[$colNr],',','')" data-type="{$dataType}"
            order="{if ($ascending) then 'ascending' else 'descending'}"/>
        </xsl:perform-sort>
        <xsl:sequence select="$footer"/>
      </tbody>
    </xsl:result-document>
  </xsl:template>
  
  <xsl:template match="th[tokenize(@class,'\s+') = 'sortable']" mode="ixsl:onmouseover">
    <xsl:for-each select="//div[@id = 'sortToolTip']">
      <ixsl:set-attribute name="style:left"
        select="concat(ixsl:get(ixsl:event(), 'clientX') + 30, 'px')"/>
      <ixsl:set-attribute name="style:top"
        select="concat(ixsl:get(ixsl:event(), 'clientY') - 15, 'px')"/>
      <ixsl:set-attribute name="style:visibility" select="'visible'"/>
    </xsl:for-each>
  </xsl:template>
  <xsl:template match="th" mode="ixsl:onmouseout">
    <xsl:for-each select="//div[@id = 'sortToolTip']">
      <ixsl:set-attribute name="style:visibility" select="'hidden'"/>
    </xsl:for-each>
  </xsl:template>
</xsl:stylesheet>