/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.RangeIterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RoleLocator;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerRange;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.SequenceType;

public class RangeExpression
extends BinaryExpression {
    public RangeExpression(Expression start, int op, Expression end) {
        super(start, op, end);
    }

    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.operand0 = visitor.typeCheck(this.operand0, contextInfo);
        this.operand1 = visitor.typeCheck(this.operand1, contextInfo);
        boolean backCompat = visitor.getStaticContext().isInBackwardsCompatibleMode();
        RoleLocator role0 = new RoleLocator(1, "to", 0);
        this.operand0 = TypeChecker.staticTypeCheck(this.operand0, SequenceType.OPTIONAL_INTEGER, backCompat, role0, visitor);
        RoleLocator role1 = new RoleLocator(1, "to", 1);
        this.operand1 = TypeChecker.staticTypeCheck(this.operand1, SequenceType.OPTIONAL_INTEGER, backCompat, role1, visitor);
        return this.makeConstantRange();
    }

    public Expression optimize(ExpressionVisitor visitor, ContextItemStaticInfo contextItemType) throws XPathException {
        this.operand0 = visitor.optimize(this.operand0, contextItemType);
        this.operand1 = visitor.optimize(this.operand1, contextItemType);
        return this.makeConstantRange();
    }

    private Expression makeConstantRange() throws XPathException {
        if (this.operand0 instanceof Literal && this.operand1 instanceof Literal) {
            GroundedValue v0 = ((Literal)this.operand0).getValue();
            GroundedValue v1 = ((Literal)this.operand1).getValue();
            if (v0 instanceof Int64Value && v1 instanceof Int64Value) {
                Literal result;
                long i1;
                long i0 = ((Int64Value)v0).longValue();
                if (i0 > (i1 = ((Int64Value)v1).longValue())) {
                    result = Literal.makeEmptySequence(this.getContainer());
                } else if (i0 == i1) {
                    result = Literal.makeLiteral(Int64Value.makeIntegerValue(i0), this.getContainer());
                } else {
                    if (i1 - i0 > Integer.MAX_VALUE) {
                        throw new XPathException("Maximum length of sequence in Saxon is 2147483647", "SXXP0006");
                    }
                    result = Literal.makeLiteral(new IntegerRange(i0, i1), this.getContainer());
                }
                ExpressionTool.copyLocationInfo(this, result);
                return result;
            }
        }
        return this;
    }

    public ItemType getItemType() {
        return BuiltInAtomicType.INTEGER;
    }

    public int computeCardinality() {
        return 57344;
    }

    public IntegerValue[] getIntegerBounds() {
        IntegerValue[] start = this.operand0.getIntegerBounds();
        IntegerValue[] end = this.operand0.getIntegerBounds();
        if (start == null || end == null) {
            return null;
        }
        return new IntegerValue[]{start[0], end[1]};
    }

    public Expression copy() {
        return new RangeExpression(this.operand0.copy(), this.operator, this.operand1.copy());
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        IntegerValue av1 = (IntegerValue)this.operand0.evaluateItem(context);
        IntegerValue av2 = (IntegerValue)this.operand1.evaluateItem(context);
        return RangeIterator.makeRangeIterator(av1, av2);
    }
}

