/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph;

import edu.uci.ics.jung.graph.AbstractTypedGraph;
import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.MultiGraph;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.graph.util.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections15.Factory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectedSparseMultigraph<V, E>
extends AbstractTypedGraph<V, E>
implements DirectedGraph<V, E>,
MultiGraph<V, E> {
    protected Map<V, Pair<Set<E>>> vertices = new HashMap<V, Pair<Set<E>>>();
    protected Map<E, Pair<V>> edges = new HashMap<E, Pair<V>>();

    public static <V, E> Factory<DirectedGraph<V, E>> getFactory() {
        return new Factory<DirectedGraph<V, E>>(){

            public DirectedGraph<V, E> create() {
                return new DirectedSparseMultigraph();
            }
        };
    }

    public DirectedSparseMultigraph() {
        super(EdgeType.DIRECTED);
    }

    public Collection<E> getEdges() {
        return Collections.unmodifiableCollection(this.edges.keySet());
    }

    public Collection<V> getVertices() {
        return Collections.unmodifiableCollection(this.vertices.keySet());
    }

    public boolean containsVertex(V vertex) {
        return this.vertices.keySet().contains(vertex);
    }

    public boolean containsEdge(E edge) {
        return this.edges.keySet().contains(edge);
    }

    protected Collection<E> getIncoming_internal(V vertex) {
        return (Collection)this.vertices.get(vertex).getFirst();
    }

    protected Collection<E> getOutgoing_internal(V vertex) {
        return (Collection)this.vertices.get(vertex).getSecond();
    }

    public boolean addVertex(V vertex) {
        if (vertex == null) {
            throw new IllegalArgumentException("vertex may not be null");
        }
        if (!this.containsVertex(vertex)) {
            this.vertices.put((Pair)vertex, (Pair<Set<E>>)new Pair(new HashSet(), new HashSet()));
            return true;
        }
        return false;
    }

    public boolean removeVertex(V vertex) {
        if (!this.containsVertex(vertex)) {
            return false;
        }
        HashSet<E> incident = new HashSet<E>(this.getIncoming_internal(vertex));
        incident.addAll(this.getOutgoing_internal(vertex));
        for (Object edge : incident) {
            this.removeEdge(edge);
        }
        this.vertices.remove(vertex);
        return true;
    }

    public boolean removeEdge(E edge) {
        if (!this.containsEdge(edge)) {
            return false;
        }
        Pair<V> endpoints = this.getEndpoints(edge);
        Object source = endpoints.getFirst();
        Object dest = endpoints.getSecond();
        this.getOutgoing_internal(source).remove(edge);
        this.getIncoming_internal(dest).remove(edge);
        this.edges.remove(edge);
        return true;
    }

    public Collection<E> getInEdges(V vertex) {
        if (!this.containsVertex(vertex)) {
            return null;
        }
        return Collections.unmodifiableCollection(this.getIncoming_internal(vertex));
    }

    public Collection<E> getOutEdges(V vertex) {
        if (!this.containsVertex(vertex)) {
            return null;
        }
        return Collections.unmodifiableCollection(this.getOutgoing_internal(vertex));
    }

    public Collection<V> getPredecessors(V vertex) {
        if (!this.containsVertex(vertex)) {
            return null;
        }
        HashSet<V> preds = new HashSet<V>();
        for (E edge : this.getIncoming_internal(vertex)) {
            preds.add(this.getSource(edge));
        }
        return Collections.unmodifiableCollection(preds);
    }

    public Collection<V> getSuccessors(V vertex) {
        if (!this.containsVertex(vertex)) {
            return null;
        }
        HashSet<V> succs = new HashSet<V>();
        for (E edge : this.getOutgoing_internal(vertex)) {
            succs.add(this.getDest(edge));
        }
        return Collections.unmodifiableCollection(succs);
    }

    public Collection<V> getNeighbors(V vertex) {
        if (!this.containsVertex(vertex)) {
            return null;
        }
        HashSet<V> neighbors = new HashSet<V>();
        for (E edge : this.getIncoming_internal(vertex)) {
            neighbors.add(this.getSource(edge));
        }
        for (E edge : this.getOutgoing_internal(vertex)) {
            neighbors.add(this.getDest(edge));
        }
        return Collections.unmodifiableCollection(neighbors);
    }

    public Collection<E> getIncidentEdges(V vertex) {
        if (!this.containsVertex(vertex)) {
            return null;
        }
        HashSet<E> incident = new HashSet<E>();
        incident.addAll(this.getIncoming_internal(vertex));
        incident.addAll(this.getOutgoing_internal(vertex));
        return incident;
    }

    @Override
    public E findEdge(V v1, V v2) {
        if (!this.containsVertex(v1) || !this.containsVertex(v2)) {
            return null;
        }
        for (E edge : this.getOutgoing_internal(v1)) {
            if (!this.getDest(edge).equals(v2)) continue;
            return edge;
        }
        return null;
    }

    @Override
    public boolean addEdge(E edge, Pair<? extends V> endpoints, EdgeType edgeType) {
        this.validateEdgeType(edgeType);
        Pair<? extends V> new_endpoints = this.getValidatedEndpoints(edge, endpoints);
        if (new_endpoints == null) {
            return false;
        }
        this.edges.put(edge, new_endpoints);
        Object source = new_endpoints.getFirst();
        Object dest = new_endpoints.getSecond();
        if (!this.containsVertex(source)) {
            this.addVertex(source);
        }
        if (!this.containsVertex(dest)) {
            this.addVertex(dest);
        }
        this.getIncoming_internal(dest).add(edge);
        this.getOutgoing_internal(source).add(edge);
        return true;
    }

    public V getSource(E edge) {
        if (!this.containsEdge(edge)) {
            return null;
        }
        return (V)this.getEndpoints(edge).getFirst();
    }

    public V getDest(E edge) {
        if (!this.containsEdge(edge)) {
            return null;
        }
        return (V)this.getEndpoints(edge).getSecond();
    }

    public boolean isSource(V vertex, E edge) {
        if (!this.containsEdge(edge) || !this.containsVertex(vertex)) {
            return false;
        }
        return vertex.equals(this.getEndpoints(edge).getFirst());
    }

    public boolean isDest(V vertex, E edge) {
        if (!this.containsEdge(edge) || !this.containsVertex(vertex)) {
            return false;
        }
        return vertex.equals(this.getEndpoints(edge).getSecond());
    }

    public Pair<V> getEndpoints(E edge) {
        return this.edges.get(edge);
    }

    public int getEdgeCount() {
        return this.edges.size();
    }

    public int getVertexCount() {
        return this.vertices.size();
    }
}

