/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.agent.repkg.de.schlichtherle.io.rof;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.terracotta.agent.repkg.de.schlichtherle.io.rof.ReadOnlyFile;

public class FastReadOnlyFile
extends RandomAccessFile
implements ReadOnlyFile {
    private long fp;
    private boolean closed;

    public FastReadOnlyFile(File file) throws FileNotFoundException {
        super(file, "r");
    }

    public long getFilePointer() throws IOException {
        this.ensureOpen();
        return this.fp;
    }

    public void seek(long pos) throws IOException {
        if (pos == this.fp) {
            this.ensureOpen();
            return;
        }
        super.seek(pos);
        this.fp = pos;
    }

    public int read() throws IOException {
        int ret = super.read();
        if (ret != -1) {
            ++this.fp;
        }
        return ret;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int ret = super.read(b, off, len);
        if (ret != -1) {
            this.fp += (long)ret;
        }
        return ret;
    }

    public void close() throws IOException {
        super.close();
        this.closed = true;
    }

    private final void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("file is closed");
        }
    }
}

