/*
 * Decompiled with CFR 0.152.
 */
package net.sf.beanlib.hibernate;

import java.util.Collections;
import java.util.Set;
import net.jcip.annotations.NotThreadSafe;
import net.sf.beanlib.hibernate.HibernatePropertyFilter;
import net.sf.beanlib.hibernate.UnEnhancer;
import net.sf.beanlib.spi.BeanMethodCollector;
import net.sf.beanlib.spi.BeanMethodFinder;
import net.sf.beanlib.spi.BeanPopulationExceptionHandler;
import net.sf.beanlib.spi.BeanPopulatorBaseConfig;
import net.sf.beanlib.spi.BeanPopulatorBaseSpi;
import net.sf.beanlib.spi.BeanSourceHandler;
import net.sf.beanlib.spi.BeanTransformerSpi;
import net.sf.beanlib.spi.ChainedCustomBeanTransformer;
import net.sf.beanlib.spi.CustomBeanTransformerSpi;
import net.sf.beanlib.spi.DetailedPropertyFilter;
import net.sf.beanlib.spi.PropertyFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public abstract class HibernateBeanReplicator
implements BeanPopulatorBaseSpi {
    private final BeanTransformerSpi hibernateBeanTransformer;

    protected HibernateBeanReplicator(BeanTransformerSpi hibernateBeanTransformer) {
        if (hibernateBeanTransformer == null) {
            throw new IllegalArgumentException("Argument hibernateBeanTransformer must not be null");
        }
        this.hibernateBeanTransformer = hibernateBeanTransformer;
    }

    public final <T> T copy(T from) {
        return from == null ? null : (T)this.copy(from, UnEnhancer.getActualClass(from));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T copy(Object from, Class<T> toClass) {
        if (from == null) {
            return null;
        }
        try {
            Object object = this.hibernateBeanTransformer.transform(from, toClass, null);
            return (T)object;
        }
        finally {
            this.hibernateBeanTransformer.reset();
        }
    }

    public final <T> T deepCopy(T from) {
        return from == null ? null : (T)this.deepCopy(from, UnEnhancer.getActualClass(from));
    }

    public final <T> T deepCopy(Object from, Class<T> toClass) {
        this.hibernateBeanTransformer.initPropertyFilter((PropertyFilter)new HibernatePropertyFilter());
        return this.copy(from, toClass);
    }

    public final <T> T shallowCopy(T from) {
        return from == null ? null : (T)this.shallowCopy(from, UnEnhancer.getActualClass(from));
    }

    public final <T> T shallowCopy(Object from, Class<T> toClass) {
        Set emptyCollectionPropertyNameSet = Collections.emptySet();
        Set<Class<?>> emptyEntityBeanClassSet = Collections.emptySet();
        this.hibernateBeanTransformer.initPropertyFilter((PropertyFilter)new HibernatePropertyFilter().withCollectionPropertyNameSet(emptyCollectionPropertyNameSet).withEntityBeanClassSet(emptyEntityBeanClassSet));
        return this.copy(from, toClass);
    }

    public final HibernateBeanReplicator initCustomTransformerFactory(CustomBeanTransformerSpi.Factory ... customBeanTransformerFactories) {
        if (customBeanTransformerFactories != null && customBeanTransformerFactories.length > 0) {
            this.hibernateBeanTransformer.initCustomTransformerFactory((CustomBeanTransformerSpi.Factory)(customBeanTransformerFactories.length == 1 ? customBeanTransformerFactories[0] : new ChainedCustomBeanTransformer.Factory(customBeanTransformerFactories)));
        } else {
            this.hibernateBeanTransformer.initCustomTransformerFactory(null);
        }
        return this;
    }

    public final PropertyFilter getPropertyFilter() {
        return this.hibernateBeanTransformer.getPropertyFilter();
    }

    public final HibernateBeanReplicator initPropertyFilter(PropertyFilter propertyFilter) {
        this.hibernateBeanTransformer.initPropertyFilter(propertyFilter);
        return this;
    }

    public final HibernateBeanReplicator initDetailedPropertyFilter(DetailedPropertyFilter detailedPropertyFilter) {
        this.hibernateBeanTransformer.initDetailedPropertyFilter(detailedPropertyFilter);
        return this;
    }

    public final HibernateBeanReplicator initBeanSourceHandler(BeanSourceHandler beanSourceHandler) {
        this.hibernateBeanTransformer.initBeanSourceHandler(beanSourceHandler);
        return this;
    }

    public final HibernateBeanReplicator initDebug(boolean debug) {
        this.hibernateBeanTransformer.initDebug(debug);
        return this;
    }

    public final HibernateBeanReplicator initReaderMethodFinder(BeanMethodFinder readerMethodFinder) {
        this.hibernateBeanTransformer.initReaderMethodFinder(readerMethodFinder);
        return this;
    }

    public final HibernateBeanReplicator initSetterMethodCollector(BeanMethodCollector setterMethodCollector) {
        this.hibernateBeanTransformer.initSetterMethodCollector(setterMethodCollector);
        return this;
    }

    public HibernateBeanReplicator initBeanPopulationExceptionHandler(BeanPopulationExceptionHandler beanPopulationExceptionHandler) {
        this.hibernateBeanTransformer.initBeanPopulationExceptionHandler(beanPopulationExceptionHandler);
        return this;
    }

    public BeanPopulatorBaseSpi initBeanPopulatorBaseConfig(BeanPopulatorBaseConfig baseConfig) {
        this.hibernateBeanTransformer.initBeanPopulatorBaseConfig(baseConfig);
        return this;
    }

    public BeanPopulationExceptionHandler getBeanPopulationExceptionHandler() {
        return this.hibernateBeanTransformer.getBeanPopulationExceptionHandler();
    }

    public BeanPopulatorBaseConfig getBeanPopulatorBaseConfig() {
        return this.hibernateBeanTransformer.getBeanPopulatorBaseConfig();
    }

    public BeanSourceHandler getBeanSourceHandler() {
        return this.hibernateBeanTransformer.getBeanSourceHandler();
    }

    public boolean isDebug() {
        return this.hibernateBeanTransformer.isDebug();
    }

    public DetailedPropertyFilter getDetailedPropertyFilter() {
        return this.hibernateBeanTransformer.getDetailedPropertyFilter();
    }

    public BeanMethodFinder getReaderMethodFinder() {
        return this.hibernateBeanTransformer.getReaderMethodFinder();
    }

    public BeanMethodCollector getSetterMethodCollector() {
        return this.hibernateBeanTransformer.getSetterMethodCollector();
    }

    public HibernatePropertyFilter getHibernatePropertyFilter() {
        PropertyFilter f = this.hibernateBeanTransformer.getPropertyFilter();
        return f instanceof HibernatePropertyFilter ? (HibernatePropertyFilter)f : null;
    }
}

