/*
 * Decompiled with CFR 0.152.
 */
package net.sf.alchim.mojo.yuicompressor;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.IOUtil;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Aggregation {
    public File output;
    public String[] includes;
    public String[] excludes;
    public boolean removeIncluded = false;
    public boolean insertNewLine = false;

    public void run() throws Exception {
        List<File> files = this.getIncludedFiles();
        if (files.size() != 0) {
            FileOutputStream out = new FileOutputStream(this.output);
            try {
                for (File file : files) {
                    if (file.getCanonicalPath().equals(this.output.getCanonicalPath())) continue;
                    FileInputStream in = new FileInputStream(file);
                    try {
                        IOUtil.copy((InputStream)in, (OutputStream)out);
                        if (this.insertNewLine) {
                            out.write(10);
                        }
                    }
                    finally {
                        IOUtil.close((InputStream)in);
                        in = null;
                    }
                    if (!this.removeIncluded) continue;
                    file.delete();
                }
            }
            finally {
                IOUtil.close((OutputStream)out);
                Object var2_2 = null;
            }
        }
    }

    protected List<File> getIncludedFiles() throws Exception {
        ArrayList<File> back = new ArrayList<File>();
        if (this.includes != null) {
            String[] stringArray = this.includes;
            int n = this.includes.length;
            int n2 = 0;
            while (n2 < n) {
                String include = stringArray[n2];
                this.addInto(include, back);
                ++n2;
            }
        }
        return back;
    }

    private void addInto(String include, List<File> includedFiles) throws Exception {
        if (include.indexOf(42) > -1) {
            String[] rpaths;
            DirectoryScanner scanner = this.newScanner();
            scanner.setIncludes(new String[]{include});
            scanner.scan();
            String[] stringArray = rpaths = scanner.getIncludedFiles();
            int n = rpaths.length;
            int n2 = 0;
            while (n2 < n) {
                String rpath = stringArray[n2];
                File file = new File(scanner.getBasedir(), rpath);
                if (!includedFiles.contains(file)) {
                    includedFiles.add(file);
                }
                ++n2;
            }
        } else {
            File file = new File(include);
            if (!file.isAbsolute()) {
                file = new File(this.output.getParentFile(), include);
            }
            if (!includedFiles.contains(file)) {
                includedFiles.add(file);
            }
        }
    }

    private DirectoryScanner newScanner() throws Exception {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(this.output.getParentFile());
        if (this.excludes != null && this.excludes.length != 0) {
            scanner.setExcludes(this.excludes);
        }
        scanner.addDefaultExcludes();
        return scanner;
    }
}

