/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n.plugin.parser;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.StringUtils;
import org.nuiton.i18n.plugin.I18nMojoSupport;
import org.nuiton.i18n.plugin.parser.java.Java8BaseVisitor;
import org.nuiton.i18n.plugin.parser.java.Java8Lexer;
import org.nuiton.i18n.plugin.parser.java.Java8Parser;
import org.nuiton.i18n.spi.GetterFile;
import org.nuiton.plugin.PluginHelper;

@Mojo(name="parse-java-enumerations", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class ParseJavaEnumerationsMojo
extends I18nMojoSupport {
    @Parameter(property="i18n.packageName")
    private String packageName;
    @Parameter(property="i18n.className", defaultValue="I18nEnumHelper", required=true)
    private String className;
    @Parameter(property="i18n.outputDirectory", defaultValue="${basedir}/target/generated-sources/java", required=true)
    private File outputDirectory;
    @Parameter(property="i18n.generateHelper", defaultValue="false")
    private boolean generateHelper;
    @Parameter(required=true)
    private List<EnumerationSet> enumerationSets;

    protected void doAction() throws Exception {
        if (this.generateHelper) {
            this.generateHelper();
        }
        GetterFile getterFile = new GetterFile(this.gettersDirectory, "generate-enum.getter");
        TreeMap<String, Set<String>> types = new TreeMap<String, Set<String>>();
        for (EnumerationSet enumerationSet : this.enumerationSets) {
            for (String anEnumType : enumerationSet.getEnums()) {
                Set<String> enumValues = (Set<String>)types.get(anEnumType);
                if (enumValues == null) {
                    enumValues = this.getEnumConstants(anEnumType);
                    types.put(anEnumType, enumValues);
                }
                int ordinal = 0;
                String simpleName = anEnumType.substring(anEnumType.lastIndexOf(46) + 1);
                for (String name : enumValues) {
                    getterFile.addKey(enumerationSet.transformToKey(anEnumType, simpleName, name, ordinal++ + ""));
                }
            }
        }
        getterFile.store();
    }

    private void generateHelper() throws IOException {
        if (this.packageName == null) {
            this.packageName = this.getProject().getGroupId() + "." + this.getProject().getArtifactId().replaceAll("-", ".");
        }
        File directory = PluginHelper.getFile((File)this.outputDirectory, (String[])this.packageName.trim().split("\\."));
        File file = new File(directory, this.className + ".java");
        Files.createParentDirs((File)file);
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)("Generate i18n helper at " + file));
        }
        try (BufferedWriter writer = Files.newWriter((File)file, (Charset)Charsets.UTF_8);){
            writer.write("package " + this.packageName + ";\n");
            writer.write("\n");
            writer.write("import java.util.Locale;\n");
            writer.write("import javax.annotation.Generated;\n");
            writer.write("\n");
            writer.write("import static org.nuiton.i18n.I18n.l;\n");
            writer.write("import static org.nuiton.i18n.I18n.n;\n");
            writer.write("import static org.nuiton.i18n.I18n.t;\n");
            writer.write("\n");
            writer.write("\n");
            writer.write("@Generated(value = \"Generated by " + ((Object)((Object)this)).getClass().getName() + "\",date = \"" + new Date() + "\")\n");
            writer.write("public class " + this.className + " {\n");
            writer.write("\n");
            for (EnumerationSet enumerationSet : this.enumerationSets) {
                String methodName = "get" + StringUtils.capitalise((String)enumerationSet.getName());
                writer.write("    public static <E extends Enum<E>> String " + methodName + "(E e) {\n");
                writer.write("        return t(" + methodName + "Key(e));\n");
                writer.write("    }\n");
                writer.write("\n");
                writer.write("    public static <E extends Enum<E>> String " + methodName + "(Locale locale, E e) {\n");
                writer.write("        return l(locale, " + methodName + "Key(e));\n");
                writer.write("    }\n");
                writer.write("\n");
                writer.write("    protected static <E extends Enum<E>> String " + methodName + "Key(E e) {\n");
                writer.write("        return " + enumerationSet.transformToMessage() + ";\n");
                writer.write("    }\n");
                writer.write("\n");
            }
            writer.write("\n    protected static String removeAnonymousSuffix(String className) {\n");
            writer.write("        return className.contains(\"$\") ? className.substring(0, className.indexOf(\"$\")) : className;");
            writer.write("\n    }\n");
            writer.write("}\n");
        }
    }

    private Set<String> getEnumConstants(String anEnumType) throws IOException {
        TreeSet<String> result;
        block5: {
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)("Scan enum: " + anEnumType));
            }
            result = new TreeSet<String>();
            try {
                Class<?> aClass = Class.forName(anEnumType);
                if (!aClass.isEnum()) {
                    throw new IllegalStateException("Type " + aClass.getName() + " is not an enum.");
                }
                for (Object o : aClass.getEnumConstants()) {
                    result.add(((Enum)o).name());
                }
            }
            catch (ClassNotFoundException e) {
                File basedir = new File(new File(new File(this.getProject().getBasedir(), "src"), "main"), "java");
                File file = PluginHelper.getFile((File)basedir, (String[])anEnumType.trim().split("\\."));
                File javaFile = new File(file.getParentFile(), file.getName() + ".java");
                if (!javaFile.exists()) break block5;
                CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)new Java8Lexer(CharStreams.fromFile((File)javaFile, (Charset)this.charset)));
                Java8Parser parser = new Java8Parser((TokenStream)tokenStream);
                ((ParserATNSimulator)parser.getInterpreter()).enable_global_context_dfa = true;
                JavaParserVisitor visitor = new JavaParserVisitor(javaFile);
                parser.compilationUnit().accept(visitor);
                Set<String> names = visitor.getNames();
                result.addAll(names);
            }
        }
        return result;
    }

    public static class EnumerationSet {
        private String name;
        private String pattern;
        private List<String> enums;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getPattern() {
            return this.pattern;
        }

        public void setPattern(String pattern) {
            this.pattern = pattern;
        }

        List<String> getEnums() {
            return this.enums;
        }

        String transformToKey(String className, String simpleName, String name, String ordinal) {
            String result = this.pattern;
            result = result.replace("@CLASS_NAME@", className);
            result = result.replace("@CLASS_SIMPLE_NAME@", simpleName);
            result = result.replace("@NAME@", name);
            result = result.replace("@ORDINAL@", ordinal);
            return result;
        }

        String transformToMessage() {
            String result = "";
            StringTokenizer stringTokenizer = new StringTokenizer(this.pattern, "@");
            block12: while (stringTokenizer.hasMoreTokens()) {
                String token;
                if (!result.isEmpty()) {
                    result = result + " + ";
                }
                switch (token = stringTokenizer.nextToken()) {
                    case "CLASS_SIMPLE_NAME": {
                        result = result + "e.getClass().getSimpleName()";
                        continue block12;
                    }
                    case "CLASS_NAME": {
                        result = result + "removeAnonymousSuffix(e.getClass().getName())";
                        continue block12;
                    }
                    case "NAME": {
                        result = result + "e.name()";
                        continue block12;
                    }
                    case "ORDINAL": {
                        result = result + "e.ordinal()";
                        continue block12;
                    }
                }
                result = result + "\"" + token + "\"";
            }
            if (result.endsWith("+")) {
                result = result.substring(0, result.length() - 1);
            }
            return result;
        }
    }

    protected class JavaParserVisitor
    extends Java8BaseVisitor<Void> {
        final Set<String> names;
        final File file;

        private JavaParserVisitor(File file) {
            this.file = file;
            this.names = new LinkedHashSet<String>();
        }

        Set<String> getNames() {
            return this.names;
        }

        @Override
        public Void visitEnumConstant(Java8Parser.EnumConstantContext ctx) {
            String text = ctx.getChild(0).getText();
            this.names.add(text);
            return (Void)super.visitEnumConstant(ctx);
        }
    }
}

