/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.plugins.compile.javac;

import io.takari.incrementalbuild.MessageSeverity;
import io.takari.incrementalbuild.Resource;
import io.takari.maven.plugins.compile.CompilerBuildContext;
import io.takari.maven.plugins.compile.ProjectClasspathDigester;
import io.takari.maven.plugins.compile.javac.AbstractCompilerJavac;
import io.takari.maven.plugins.compile.javac.CompilerJavacForked;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ProcessDestroyer;
import org.apache.commons.exec.ShutdownHookProcessDestroyer;

@Named(value="forked-javac")
public class CompilerJavacLauncher
extends AbstractCompilerJavac {
    public static final String ID = "forked-javac";
    private File jar;
    private File basedir;
    private File buildDirectory;
    private String meminitial;
    private String maxmem;

    @Inject
    public CompilerJavacLauncher(CompilerBuildContext context, ProjectClasspathDigester digester) {
        super(context, digester);
    }

    @Override
    public int compile(Map<File, Resource<File>> sources) throws IOException {
        if (sources.isEmpty()) {
            return 0;
        }
        File options = File.createTempFile("javac-forked", ".options", this.buildDirectory);
        File output = File.createTempFile("javac-forked", ".output", this.buildDirectory);
        this.compile(options, output, sources);
        options.delete();
        output.delete();
        return sources.size();
    }

    private void compile(File options, File output, final Map<File, Resource<File>> sources) throws IOException {
        new CompilerJavacForked.CompilerConfiguration(this.getSourceEncoding(), this.getCompilerOptions(), sources.keySet()).write(options);
        String executable = String.valueOf(System.getProperty("java.home")) + File.separator + "bin" + File.separator + "java";
        if (File.separatorChar == '\\') {
            executable = String.valueOf(executable) + ".exe";
        }
        CommandLine cli = new CommandLine(executable);
        cli.addArguments(new String[]{"-cp", this.jar.getAbsolutePath()});
        if (this.meminitial != null) {
            cli.addArgument("-Xms" + this.meminitial);
        }
        if (this.maxmem != null) {
            cli.addArgument("-Xmx" + this.maxmem);
        }
        cli.addArgument(CompilerJavacForked.class.getName());
        cli.addArgument(options.getAbsolutePath(), false);
        cli.addArgument(output.getAbsolutePath(), false);
        DefaultExecutor executor = new DefaultExecutor();
        executor.setProcessDestroyer((ProcessDestroyer)new ShutdownHookProcessDestroyer());
        executor.setWorkingDirectory(this.basedir);
        this.log.debug("External java process command line:\n   {}", (Object)cli);
        try {
            executor.execute(cli);
        }
        catch (ExecuteException e) {
            if (!this.log.isDebugEnabled()) {
                this.log.info("External java process command line:\n   {}", (Object)cli);
            }
            throw e;
        }
        final HashMap outputs = new HashMap();
        CompilerJavacForked.CompilerOutput.process(output, new CompilerJavacForked.CompilerOutputProcessor(){

            @Override
            public void processOutput(File inputFile, File outputFile) {
                outputs.put(outputFile, CompilerJavacLauncher.this.context.processOutput(outputFile));
            }

            @Override
            public void addMessage(String path, int line, int column, String message, MessageSeverity kind) {
                if (".".equals(path)) {
                    CompilerJavacLauncher.this.context.addPomMessage(message, kind, null);
                } else {
                    File file = new File(path);
                    Resource resource = (Resource)sources.get(file);
                    if (resource == null) {
                        resource = (Resource)outputs.get(file);
                    }
                    if (resource != null) {
                        if (CompilerJavacLauncher.this.isShowWarnings() || kind != MessageSeverity.WARNING) {
                            resource.addMessage(line, column, message, kind, null);
                        }
                    } else {
                        CompilerJavacLauncher.this.log.warn("Unexpected java resource {}", (Object)file);
                    }
                }
            }

            @Override
            public void addLogMessage(String message) {
                CompilerJavacLauncher.this.log.warn(message);
            }
        });
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    public void setJar(File jar) {
        this.jar = jar;
    }

    public void setBuildDirectory(File buildDirectory) {
        this.buildDirectory = buildDirectory;
    }

    public void setMeminitial(String meminitial) {
        this.meminitial = meminitial;
    }

    public void setMaxmem(String maxmem) {
        this.maxmem = maxmem;
    }

    @Override
    protected String getCompilerId() {
        return ID;
    }
}

