/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.plugins.jar;

import io.takari.incrementalbuild.BuildContext;
import io.takari.incrementalbuild.aggregator.AggregatorBuildContext;
import io.takari.maven.plugins.TakariLifecycleMojo;
import io.takari.maven.plugins.jar.AggregateSource;
import io.takari.maven.plugins.jar.ArchiveConfiguration;
import io.takari.maven.plugins.jar.BytesEntry;
import io.takari.maven.plugins.jar.JarProperties;
import io.tesla.proviso.archive.Archiver;
import io.tesla.proviso.archive.Entry;
import io.tesla.proviso.archive.Source;
import io.tesla.proviso.archive.source.FileEntry;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.inject.Inject;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="jar", defaultPhase=LifecyclePhase.PACKAGE)
public class Jar
extends TakariLifecycleMojo {
    @Parameter(defaultValue="${project.build.outputDirectory}")
    private File classesDirectory;
    @Parameter(defaultValue="${project.build.finalName}")
    private String finalName;
    @Parameter(defaultValue="${project.build.directory}")
    private File outputDirectory;
    @Parameter(defaultValue="true", property="mainJar")
    private boolean mainJar;
    @Parameter(defaultValue="false", property="sourceJar")
    private boolean sourceJar;
    @Parameter(defaultValue="false", property="testJar")
    private boolean testJar;
    @Parameter(defaultValue="${project.build.testOutputDirectory}")
    private File testClassesDirectory;
    @Parameter
    private ArchiveConfiguration archive;
    @Inject
    private AggregatorBuildContext buildContext;
    private static final String MANIFEST_PATH = "META-INF/MANIFEST.MF";

    @Override
    protected void executeMojo() throws MojoExecutionException {
        AggregatorBuildContext.AggregateOutput registeredOutput;
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdir();
        }
        if (this.mainJar) {
            File jar = new File(this.outputDirectory, String.format("%s.jar", this.finalName));
            registeredOutput = this.buildContext.registerOutput(jar);
            try {
                if (this.classesDirectory.isDirectory()) {
                    registeredOutput.addInputs(this.classesDirectory, null, null, new AggregatorBuildContext.InputProcessor[0]);
                } else {
                    this.logger.warn("Main classes directory {} does not exist", (Object)this.classesDirectory);
                }
                registeredOutput.createIfNecessary(new AggregatorBuildContext.AggregateCreator(){

                    public void create(BuildContext.Output<File> output, Iterable<AggregatorBuildContext.AggregateInput> inputs) throws IOException {
                        Jar.this.logger.info("Building main JAR.");
                        ArrayList<Iterable> sources = new ArrayList<Iterable>();
                        if (Jar.this.archive != null && Jar.this.archive.getManifestFile() != null) {
                            sources.add(Jar.jarManifestSource(Jar.this.archive.getManifestFile()));
                        }
                        sources.add(Jar.this.inputsSource(inputs));
                        sources.add(Jar.this.pomPropertiesSource(Jar.this.project));
                        sources.add(Jar.this.jarManifestSource(Jar.this.project));
                        Jar.this.archive((File)output.getResource(), sources);
                    }
                });
                this.project.getArtifact().setFile(jar);
            }
            catch (IOException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
        }
        if (this.sourceJar) {
            File sourceJar = new File(this.outputDirectory, String.format("%s-%s.jar", this.finalName, "sources"));
            registeredOutput = this.buildContext.registerOutput(sourceJar);
            try {
                for (String sourceRoot : this.project.getCompileSourceRoots()) {
                    File dir = new File(sourceRoot);
                    if (!dir.isDirectory()) continue;
                    registeredOutput.addInputs(new File(sourceRoot), null, null, new AggregatorBuildContext.InputProcessor[0]);
                }
                registeredOutput.createIfNecessary(new AggregatorBuildContext.AggregateCreator(){

                    public void create(BuildContext.Output<File> output, Iterable<AggregatorBuildContext.AggregateInput> inputs) throws IOException {
                        Jar.this.logger.info("Building source Jar.");
                        Jar.this.archive((File)output.getResource(), Arrays.asList(Jar.this.inputsSource(inputs), Jar.this.jarManifestSource(Jar.this.project)));
                    }
                });
                this.projectHelper.attachArtifact(this.project, "jar", "sources", sourceJar);
            }
            catch (IOException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
        }
        if (this.testJar && this.testClassesDirectory.isDirectory()) {
            File testJar = new File(this.outputDirectory, String.format("%s-%s.jar", this.finalName, "tests"));
            registeredOutput = this.buildContext.registerOutput(testJar);
            try {
                if (this.testClassesDirectory.isDirectory()) {
                    registeredOutput.addInputs(this.testClassesDirectory, null, null, new AggregatorBuildContext.InputProcessor[0]);
                } else {
                    this.logger.warn("Test classes directory {} does not exist", (Object)this.classesDirectory);
                }
                registeredOutput.createIfNecessary(new AggregatorBuildContext.AggregateCreator(){

                    public void create(BuildContext.Output<File> output, Iterable<AggregatorBuildContext.AggregateInput> inputs) throws IOException {
                        Jar.this.logger.info("Building test JAR.");
                        Jar.this.archive((File)output.getResource(), Arrays.asList(Jar.this.inputsSource(inputs), Jar.this.jarManifestSource(Jar.this.project)));
                    }
                });
            }
            catch (IOException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
            this.projectHelper.attachArtifact(this.project, "jar", "tests", testJar);
        }
    }

    private void archive(File jar, List<Iterable<Entry>> sources) throws IOException {
        Archiver archiver = Archiver.builder().useRoot(false).build();
        archiver.archive(jar, new Source[]{new AggregateSource(sources)});
    }

    static String getRelativePath(File basedir, File resource) {
        return basedir.toPath().relativize(resource.toPath()).toString().replace('\\', '/');
    }

    private Iterable<Entry> inputsSource(Iterable<AggregatorBuildContext.AggregateInput> inputs) {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        for (AggregatorBuildContext.AggregateInput input : inputs) {
            String entryName = Jar.getRelativePath(input.getBasedir(), (File)input.getResource());
            entries.add((Entry)new FileEntry(entryName, (File)input.getResource()));
        }
        return entries;
    }

    public static Iterable<Entry> jarManifestSource(File file) {
        return Collections.singleton(new FileEntry(MANIFEST_PATH, file));
    }

    private Iterable<Entry> jarManifestSource(MavenProject project) throws IOException {
        Manifest manifest = new Manifest();
        Attributes main = manifest.getMainAttributes();
        main.putValue("Manifest-Version", "1.0");
        main.putValue("Archiver-Version", "Provisio Archiver");
        main.putValue("Created-By", "Takari Inc.");
        main.putValue("Built-By", System.getProperty("user.name"));
        main.putValue("Build-Jdk", System.getProperty("java.version"));
        main.putValue("Specification-Title", project.getArtifactId());
        main.putValue("Specification-Version", project.getVersion());
        main.putValue("Implementation-Title", project.getArtifactId());
        main.putValue("Implementation-Version", project.getVersion());
        main.putValue("Implementation-Vendor-Id", project.getGroupId());
        File manifestFile = new File(project.getBuild().getDirectory(), "MANIFEST.MF");
        if (!manifestFile.getParentFile().exists()) {
            manifestFile.getParentFile().mkdirs();
        }
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        manifest.write(buf);
        return Collections.singleton(new BytesEntry(MANIFEST_PATH, buf.toByteArray()));
    }

    private Iterable<Entry> pomPropertiesSource(MavenProject project) throws IOException {
        String entryName = String.format("META-INF/maven/%s/%s/pom.properties", project.getGroupId(), project.getArtifactId());
        JarProperties properties = new JarProperties();
        properties.setProperty("groupId", project.getGroupId());
        properties.setProperty("artifactId", project.getArtifactId());
        properties.setProperty("version", project.getVersion());
        File mavenPropertiesFile = new File(project.getBuild().getDirectory(), "pom.properties");
        if (!mavenPropertiesFile.getParentFile().exists()) {
            mavenPropertiesFile.getParentFile().mkdirs();
        }
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        properties.store(buf);
        return Collections.singleton(new BytesEntry(entryName, buf.toByteArray()));
    }
}

