/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.common.process;

import io.smallrye.common.constraint.Assert;
import io.smallrye.common.os.OS;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Stream;

public final class ProcessUtil {
    private ProcessUtil() {
    }

    public static Charset nativeCharset() {
        return NativeCharset.charset;
    }

    public static void destroyAllForcibly(ProcessHandle handle) {
        if (handle == null) {
            return;
        }
        for (ProcessHandle processHandle : handle.children().toList()) {
            ProcessUtil.destroyAllForcibly(processHandle);
        }
        handle.destroyForcibly();
    }

    public static void destroyAllForcibly(Process process) {
        if (process == null) {
            return;
        }
        for (ProcessHandle processHandle : process.children().toList()) {
            ProcessUtil.destroyAllForcibly(processHandle);
        }
        process.destroyForcibly();
    }

    public static Optional<Path> pathOfCommand(Path path) {
        Assert.checkNotNullParam((String)"path", (Object)path);
        if (path.isAbsolute()) {
            return Files.isExecutable(path) ? Optional.of(path) : Optional.empty();
        }
        for (Path segment : ProcessUtil.searchPath()) {
            Path execPath = segment.resolve(path);
            if (Files.isExecutable(execPath)) {
                return Optional.of(execPath);
            }
            if (OS.current() != OS.WINDOWS) continue;
            for (String ext : Windows.pathExt) {
                Path execPathExt = execPath.getParent().resolve(String.valueOf(execPath.getFileName()) + ext);
                if (!Files.isExecutable(execPathExt)) continue;
                return Optional.of(execPathExt);
            }
        }
        return Optional.empty();
    }

    public static List<Path> searchPath() {
        return PathEnv.path;
    }

    public static Path pathOfJava() {
        return JavaPath.javaPath;
    }

    public static Optional<Path> javaHome() {
        return JavaPath.javaHome;
    }

    public static String nameOfJava() {
        return JavaPath.javaName;
    }

    public static boolean stillRunningAfter(Process proc, long nanos) {
        boolean intr = false;
        try {
            long start = System.nanoTime();
            if (nanos <= 0L) {
                boolean bl = proc.isAlive();
                return bl;
            }
            boolean bl = !proc.waitFor(nanos, TimeUnit.NANOSECONDS);
            return bl;
        }
        finally {
            if (intr) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static boolean stillRunningAfter(ProcessHandle proc, long nanos) {
        boolean intr = false;
        try {
            long start = System.nanoTime();
            while (true) {
                if (nanos <= 0L) {
                    boolean bl = proc.isAlive();
                    return bl;
                }
                try {
                    proc.onExit().get(nanos, TimeUnit.NANOSECONDS);
                }
                catch (InterruptedException ignored) {
                    intr = true;
                }
                catch (ExecutionException | TimeoutException exception) {
                    // empty catch block
                }
                long l = -start;
                start = System.nanoTime();
                nanos -= l + start;
            }
        }
        finally {
            if (intr) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private static String getenv(String name) {
        String envVariable = System.getenv(name);
        if (envVariable == null) {
            return "";
        }
        return envVariable;
    }

    private static final class NativeCharset {
        private static final Charset charset;

        private NativeCharset() {
        }

        static {
            Charset c;
            try {
                c = Charset.forName(System.getProperty("native.encoding", "UTF-8"));
            }
            catch (UnsupportedCharsetException ignored) {
                c = Charset.defaultCharset();
            }
            charset = c;
        }
    }

    private static final class Windows {
        private static final List<String> pathExt = Stream.of(ProcessUtil.getenv("PATHEXT").split(File.pathSeparator)).filter(s -> !s.isEmpty()).toList();

        private Windows() {
        }
    }

    private static final class PathEnv {
        private static final List<Path> path = Stream.of(ProcessUtil.getenv("PATH").split(File.pathSeparator)).filter(s -> !s.isEmpty()).map(x$0 -> Path.of(x$0, new String[0])).toList();

        private PathEnv() {
        }
    }

    private static final class JavaPath {
        private static final String javaName;
        private static final Optional<Path> javaHome;
        private static final Path javaPath;

        private JavaPath() {
        }

        static {
            String javaHomeStr = System.getProperty("java.home");
            if (javaHomeStr == null) {
                javaHomeStr = System.getenv("JAVA_HOME");
            }
            javaHome = javaHomeStr == null ? Optional.empty() : Optional.of(Path.of(javaHomeStr, new String[0]));
            javaName = OS.current() == OS.WINDOWS ? "java.exe" : "java";
            Path javaTestPath = ProcessHandle.current().info().command().map(x$0 -> Path.of(x$0, new String[0])).orElse(null);
            if (!(javaTestPath != null && Files.isExecutable(javaTestPath) || javaHomeStr == null || Files.isExecutable(javaTestPath = Path.of(javaHomeStr, "bin", javaName)))) {
                javaTestPath = null;
                if (OS.current() == OS.WINDOWS) {
                    for (String ext : Windows.pathExt) {
                        Path execPathExt = Path.of(javaHomeStr, "bin", "java" + ext);
                        if (!Files.isExecutable(execPathExt)) continue;
                        javaTestPath = execPathExt;
                        break;
                    }
                }
            }
            Path javaRelativePath = Path.of(javaName, new String[0]);
            if (javaTestPath == null) {
                javaTestPath = ProcessUtil.pathOfCommand(javaRelativePath).orElse(javaRelativePath);
            }
            javaPath = javaTestPath;
        }
    }
}

