/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.undertow.websockets.deployment;

import io.quarkus.deployment.devmode.HotReplacementContext;
import io.quarkus.deployment.devmode.HotReplacementSetup;
import io.quarkus.undertow.runtime.UndertowDeploymentRecorder;
import io.quarkus.undertow.websockets.deployment.HotReplacementWebsocketEndpoint;
import io.undertow.Handlers;
import io.undertow.predicate.Predicate;
import io.undertow.predicate.Predicates;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ServletContainer;
import io.undertow.websockets.jsr.WebSocketDeploymentInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;

public class WebsocketHotReloadSetup
implements HotReplacementSetup {
    private static Logger logger = Logger.getLogger(WebsocketHotReloadSetup.class);
    static volatile String replacementPassword;

    public void setupHotDeployment(final HotReplacementContext hotReplacementContext) {
        Optional password = ConfigProvider.getConfig().getOptionalValue("quarkus.live-reload.password", String.class);
        if (password.isPresent()) {
            replacementPassword = (String)password.get();
        } else {
            File appConfig;
            List resources = hotReplacementContext.getResourcesDir();
            if (!resources.isEmpty() && (appConfig = ((Path)resources.get(0)).resolve("application.properties").toFile()).isFile()) {
                try (FileInputStream pw = new FileInputStream(appConfig);){
                    Properties p = new Properties();
                    p.load(pw);
                    replacementPassword = p.getProperty("quarkus.live-reload.password");
                }
                catch (IOException e) {
                    logger.error((Object)"Failed to read application.properties", (Throwable)e);
                }
            }
        }
        if (replacementPassword == null) {
            return;
        }
        logger.info((Object)"Using websocket based hot deployment");
        try {
            hotReplacementContext.addPreScanStep(new Runnable(){

                @Override
                public void run() {
                    HotReplacementWebsocketEndpoint.checkForChanges(hotReplacementContext);
                }
            });
            WebSocketDeploymentInfo info = new WebSocketDeploymentInfo();
            info.addEndpoint(HotReplacementWebsocketEndpoint.class);
            DeploymentInfo d = new DeploymentInfo();
            d.setDeploymentName("hot-replacement-websockets");
            d.setContextPath("/");
            d.setClassLoader(this.getClass().getClassLoader());
            d.addServletContextAttribute("io.undertow.websockets.jsr.WebSocketDeploymentInfo", (Object)info);
            ServletContainer servletContainer = Servlets.defaultContainer();
            DeploymentManager manager = servletContainer.addDeployment(d);
            manager.deploy();
            final HttpHandler ws = manager.start();
            UndertowDeploymentRecorder.addHotDeploymentWrapper((HandlerWrapper)new HandlerWrapper(){

                public HttpHandler wrap(HttpHandler handler) {
                    return Handlers.predicate((Predicate)Predicates.path((String)"/quarkus/live-reload"), (HttpHandler)ws, (HttpHandler)handler);
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

