/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.context.ContextStorage;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdk;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdkBuilder;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.semconv.ServiceAttributes;
import io.opentelemetry.semconv.incubating.WebengineIncubatingAttributes;
import io.quarkus.arc.SyntheticCreationalContext;
import io.quarkus.opentelemetry.runtime.AutoConfiguredOpenTelemetrySdkBuilderCustomizer;
import io.quarkus.opentelemetry.runtime.DelayedAttributes;
import io.quarkus.opentelemetry.runtime.QuarkusContextStorage;
import io.quarkus.opentelemetry.runtime.config.runtime.OTelRuntimeConfig;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.runtime.configuration.DurationConverter;
import io.smallrye.config.ConfigValue;
import io.smallrye.config.SmallRyeConfig;
import io.vertx.core.Vertx;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.util.TypeLiteral;
import java.lang.annotation.Annotation;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.spi.Converter;

@Recorder
public class OpenTelemetryRecorder {
    public static final String OPEN_TELEMETRY_DRIVER = "io.opentelemetry.instrumentation.jdbc.OpenTelemetryDriver";
    private final RuntimeValue<OTelRuntimeConfig> runtimeConfig;

    public OpenTelemetryRecorder(RuntimeValue<OTelRuntimeConfig> runtimeConfig) {
        this.runtimeConfig = runtimeConfig;
    }

    public void resetGlobalOpenTelemetryForDevMode() {
        GlobalOpenTelemetry.resetForTest();
    }

    public Supplier<DelayedAttributes> delayedAttributes(final String quarkusVersion, final String serviceName, final String serviceVersion) {
        return new Supplier<DelayedAttributes>(){

            @Override
            public DelayedAttributes get() {
                DelayedAttributes result = new DelayedAttributes();
                result.setAttributesDelegate(Resource.getDefault().merge(Resource.create((Attributes)Attributes.of((AttributeKey)ServiceAttributes.SERVICE_NAME, (Object)serviceName, (AttributeKey)ServiceAttributes.SERVICE_VERSION, (Object)serviceVersion, (AttributeKey)WebengineIncubatingAttributes.WEBENGINE_NAME, (Object)"Quarkus", (AttributeKey)WebengineIncubatingAttributes.WEBENGINE_VERSION, (Object)quarkusVersion))).getAttributes());
                return result;
            }
        };
    }

    public RuntimeValue<Boolean> isOtelSdkEnabled() {
        return new RuntimeValue((Object)(!((OTelRuntimeConfig)this.runtimeConfig.getValue()).sdkDisabled() ? 1 : 0));
    }

    public void eagerlyCreateContextStorage() {
        ContextStorage.get();
    }

    public void storeVertxOnContextStorage(Supplier<Vertx> vertx) {
        QuarkusContextStorage.vertx = vertx.get();
    }

    public Function<SyntheticCreationalContext<OpenTelemetry>, OpenTelemetry> opentelemetryBean() {
        return new Function<SyntheticCreationalContext<OpenTelemetry>, OpenTelemetry>(){

            @Override
            public OpenTelemetry apply(SyntheticCreationalContext<OpenTelemetry> context) {
                Instance builderCustomizers = (Instance)context.getInjectedReference((TypeLiteral)new TypeLiteral<Instance<AutoConfiguredOpenTelemetrySdkBuilderCustomizer>>(){}, new Annotation[0]);
                Map<String, String> oTelConfigs = this.getOtelConfigs();
                OtelConfigsSupplier propertiesSupplier = new OtelConfigsSupplier(oTelConfigs);
                if (((OTelRuntimeConfig)OpenTelemetryRecorder.this.runtimeConfig.getValue()).sdkDisabled()) {
                    return AutoConfiguredOpenTelemetrySdk.builder().setResultAsGlobal().disableShutdownHook().addPropertiesSupplier((Supplier)propertiesSupplier).build().getOpenTelemetrySdk();
                }
                AutoConfiguredOpenTelemetrySdkBuilder builder = AutoConfiguredOpenTelemetrySdk.builder().setResultAsGlobal().disableShutdownHook().addPropertiesSupplier((Supplier)propertiesSupplier).setServiceClassLoader(Thread.currentThread().getContextClassLoader());
                for (AutoConfiguredOpenTelemetrySdkBuilderCustomizer customizer : builderCustomizers) {
                    customizer.customize(builder);
                }
                return builder.build().getOpenTelemetrySdk();
            }

            private Map<String, String> getOtelConfigs() {
                HashMap<String, String> oTelConfigs = new HashMap<String, String>();
                SmallRyeConfig config = (SmallRyeConfig)ConfigProvider.getConfig().unwrap(SmallRyeConfig.class);
                oTelConfigs.put("otel.java.global-autoconfigure.enabled", "true");
                oTelConfigs.put("otel.semconv-stability.opt-in", "true");
                HashMap<String, String> otel = new HashMap<String, String>();
                HashMap<String, String> quarkus = new HashMap<String, String>();
                for (String propertyName : config.getPropertyNames()) {
                    ConfigValue value;
                    if (propertyName.startsWith("quarkus.otel.")) {
                        value = config.getConfigValue(propertyName);
                        if (value.getValue() != null) {
                            if (propertyName.endsWith("timeout") || propertyName.endsWith("delay")) {
                                quarkus.put(propertyName.substring(8), OTelDurationConverter.INSTANCE.convert(value.getValue()));
                                continue;
                            }
                            quarkus.put(propertyName.substring(8), value.getValue());
                            continue;
                        }
                        if (value.getValue() != null || value.getRawValue() == null) continue;
                        config.getValue(propertyName, String.class);
                        continue;
                    }
                    if (!propertyName.startsWith("otel.") || (value = config.getConfigValue(propertyName)).getValue() == null) continue;
                    otel.put(propertyName, value.getValue());
                }
                if (((OTelRuntimeConfig)OpenTelemetryRecorder.this.runtimeConfig.getValue()).mpCompatibility()) {
                    oTelConfigs.putAll(quarkus);
                    oTelConfigs.putAll(otel);
                } else {
                    oTelConfigs.putAll(otel);
                    oTelConfigs.putAll(quarkus);
                }
                return oTelConfigs;
            }
        };
    }

    private static class OtelConfigsSupplier
    implements Supplier<Map<String, String>> {
        private final Map<String, String> oTelConfigs;

        public OtelConfigsSupplier(Map<String, String> oTelConfigs) {
            this.oTelConfigs = oTelConfigs;
        }

        @Override
        public Map<String, String> get() {
            return this.oTelConfigs;
        }
    }

    private static class OTelDurationConverter
    implements Converter<String> {
        static OTelDurationConverter INSTANCE = new OTelDurationConverter();

        private OTelDurationConverter() {
        }

        public String convert(String value) throws IllegalArgumentException, NullPointerException {
            Duration duration;
            if (value == null) {
                throw new NullPointerException();
            }
            if (DurationConverter.DIGITS.asPredicate().test(value)) {
                return value;
            }
            try {
                duration = DurationConverter.parseDuration((String)value);
            }
            catch (Exception ignored) {
                return value;
            }
            if (duration == null) {
                return value;
            }
            try {
                return String.valueOf(duration.toMillis()).concat("ms");
            }
            catch (Exception ignored) {
                return String.valueOf(duration.toSeconds()).concat("s");
            }
        }
    }
}

