/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.runtime.dev.ui;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.oidc.common.runtime.OidcCommonUtils;
import io.quarkus.oidc.common.runtime.config.OidcCommonConfig;
import io.quarkus.oidc.runtime.OidcConfig;
import io.quarkus.proxy.ProxyConfigurationRegistry;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.client.WebClientOptions;
import io.vertx.mutiny.core.MultiMap;
import io.vertx.mutiny.core.buffer.Buffer;
import io.vertx.mutiny.ext.web.client.HttpRequest;
import io.vertx.mutiny.ext.web.client.HttpResponse;
import io.vertx.mutiny.ext.web.client.WebClient;
import java.lang.annotation.Annotation;
import java.time.Duration;
import java.util.Map;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;

public final class OidcDevServicesUtils {
    private static final Logger LOG = Logger.getLogger(OidcDevServicesUtils.class);
    private static final String APPLICATION_JSON = "application/json";

    private OidcDevServicesUtils() {
    }

    public static WebClient createWebClient(Vertx vertx) {
        WebClientOptions options = new WebClientOptions();
        options.setTrustAll(true);
        options.setVerifyHost(false);
        SmallRyeConfig config = (SmallRyeConfig)ConfigProvider.getConfig().unwrap(SmallRyeConfig.class);
        OidcCommonConfig.Proxy proxyConfig = OidcConfig.getDefaultTenant((OidcConfig)((OidcConfig)config.getConfigMapping(OidcConfig.class))).proxy();
        ArcContainer container = Arc.container();
        ProxyConfigurationRegistry proxyConfigurationRegistry = container != null ? (ProxyConfigurationRegistry)container.select(ProxyConfigurationRegistry.class, new Annotation[0]).orNull() : null;
        OidcCommonUtils.toProxyOptions((OidcCommonConfig.Proxy)proxyConfig, proxyConfigurationRegistry).ifPresent(arg_0 -> ((WebClientOptions)options).setProxyOptions(arg_0));
        return WebClient.create((io.vertx.mutiny.core.Vertx)new io.vertx.mutiny.core.Vertx(vertx), (WebClientOptions)options);
    }

    public static Uni<String> getPasswordAccessToken(WebClient client, String tokenUrl, String clientId, String clientSecret, String userName, String userPassword, Map<String, String> passwordGrantOptions) {
        HttpRequest request = client.postAbs(tokenUrl);
        request.putHeader(HttpHeaders.CONTENT_TYPE.toString(), HttpHeaders.APPLICATION_X_WWW_FORM_URLENCODED.toString());
        MultiMap props = new MultiMap(io.vertx.core.MultiMap.caseInsensitiveMultiMap());
        props.add("client_id", clientId);
        if (clientSecret != null) {
            props.add("client_secret", clientSecret);
        }
        props.add("username", userName);
        props.add("password", userPassword);
        props.add("grant_type", "password");
        if (passwordGrantOptions != null) {
            props.addAll(passwordGrantOptions);
        }
        return request.sendBuffer(OidcCommonUtils.encodeForm((MultiMap)props)).onItem().transform(resp -> OidcDevServicesUtils.getAccessTokenFromJson((HttpResponse<Buffer>)resp)).onFailure().retry().withBackOff(Duration.ofSeconds(2L), Duration.ofSeconds(2L)).expireIn(10000L);
    }

    public static Uni<String> getClientCredAccessToken(WebClient client, String tokenUrl, String clientId, String clientSecret, Map<String, String> clientCredGrantOptions) {
        HttpRequest request = client.postAbs(tokenUrl);
        request.putHeader(HttpHeaders.CONTENT_TYPE.toString(), HttpHeaders.APPLICATION_X_WWW_FORM_URLENCODED.toString());
        MultiMap props = new MultiMap(io.vertx.core.MultiMap.caseInsensitiveMultiMap());
        props.add("client_id", clientId);
        if (clientSecret != null) {
            props.add("client_secret", clientSecret);
        }
        props.add("grant_type", "client_credentials");
        if (clientCredGrantOptions != null) {
            props.addAll(clientCredGrantOptions);
        }
        return request.sendBuffer(OidcCommonUtils.encodeForm((MultiMap)props)).onItem().transform(resp -> OidcDevServicesUtils.getAccessTokenFromJson((HttpResponse<Buffer>)resp));
    }

    public static Uni<String> getTokens(String tokenUrl, String clientId, String clientSecret, String authorizationCode, String redirectUri, Vertx vertxInstance, Map<String, String> grantOptions) {
        WebClient client = OidcDevServicesUtils.createWebClient(vertxInstance);
        LOG.infof("Using authorization_code grant to get a token from '%s' with client id '%s'", (Object)tokenUrl, (Object)clientId);
        HttpRequest request = client.postAbs(tokenUrl);
        request.putHeader(HttpHeaders.CONTENT_TYPE.toString(), HttpHeaders.APPLICATION_X_WWW_FORM_URLENCODED.toString());
        request.putHeader(HttpHeaders.ACCEPT.toString(), APPLICATION_JSON);
        MultiMap props = new MultiMap(io.vertx.core.MultiMap.caseInsensitiveMultiMap());
        props.add("client_id", clientId);
        if (clientSecret != null && !clientSecret.isBlank()) {
            props.add("client_secret", clientSecret);
        }
        props.add("grant_type", "authorization_code");
        props.add("code", authorizationCode);
        props.add("redirect_uri", redirectUri);
        if (grantOptions != null) {
            props.addAll(grantOptions);
        }
        return request.sendBuffer(OidcCommonUtils.encodeForm((MultiMap)props)).map(OidcDevServicesUtils::getBodyAsString).onFailure().invoke(t -> LOG.errorf("Token can not be acquired from OpenId Connect provider: %s", (Object)t.toString())).eventually(() -> ((WebClient)client).close());
    }

    public static Uni<Integer> testServiceWithToken(String serviceUrl, String token, Vertx vertxInstance) {
        LOG.infof("Test token: %s", (Object)token);
        LOG.infof("Sending token to '%s'", (Object)serviceUrl);
        WebClient client = OidcDevServicesUtils.createWebClient(vertxInstance);
        return client.getAbs(serviceUrl).putHeader(HttpHeaders.AUTHORIZATION.toString(), "Bearer " + token).send().map(HttpResponse::statusCode).invoke(statusCode -> LOG.infof("Result: %d", statusCode)).onFailure().invoke(t -> LOG.errorf("Token can not be sent to the service: %s", (Object)t.toString())).eventually(() -> ((WebClient)client).close());
    }

    public static Uni<String> testServiceWithClientCred(String tokenUrl, String serviceUrl, String clientId, String clientSecret, Vertx vertxInstance, Duration timeout, Map<String, String> clientCredGrantOptions) {
        WebClient client = OidcDevServicesUtils.createWebClient(vertxInstance);
        LOG.infof("Using a client_credentials grant to get a token token from '%s' with client id '%s'", (Object)tokenUrl, (Object)clientId);
        Uni<String> token = OidcDevServicesUtils.getClientCredAccessToken(client, tokenUrl, clientId, clientSecret, clientCredGrantOptions).ifNoItem().after(timeout).fail().invoke(t -> LOG.infof("Test token: %s", t)).onFailure().invoke(t -> LOG.errorf("Token can not be acquired from OpenId Connect provider: %s", (Object)t.toString()));
        if (serviceUrl != null) {
            token = OidcDevServicesUtils.testServiceInternal(client, serviceUrl, token);
        }
        return token.eventually(() -> ((WebClient)client).close());
    }

    public static Uni<String> testServiceWithPassword(String tokenUrl, String serviceUrl, String clientId, String clientSecret, String username, String password, Vertx vertxInstance, Duration timeout, Map<String, String> passwordGrantOptions, Map<String, String> usernameToPassword) {
        WebClient client = OidcDevServicesUtils.createWebClient(vertxInstance);
        LOG.infof("Using a password grant to get a token from '%s' for user '%s' with client id '%s'", (Object)tokenUrl, (Object)username, (Object)clientId);
        if ((password == null || password.isBlank()) && (password = usernameToPassword.get("password")) == null) {
            return Uni.createFrom().failure((Throwable)new IllegalArgumentException("Can't request access token as password is missing"));
        }
        Uni<String> token = OidcDevServicesUtils.getPasswordAccessToken(client, tokenUrl, clientId, clientSecret, username, password, passwordGrantOptions).ifNoItem().after(timeout).fail().invoke(t -> LOG.infof("Test token: %s", t)).onFailure().invoke(t -> LOG.errorf("Token can not be acquired from OpenId Connect provider: %s", (Object)t.toString()));
        if (serviceUrl != null) {
            token = OidcDevServicesUtils.testServiceInternal(client, serviceUrl, token);
        }
        return token.eventually(() -> ((WebClient)client).close());
    }

    private static Uni<String> testServiceInternal(WebClient client, String serviceUrl, Uni<String> tokenUni) {
        return tokenUni.flatMap(token -> {
            LOG.infof("Sending token to '%s'", (Object)serviceUrl);
            return client.getAbs(serviceUrl).putHeader(HttpHeaders.AUTHORIZATION.toString(), "Bearer " + token).send().map(HttpResponse::statusCode).map(Object::toString).invoke(statusCode -> LOG.infof("Result: %s", statusCode)).onFailure().invoke(t2 -> LOG.errorf("Token can not be sent to the service: %s", (Object)t2.toString()));
        });
    }

    private static String getBodyAsString(HttpResponse<Buffer> resp) {
        if (resp.statusCode() == 200) {
            return resp.bodyAsString();
        }
        String errorMessage = resp.bodyAsString();
        throw new RuntimeException(errorMessage);
    }

    private static String getAccessTokenFromJson(HttpResponse<Buffer> resp) {
        if (resp.statusCode() == 200) {
            JsonObject json = resp.bodyAsJsonObject();
            return json.getString("access_token");
        }
        String errorMessage = resp.bodyAsString();
        throw new RuntimeException(errorMessage);
    }
}

