/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.oidc.common.runtime.config;

import io.quarkus.oidc.common.runtime.config.OidcCommonConfig;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Optional;
import java.util.OptionalInt;

public abstract class OidcCommonConfigBuilder<T> {
    private Optional<String> authServerUrl;
    private Optional<Boolean> discoveryEnabled;
    private Optional<String> registrationPath;
    private Optional<Duration> connectionDelay;
    private int connectionRetryCount;
    private Duration connectionTimeout;
    private boolean useBlockingDnsLookup;
    private OptionalInt maxPoolSize;
    private boolean followRedirects;
    private Optional<String> proxyHost;
    private int proxyPort;
    private Optional<String> proxyUsername;
    private Optional<String> proxyPassword;
    private Optional<String> proxyConfigurationName;
    private OidcCommonConfig.Tls tls;

    protected OidcCommonConfigBuilder(OidcCommonConfig oidcCommonConfig) {
        this.authServerUrl = oidcCommonConfig.authServerUrl();
        this.discoveryEnabled = oidcCommonConfig.discoveryEnabled();
        this.registrationPath = oidcCommonConfig.registrationPath();
        this.connectionDelay = oidcCommonConfig.connectionDelay();
        this.connectionRetryCount = oidcCommonConfig.connectionRetryCount();
        this.connectionTimeout = oidcCommonConfig.connectionTimeout();
        this.useBlockingDnsLookup = oidcCommonConfig.useBlockingDnsLookup();
        this.maxPoolSize = oidcCommonConfig.maxPoolSize();
        this.followRedirects = oidcCommonConfig.followRedirects();
        this.proxyHost = oidcCommonConfig.proxy().host();
        this.proxyPort = oidcCommonConfig.proxy().port();
        this.proxyUsername = oidcCommonConfig.proxy().username();
        this.proxyPassword = oidcCommonConfig.proxy().password();
        this.proxyConfigurationName = oidcCommonConfig.proxy().proxyConfigurationName();
        this.tls = oidcCommonConfig.tls();
    }

    protected abstract T getBuilder();

    public T authServerUrl(String authServerUrl) {
        this.authServerUrl = Optional.ofNullable(authServerUrl);
        return this.getBuilder();
    }

    public T discoveryEnabled(boolean discoveryEnabled) {
        this.discoveryEnabled = Optional.of(discoveryEnabled);
        return this.getBuilder();
    }

    public T registrationPath(String registrationPath) {
        this.registrationPath = Optional.ofNullable(registrationPath);
        return this.getBuilder();
    }

    public T connectionDelay(Duration connectionDelay) {
        this.connectionDelay = Optional.ofNullable(connectionDelay);
        return this.getBuilder();
    }

    public T connectionRetryCount(int connectionRetryCount) {
        this.connectionRetryCount = connectionRetryCount;
        return this.getBuilder();
    }

    public T connectionTimeout(Duration connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this.getBuilder();
    }

    public T useBlockingDnsLookup(boolean useBlockingDnsLookup) {
        this.useBlockingDnsLookup = useBlockingDnsLookup;
        return this.getBuilder();
    }

    public T maxPoolSize(int maxPoolSize) {
        this.maxPoolSize = OptionalInt.of(maxPoolSize);
        return this.getBuilder();
    }

    public T followRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
        return this.getBuilder();
    }

    public T proxy(String host, int port) {
        this.proxyHost = Optional.ofNullable(host);
        this.proxyPort = port;
        return this.getBuilder();
    }

    public T proxy(String host, int port, String username, String password) {
        this.proxyHost = Optional.ofNullable(host);
        this.proxyPort = port;
        this.proxyUsername = Optional.ofNullable(username);
        this.proxyPassword = Optional.ofNullable(password);
        return this.getBuilder();
    }

    public T tlsConfigurationName(String tlsConfigurationName) {
        this.tls = new TlsImpl(tlsConfigurationName);
        return this.getBuilder();
    }

    public T proxyConfigurationName(String proxyConfigurationName) {
        this.proxyConfigurationName = Optional.ofNullable(proxyConfigurationName);
        return this.getBuilder();
    }

    private record TlsImpl(Optional<String> tlsConfigurationName, Optional<OidcCommonConfig.Tls.Verification> verification, Optional<Path> keyStoreFile, Optional<String> keyStoreFileType, Optional<String> keyStoreProvider, Optional<String> keyStorePassword, Optional<String> keyStoreKeyAlias, Optional<String> keyStoreKeyPassword, Optional<Path> trustStoreFile, Optional<String> trustStorePassword, Optional<String> trustStoreCertAlias, Optional<String> trustStoreFileType, Optional<String> trustStoreProvider) implements OidcCommonConfig.Tls
    {
        private TlsImpl(String tlsConfigurationName) {
            this(Optional.ofNullable(tlsConfigurationName), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
        }
    }

    protected static class OidcCommonConfigImpl
    implements OidcCommonConfig {
        private final Optional<String> authServerUrl;
        private final Optional<Boolean> discoveryEnabled;
        private final Optional<String> registrationPath;
        private final Optional<Duration> connectionDelay;
        private final int connectionRetryCount;
        private final Duration connectionTimeout;
        private final boolean useBlockingDnsLookup;
        private final OptionalInt maxPoolSize;
        private final boolean followRedirects;
        private final OidcCommonConfig.Proxy proxy;
        private final OidcCommonConfig.Tls tls;

        protected OidcCommonConfigImpl(OidcCommonConfigBuilder<?> builder) {
            this.authServerUrl = builder.authServerUrl;
            this.discoveryEnabled = builder.discoveryEnabled;
            this.registrationPath = builder.registrationPath;
            this.connectionDelay = builder.connectionDelay;
            this.connectionRetryCount = builder.connectionRetryCount;
            this.connectionTimeout = builder.connectionTimeout;
            this.useBlockingDnsLookup = builder.useBlockingDnsLookup;
            this.maxPoolSize = builder.maxPoolSize;
            this.followRedirects = builder.followRedirects;
            this.proxy = new ProxyImpl(builder.proxyHost, builder.proxyPort, builder.proxyUsername, builder.proxyPassword, builder.proxyConfigurationName);
            this.tls = builder.tls;
        }

        @Override
        public Optional<String> authServerUrl() {
            return this.authServerUrl;
        }

        @Override
        public Optional<Boolean> discoveryEnabled() {
            return this.discoveryEnabled;
        }

        @Override
        public Optional<String> registrationPath() {
            return this.registrationPath;
        }

        @Override
        public Optional<Duration> connectionDelay() {
            return this.connectionDelay;
        }

        @Override
        public int connectionRetryCount() {
            return this.connectionRetryCount;
        }

        @Override
        public Duration connectionTimeout() {
            return this.connectionTimeout;
        }

        @Override
        public boolean useBlockingDnsLookup() {
            return this.useBlockingDnsLookup;
        }

        @Override
        public OptionalInt maxPoolSize() {
            return this.maxPoolSize;
        }

        @Override
        public boolean followRedirects() {
            return this.followRedirects;
        }

        @Override
        public OidcCommonConfig.Proxy proxy() {
            return this.proxy;
        }

        @Override
        public OidcCommonConfig.Tls tls() {
            return this.tls;
        }
    }

    private record ProxyImpl(Optional<String> host, int port, Optional<String> username, Optional<String> password, Optional<String> proxyConfigurationName) implements OidcCommonConfig.Proxy
    {
    }
}

