/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit;

import io.quarkus.test.common.JdkUtil;
import io.quarkus.test.junit.DisabledOnSemeru;
import java.util.Optional;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.util.AnnotationUtils;

public class DisabledOnSemeruCondition
implements ExecutionCondition {
    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        Optional element = context.getElement();
        Optional optional = AnnotationUtils.findAnnotation((Optional)element, DisabledOnSemeru.class);
        if (optional.isEmpty()) {
            return ConditionEvaluationResult.enabled((String)"@DisabledOnSemeru was not found");
        }
        if (!JdkUtil.isSemeru()) {
            return ConditionEvaluationResult.enabled((String)"JVM is not identified as Semeru");
        }
        DisabledOnSemeru disabledOnSemeru = (DisabledOnSemeru)optional.get();
        if (disabledOnSemeru.versionGreaterThanOrEqualTo() > 0 || disabledOnSemeru.versionLessThanOrEqualTo() > 0) {
            if (disabledOnSemeru.versionGreaterThanOrEqualTo() > 0 && Runtime.version().feature() < disabledOnSemeru.versionGreaterThanOrEqualTo()) {
                return ConditionEvaluationResult.disabled((String)("JVM identified as Semeru and JVM version < " + disabledOnSemeru.versionGreaterThanOrEqualTo()));
            }
            if (disabledOnSemeru.versionLessThanOrEqualTo() > 0 && Runtime.version().feature() > disabledOnSemeru.versionLessThanOrEqualTo()) {
                return ConditionEvaluationResult.disabled((String)("JVM identified as Semeru and JVM version > " + disabledOnSemeru.versionLessThanOrEqualTo()));
            }
            return ConditionEvaluationResult.enabled((String)"JVM is identified as Semeru but version matches");
        }
        return ConditionEvaluationResult.disabled((String)"JVM is identified as Semeru");
    }
}

