/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.runtime.build;

import io.quarkus.devui.runtime.build.BuildMetricsDevUIController;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.List;
import java.util.Map;

@ApplicationScoped
public class BuildMetricsJsonRPCService {
    public BuildExecutionMetrics getThreadSlotRecords() {
        BuildExecutionMetrics buildExecutionMetrics = new BuildExecutionMetrics();
        Map<String, Object> buildStepMetrics = this.buildStepMetrics();
        buildExecutionMetrics.threadSlotRecords = (Map)buildStepMetrics.get("threadSlotRecords");
        buildExecutionMetrics.slots = (List)buildStepMetrics.get("slots");
        return buildExecutionMetrics;
    }

    public BuildItems getBuildItems() {
        Map<String, Object> buildStepMetrics = this.buildStepMetrics();
        BuildItems buildItems = new BuildItems();
        JsonArray items = (JsonArray)buildStepMetrics.get("items");
        if (items != null) {
            buildItems.items = items;
            buildItems.itemsCount = (Integer)buildStepMetrics.get("itemsCount");
            buildItems.enabled = true;
        } else {
            buildItems.enabled = false;
        }
        return buildItems;
    }

    public BuildMetrics getBuildMetrics() {
        BuildMetrics buildMetrics = new BuildMetrics();
        Map<String, Object> buildStepMetrics = this.buildStepMetrics();
        JsonArray records = (JsonArray)buildStepMetrics.get("records");
        Map threadSlotRecords = (Map)buildStepMetrics.get("threadSlotRecords");
        Long duration = (Long)buildStepMetrics.get("duration");
        buildMetrics.numberOfThreads = threadSlotRecords.size();
        buildMetrics.duration = duration;
        buildMetrics.records = records;
        buildMetrics.enabled = records != null;
        return buildMetrics;
    }

    public JsonObject getDependencyGraph(String buildStepId) {
        Map<String, Object> buildStepMetrics = this.buildStepMetrics();
        Map dependencyGraphs = (Map)buildStepMetrics.get("dependencyGraphs");
        if (dependencyGraphs.containsKey(buildStepId)) {
            return (JsonObject)dependencyGraphs.get(buildStepId);
        }
        return null;
    }

    private Map<String, Object> buildStepMetrics() {
        BuildMetricsDevUIController controller = BuildMetricsDevUIController.get();
        return controller.getBuildStepsMetrics();
    }

    static class BuildExecutionMetrics {
        public List<Long> slots;
        public Map<String, JsonArray> threadSlotRecords;

        BuildExecutionMetrics() {
        }
    }

    static class BuildItems {
        public boolean enabled;
        public int itemsCount;
        public JsonArray items;

        BuildItems() {
        }
    }

    static class BuildMetrics {
        public boolean enabled;
        public int numberOfThreads;
        public Long duration;
        public JsonArray records;

        BuildMetrics() {
        }
    }
}

