/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.graal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.graalvm.nativeimage.hosted.Feature;

public class SkipConsoleServiceProvidersFeature
implements Feature {
    static final HashMap<String, Set<String>> omittedServiceProviders = new HashMap(1);

    public String getDescription() {
        return "Skip unsupported console service providers when quarkus.native.auto-service-loader-registration is false";
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        try {
            Class<?> serviceCatalogSupport = Class.forName("com.oracle.svm.core.jdk.ServiceCatalogSupport");
            Method singleton = serviceCatalogSupport.getDeclaredMethod("singleton", new Class[0]);
            Method removeServices = serviceCatalogSupport.getDeclaredMethod("removeServicesFromServicesCatalog", String.class, Set.class);
            Object result = singleton.invoke(null, new Object[0]);
            omittedServiceProviders.forEach((key, value) -> {
                try {
                    removeServices.invoke(result, key, value);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        omittedServiceProviders.put("jdk.internal.io.JdkConsoleProvider", new HashSet<String>(Arrays.asList("jdk.jshell.execution.impl.ConsoleImpl$ConsoleProviderImpl", "jdk.internal.org.jline.JdkConsoleProviderImpl")));
    }
}

